/*
 * Decompiled with CFR 0.152.
 */
package org.tikv.common.log;

import java.math.BigInteger;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tikv.common.log.SlowLog;
import org.tikv.common.log.SlowLogSpan;
import org.tikv.common.log.SlowLogSpanImpl;
import org.tikv.shade.com.google.gson.JsonArray;
import org.tikv.shade.com.google.gson.JsonObject;

public class SlowLogImpl
implements SlowLog {
    private static final Logger logger = LoggerFactory.getLogger(SlowLogImpl.class);
    private static final int MAX_SPAN_SIZE = 1024;
    private static final Random random = new Random();
    private final List<SlowLogSpan> slowLogSpans = new ArrayList<SlowLogSpan>();
    private Throwable error = null;
    private final long startMS = System.currentTimeMillis();
    private final long startNS = System.nanoTime();
    private final long slowThresholdMS;
    private final long traceId;
    private long durationMS;

    public SlowLogImpl(long slowThresholdMS) {
        this.slowThresholdMS = slowThresholdMS;
        this.traceId = random.nextLong();
    }

    @Override
    public synchronized SlowLogSpan start(String name) {
        SlowLogSpanImpl slowLogSpan = new SlowLogSpanImpl(name, this.startMS, this.startNS);
        if (this.slowLogSpans.size() < 1024) {
            this.slowLogSpans.add(slowLogSpan);
        }
        slowLogSpan.start();
        return slowLogSpan;
    }

    @Override
    public long getTraceId() {
        return this.traceId;
    }

    @Override
    public long getThresholdMS() {
        return this.slowThresholdMS;
    }

    @Override
    public void setError(Throwable err) {
        this.error = err;
    }

    @Override
    public void log() {
        this.recordTime();
        if (this.error != null || this.timeExceeded()) {
            SimpleDateFormat dateFormat = new SimpleDateFormat("HH:mm:ss.SSS");
            logger.warn(String.format("A request spent %s ms. start=%s, end=%s, SlowLog:%s", this.durationMS, dateFormat.format(this.startMS), dateFormat.format(this.startMS + this.durationMS), this.getSlowLogJson().toString()));
        }
    }

    private void recordTime() {
        long currentNS = System.nanoTime();
        this.durationMS = (currentNS - this.startNS) / 1000000L;
    }

    boolean timeExceeded() {
        return this.slowThresholdMS >= 0L && this.durationMS > this.slowThresholdMS;
    }

    JsonObject getSlowLogJson() {
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("trace_id", SlowLogImpl.toUnsignedBigInteger(this.traceId));
        if (this.error != null) {
            jsonObject.addProperty("error", this.error.getMessage());
        }
        JsonArray jsonArray = new JsonArray();
        for (SlowLogSpan slowLogSpan : this.slowLogSpans) {
            jsonArray.add(slowLogSpan.toJsonElement());
        }
        jsonObject.add("spans", jsonArray);
        return jsonObject;
    }

    static BigInteger toUnsignedBigInteger(long i) {
        if (i >= 0L) {
            return BigInteger.valueOf(i);
        }
        long withoutSign = i & Long.MAX_VALUE;
        return BigInteger.valueOf(1L).shiftLeft(63).add(BigInteger.valueOf(withoutSign));
    }
}

