/*
 * Decompiled with CFR 0.152.
 */
package org.tikv.br;

import java.io.Serializable;
import org.rocksdb.Options;
import org.rocksdb.ReadOptions;
import org.tikv.br.KVDecoder;
import org.tikv.br.RawKVDecoderV1;
import org.tikv.br.SSTDecoder;
import org.tikv.common.exception.SSTDecodeException;
import org.tikv.kvproto.Brpb;

public class BackupDecoder
implements Serializable {
    private final Brpb.BackupMeta backupMeta;
    private final boolean ttlEnabled;
    private final KVDecoder kvDecoder;

    public BackupDecoder(Brpb.BackupMeta backupMeta) throws SSTDecodeException {
        this.backupMeta = backupMeta;
        this.ttlEnabled = false;
        this.kvDecoder = this.initKVDecoder();
    }

    public BackupDecoder(Brpb.BackupMeta backupMeta, boolean ttlEnabled) throws SSTDecodeException {
        this.backupMeta = backupMeta;
        this.ttlEnabled = ttlEnabled;
        this.kvDecoder = this.initKVDecoder();
    }

    private KVDecoder initKVDecoder() throws SSTDecodeException {
        if (this.backupMeta.getIsRawKv()) {
            if ("V1".equals(this.backupMeta.getApiVersion().name())) {
                return new RawKVDecoderV1(this.ttlEnabled);
            }
            throw new SSTDecodeException("does not support decode APIVersion " + this.backupMeta.getApiVersion().name());
        }
        throw new SSTDecodeException("TxnKV is not supported yet!");
    }

    public SSTDecoder decodeSST(String sstFilePath) {
        return this.decodeSST(sstFilePath, new Options(), new ReadOptions());
    }

    public SSTDecoder decodeSST(String sstFilePath, Options options, ReadOptions readOptions) {
        return new SSTDecoder(sstFilePath, this.kvDecoder, options, readOptions);
    }

    public Brpb.BackupMeta getBackupMeta() {
        return this.backupMeta;
    }
}

