/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.jdbc.internal.dialect.dm;

import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.seatunnel.api.table.catalog.TablePath;
import org.apache.seatunnel.connectors.seatunnel.jdbc.internal.converter.JdbcRowConverter;
import org.apache.seatunnel.connectors.seatunnel.jdbc.internal.dialect.JdbcDialect;
import org.apache.seatunnel.connectors.seatunnel.jdbc.internal.dialect.JdbcDialectTypeMapper;
import org.apache.seatunnel.connectors.seatunnel.jdbc.internal.dialect.dm.DmdbJdbcRowConverter;
import org.apache.seatunnel.connectors.seatunnel.jdbc.internal.dialect.dm.DmdbTypeMapper;

public class DmdbDialect
implements JdbcDialect {
    public String fieldIde;

    public DmdbDialect(String fieldIde) {
        this.fieldIde = fieldIde;
    }

    @Override
    public String dialectName() {
        return "Dameng";
    }

    @Override
    public JdbcRowConverter getRowConverter() {
        return new DmdbJdbcRowConverter();
    }

    @Override
    public JdbcDialectTypeMapper getJdbcDialectTypeMapper() {
        return new DmdbTypeMapper();
    }

    @Override
    public Optional<String> getUpsertStatement(String database, String tableName, String[] fieldNames, String[] uniqueKeyFields) {
        List nonUniqueKeyFields = Arrays.stream(fieldNames).filter(fieldName -> !Arrays.asList(uniqueKeyFields).contains(fieldName)).collect(Collectors.toList());
        String valuesBinding = Arrays.stream(fieldNames).map(fieldName -> ":" + fieldName + " " + this.quoteIdentifier((String)fieldName)).collect(Collectors.joining(", "));
        String usingClause = String.format("SELECT %s", valuesBinding);
        String onConditions = Arrays.stream(uniqueKeyFields).map(fieldName -> String.format("TARGET.%s=SOURCE.%s", this.quoteIdentifier((String)fieldName), this.quoteIdentifier((String)fieldName))).collect(Collectors.joining(" AND "));
        String updateSetClause = nonUniqueKeyFields.stream().map(fieldName -> String.format("TARGET.%s=SOURCE.%s", this.quoteIdentifier((String)fieldName), this.quoteIdentifier((String)fieldName))).collect(Collectors.joining(", "));
        String insertFields = Arrays.stream(fieldNames).map(this::quoteIdentifier).collect(Collectors.joining(", "));
        String insertValues = Arrays.stream(fieldNames).map(fieldName -> "SOURCE." + this.quoteIdentifier((String)fieldName)).collect(Collectors.joining(", "));
        String databaseName = this.tableIdentifier(database, tableName);
        String upsertSQL = String.format(" MERGE INTO %s TARGET USING (%s) SOURCE ON (%s)  WHEN MATCHED THEN UPDATE SET %s WHEN NOT MATCHED THEN INSERT (%s) VALUES (%s)", databaseName, usingClause, onConditions, updateSetClause, insertFields, insertValues);
        return Optional.of(upsertSQL);
    }

    @Override
    public String extractTableName(TablePath tablePath) {
        return tablePath.getSchemaAndTableName();
    }

    @Override
    public TablePath parse(String tablePath) {
        return TablePath.of((String)tablePath, (boolean)true);
    }

    @Override
    public String tableIdentifier(TablePath tablePath) {
        return tablePath.getSchemaAndTableName("\"");
    }

    @Override
    public String tableIdentifier(String database, String tableName) {
        if (database == null) {
            return this.quoteIdentifier(tableName);
        }
        if (tableName.contains(".")) {
            return this.quoteIdentifier(tableName);
        }
        return this.quoteDatabaseIdentifier(database) + "." + this.quoteIdentifier(tableName);
    }

    @Override
    public String quoteIdentifier(String identifier) {
        if (identifier.contains(".")) {
            String[] parts = identifier.split("\\.");
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < parts.length - 1; ++i) {
                sb.append("\"").append(parts[i]).append("\"").append(".");
            }
            return sb.append("\"").append(this.getFieldIde(parts[parts.length - 1], this.fieldIde)).append("\"").toString();
        }
        return "\"" + this.getFieldIde(identifier, this.fieldIde) + "\"";
    }
}

