/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.jdbc.catalog.psql;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.seatunnel.api.table.catalog.CatalogTable;
import org.apache.seatunnel.api.table.catalog.Column;
import org.apache.seatunnel.api.table.catalog.ConstraintKey;
import org.apache.seatunnel.api.table.catalog.PrimaryKey;
import org.apache.seatunnel.api.table.catalog.TablePath;
import org.apache.seatunnel.connectors.seatunnel.jdbc.catalog.utils.CatalogUtils;
import org.apache.seatunnel.connectors.seatunnel.jdbc.internal.dialect.psql.PostgresTypeConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PostgresCreateTableSqlBuilder {
    private static final Logger log = LoggerFactory.getLogger(PostgresCreateTableSqlBuilder.class);
    private List<Column> columns;
    private PrimaryKey primaryKey;
    private String sourceCatalogName;
    private String fieldIde;
    private List<ConstraintKey> constraintKeys;
    public Boolean isHaveConstraintKey = false;
    public List<String> createIndexSqls = new ArrayList<String>();
    private boolean createIndex;

    public PostgresCreateTableSqlBuilder(CatalogTable catalogTable, boolean createIndex) {
        this.columns = catalogTable.getTableSchema().getColumns();
        this.primaryKey = catalogTable.getTableSchema().getPrimaryKey();
        this.sourceCatalogName = catalogTable.getCatalogName();
        this.fieldIde = (String)catalogTable.getOptions().get("fieldIde");
        this.constraintKeys = catalogTable.getTableSchema().getConstraintKeys();
        this.createIndex = createIndex;
    }

    public String build(TablePath tablePath) {
        StringBuilder createTableSql = new StringBuilder();
        createTableSql.append(CatalogUtils.quoteIdentifier("CREATE TABLE ", this.fieldIde)).append(tablePath.getSchemaAndTableName("\"")).append(" (\n");
        List columnSqls = this.columns.stream().map(column -> CatalogUtils.quoteIdentifier(this.buildColumnSql((Column)column), this.fieldIde)).collect(Collectors.toList());
        if (this.createIndex && CollectionUtils.isNotEmpty(this.constraintKeys)) {
            for (ConstraintKey constraintKey : this.constraintKeys) {
                if (StringUtils.isBlank(constraintKey.getConstraintName()) || this.primaryKey != null && StringUtils.equals(this.primaryKey.getPrimaryKey(), constraintKey.getConstraintName())) continue;
                this.isHaveConstraintKey = true;
                switch (constraintKey.getConstraintType()) {
                    case UNIQUE_KEY: {
                        String uniqueKeySql = this.buildUniqueKeySql(constraintKey);
                        columnSqls.add("\t" + uniqueKeySql);
                        break;
                    }
                    case INDEX_KEY: {
                        String indexKeySql = this.buildIndexKeySql(tablePath, constraintKey);
                        this.createIndexSqls.add(indexKeySql);
                        break;
                    }
                }
            }
        }
        createTableSql.append(String.join((CharSequence)",\n", columnSqls));
        createTableSql.append("\n);");
        List commentSqls = this.columns.stream().filter(column -> StringUtils.isNotBlank(column.getComment())).map(columns -> this.buildColumnCommentSql((Column)columns, tablePath.getSchemaAndTableName("\""))).collect(Collectors.toList());
        if (!commentSqls.isEmpty()) {
            createTableSql.append("\n");
            createTableSql.append(String.join((CharSequence)";\n", commentSqls)).append(";");
        }
        return createTableSql.toString();
    }

    private String buildColumnSql(Column column) {
        StringBuilder columnSql = new StringBuilder();
        columnSql.append("\"").append(column.getName()).append("\" ");
        String columnType = StringUtils.equalsIgnoreCase("Postgres", this.sourceCatalogName) ? column.getSourceType() : this.buildColumnType(column);
        columnSql.append(columnType);
        if (!column.isNullable()) {
            columnSql.append(" NOT NULL");
        }
        if (this.createIndex && this.primaryKey != null && this.primaryKey.getColumnNames().contains(column.getName())) {
            columnSql.append(" PRIMARY KEY");
        }
        return columnSql.toString();
    }

    private String buildColumnType(Column column) {
        return PostgresTypeConverter.INSTANCE.reconvert(column).getColumnType();
    }

    private String buildColumnCommentSql(Column column, String tableName) {
        StringBuilder columnCommentSql = new StringBuilder();
        columnCommentSql.append(CatalogUtils.quoteIdentifier("COMMENT ON COLUMN ", this.fieldIde)).append(tableName).append(".");
        columnCommentSql.append(CatalogUtils.quoteIdentifier(column.getName(), this.fieldIde, "\"")).append(CatalogUtils.quoteIdentifier(" IS '", this.fieldIde)).append(column.getComment().replace("'", "''")).append("'");
        return columnCommentSql.toString();
    }

    private String buildUniqueKeySql(ConstraintKey constraintKey) {
        String constraintName = UUID.randomUUID().toString().replace("-", "");
        String indexColumns = constraintKey.getColumnNames().stream().map(constraintKeyColumn -> String.format("\"%s\"", CatalogUtils.getFieldIde(constraintKeyColumn.getColumnName(), this.fieldIde))).collect(Collectors.joining(", "));
        return "CONSTRAINT \"" + constraintName + "\" UNIQUE (" + indexColumns + ")";
    }

    private String buildIndexKeySql(TablePath tablePath, ConstraintKey constraintKey) {
        String indexColumns = constraintKey.getColumnNames().stream().map(constraintKeyColumn -> String.format("\"%s\"", CatalogUtils.getFieldIde(constraintKeyColumn.getColumnName(), this.fieldIde))).collect(Collectors.joining(", "));
        return "CREATE INDEX ON " + tablePath.getSchemaAndTableName("\"") + "(" + indexColumns + ");";
    }

    public List<String> getCreateIndexSqls() {
        return this.createIndexSqls;
    }
}

