/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.jdbc.catalog.iris;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.apache.seatunnel.api.table.catalog.CatalogTable;
import org.apache.seatunnel.api.table.catalog.Column;
import org.apache.seatunnel.api.table.catalog.ConstraintKey;
import org.apache.seatunnel.api.table.catalog.PrimaryKey;
import org.apache.seatunnel.api.table.catalog.TableIdentifier;
import org.apache.seatunnel.api.table.catalog.TablePath;
import org.apache.seatunnel.api.table.catalog.TableSchema;
import org.apache.seatunnel.api.table.catalog.exception.CatalogException;
import org.apache.seatunnel.api.table.catalog.exception.DatabaseAlreadyExistException;
import org.apache.seatunnel.api.table.catalog.exception.DatabaseNotExistException;
import org.apache.seatunnel.api.table.catalog.exception.TableAlreadyExistException;
import org.apache.seatunnel.api.table.catalog.exception.TableNotExistException;
import org.apache.seatunnel.api.table.converter.BasicTypeDefine;
import org.apache.seatunnel.common.utils.JdbcUrlUtil;
import org.apache.seatunnel.common.utils.SeaTunnelException;
import org.apache.seatunnel.connectors.seatunnel.jdbc.catalog.AbstractJdbcCatalog;
import org.apache.seatunnel.connectors.seatunnel.jdbc.catalog.iris.IrisCreateTableSqlBuilder;
import org.apache.seatunnel.connectors.seatunnel.jdbc.catalog.utils.CatalogUtils;
import org.apache.seatunnel.connectors.seatunnel.jdbc.internal.dialect.JdbcDialectTypeMapper;
import org.apache.seatunnel.connectors.seatunnel.jdbc.internal.dialect.iris.IrisTypeConverter;
import org.apache.seatunnel.connectors.seatunnel.jdbc.internal.dialect.iris.IrisTypeMapper;
import org.apache.seatunnel.shade.com.google.common.annotations.VisibleForTesting;
import org.apache.seatunnel.shade.com.google.common.base.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IrisCatalog
extends AbstractJdbcCatalog {
    private static final Logger log = LoggerFactory.getLogger(IrisCatalog.class);
    private static final String LIST_TABLES_SQL_TEMPLATE = "SELECT TABLE_SCHEMA,TABLE_NAME FROM INFORMATION_SCHEMA.Tables WHERE TABLE_SCHEMA='%s' and TABLE_TYPE != 'SYSTEM TABLE' and TABLE_TYPE != 'SYSTEM VIEW'";

    public IrisCatalog(String catalogName, String username, String password, JdbcUrlUtil.UrlInfo urlInfo) {
        super(catalogName, username, password, urlInfo, null);
    }

    @Override
    protected String getCreateTableSql(TablePath tablePath, CatalogTable table, boolean createIndex) {
        return new IrisCreateTableSqlBuilder(table, createIndex).build(tablePath);
    }

    @Override
    public String getDropTableSql(TablePath tablePath) {
        return String.format("DROP TABLE %s", tablePath.getSchemaAndTableName("\""));
    }

    @Override
    protected String getCreateDatabaseSql(String databaseName) {
        return String.format("CREATE DATABASE \"%s\"", databaseName);
    }

    @Override
    protected String getDropDatabaseSql(String databaseName) {
        return String.format("DROP DATABASE \"%s\"", databaseName);
    }

    @Override
    protected String getListTableSql(String tableSchemaName) {
        return String.format(LIST_TABLES_SQL_TEMPLATE, tableSchemaName);
    }

    @Override
    protected String getTableName(ResultSet rs) throws SQLException {
        String schemaName = rs.getString(1);
        String tableName = rs.getString(2);
        if (schemaName.startsWith("%")) {
            return null;
        }
        return schemaName + "." + tableName;
    }

    @Override
    protected Column buildColumn(ResultSet resultSet) throws SQLException {
        Long columnLength;
        String columnName = resultSet.getString("COLUMN_NAME");
        String typeName = resultSet.getString("TYPE_NAME");
        Long columnPrecision = columnLength = Long.valueOf(resultSet.getLong("COLUMN_SIZE"));
        Integer columnScale = resultSet.getObject("DECIMAL_DIGITS", Integer.class);
        String columnComment = resultSet.getString("REMARKS");
        Object defaultValue = resultSet.getObject("COLUMN_DEF");
        boolean isNullable = resultSet.getInt("NULLABLE") == 1;
        BasicTypeDefine typeDefine = BasicTypeDefine.builder().name(columnName).dataType(typeName).length(columnLength).precision(columnPrecision).scale(columnScale).nullable(isNullable).defaultValue(defaultValue).comment(columnComment).build();
        return IrisTypeConverter.INSTANCE.convert(typeDefine);
    }

    @Override
    protected String getOptionTableName(TablePath tablePath) {
        return tablePath.getSchemaAndTableName();
    }

    @Override
    public boolean databaseExists(String databaseName) throws CatalogException {
        throw new SeaTunnelException("Not supported for list databases for iris");
    }

    @Override
    public boolean tableExists(TablePath tablePath) throws CatalogException {
        try {
            return this.querySQLResultExists(this.getUrlFromDatabaseName(tablePath.getDatabaseName()), this.getTableWithConditionSql(tablePath));
        }
        catch (SQLException e) {
            throw new SeaTunnelException("Failed to querySQLResult", (Throwable)e);
        }
    }

    @Override
    protected String getTableWithConditionSql(TablePath tablePath) {
        return String.format(this.getListTableSql(tablePath.getSchemaName()) + " and TABLE_NAME = '%s'", tablePath.getTableName());
    }

    @Override
    protected String getUrlFromDatabaseName(String databaseName) {
        return this.defaultUrl;
    }

    @Override
    public List<String> listTables(String schemaName) throws CatalogException, DatabaseNotExistException {
        try {
            return this.queryString(this.defaultUrl, this.getListTableSql(schemaName), this::getTableName);
        }
        catch (Exception e) {
            throw new CatalogException(String.format("Failed listing database in catalog %s", this.catalogName), (Throwable)e);
        }
    }

    @Override
    public CatalogTable getTable(String sqlQuery) throws SQLException {
        Connection defaultConnection = this.getConnection(this.defaultUrl);
        return CatalogUtils.getCatalogTable(defaultConnection, sqlQuery, (JdbcDialectTypeMapper)new IrisTypeMapper());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public CatalogTable getTable(TablePath tablePath) throws CatalogException, TableNotExistException {
        if (!this.tableExists(tablePath)) {
            throw new TableNotExistException(this.catalogName, tablePath);
        }
        String dbUrl = StringUtils.isNotBlank(tablePath.getDatabaseName()) ? this.getUrlFromDatabaseName(tablePath.getDatabaseName()) : this.getUrlFromDatabaseName(this.defaultDatabase);
        try {
            Connection conn = this.getConnection(dbUrl);
            DatabaseMetaData metaData = conn.getMetaData();
            try (ResultSet resultSet = metaData.getColumns(null, tablePath.getSchemaName(), tablePath.getTableName(), null);){
                Optional<PrimaryKey> primaryKey = this.getPrimaryKey(metaData, tablePath);
                List<ConstraintKey> constraintKeys = this.getConstraintKeys(metaData, tablePath);
                TableSchema.Builder builder = TableSchema.builder();
                this.buildColumnsWithErrorCheck(tablePath, resultSet, builder);
                primaryKey.ifPresent(arg_0 -> ((TableSchema.Builder)builder).primaryKey(arg_0));
                constraintKeys.forEach(arg_0 -> ((TableSchema.Builder)builder).constraintKey(arg_0));
                TableIdentifier tableIdentifier = this.getTableIdentifier(tablePath);
                CatalogTable catalogTable = CatalogTable.of((TableIdentifier)tableIdentifier, (TableSchema)builder.build(), this.buildConnectorOptions(tablePath), Collections.emptyList(), (String)"", (String)this.catalogName);
                return catalogTable;
            }
        }
        catch (Exception e) {
            throw new CatalogException(String.format("Failed getting table %s", tablePath.getFullName()), (Throwable)e);
        }
    }

    @Override
    public void createDatabase(TablePath tablePath, boolean ignoreIfExists) throws DatabaseAlreadyExistException, CatalogException {
        Preconditions.checkNotNull((Object)tablePath.getDatabaseName(), (Object)"Database name cannot be null");
        this.createDatabaseInternal(tablePath.getDatabaseName());
    }

    @Override
    public void createTable(TablePath tablePath, CatalogTable table, boolean ignoreIfExists, boolean createIndex) throws TableAlreadyExistException, DatabaseNotExistException, CatalogException {
        Preconditions.checkNotNull((Object)tablePath, (Object)"Table path cannot be null");
        if (this.defaultSchema.isPresent()) {
            tablePath = new TablePath(tablePath.getDatabaseName(), (String)this.defaultSchema.get(), tablePath.getTableName());
        }
        if (this.tableExists(tablePath)) {
            if (ignoreIfExists) {
                return;
            }
            throw new TableAlreadyExistException(this.catalogName, tablePath);
        }
        this.createTableInternal(tablePath, table, createIndex);
    }

    @Override
    public void truncateTable(TablePath tablePath, boolean ignoreIfNotExists) throws TableNotExistException, CatalogException {
        Preconditions.checkNotNull((Object)tablePath, (Object)"Table path cannot be null");
        this.truncateTableInternal(tablePath);
    }

    @Override
    public void dropDatabase(TablePath tablePath, boolean ignoreIfNotExists) throws DatabaseNotExistException, CatalogException {
        Preconditions.checkNotNull((Object)tablePath, (Object)"Table path cannot be null");
        Preconditions.checkNotNull((Object)tablePath.getDatabaseName(), (Object)"Database name cannot be null");
        this.dropDatabaseInternal(tablePath.getDatabaseName());
    }

    @Override
    protected String getTruncateTableSql(TablePath tablePath) {
        return String.format("TRUNCATE TABLE \"%s\".\"%s\"", tablePath.getSchemaName(), tablePath.getTableName());
    }

    @Override
    protected String getExistDataSql(TablePath tablePath) {
        return String.format("SELECT TOP 1 * FROM \"%s\".\"%s\"", tablePath.getSchemaName(), tablePath.getTableName());
    }

    @VisibleForTesting
    public void setConnection(String url, Connection connection) {
        this.connectionMap.put(url, connection);
    }
}

