/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.jdbc.internal.executor;

import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.NClob;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.seatunnel.shade.com.google.common.annotations.VisibleForTesting;
import org.apache.seatunnel.shade.com.google.common.base.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FieldNamedPreparedStatement
implements PreparedStatement {
    private static final Logger log = LoggerFactory.getLogger(FieldNamedPreparedStatement.class);
    private final PreparedStatement statement;
    private final int[][] indexMapping;

    @Override
    public void setNull(int parameterIndex, int sqlType) throws SQLException {
        for (int index : this.indexMapping[parameterIndex - 1]) {
            this.statement.setNull(index, sqlType);
        }
    }

    @Override
    public void setBoolean(int parameterIndex, boolean x) throws SQLException {
        for (int index : this.indexMapping[parameterIndex - 1]) {
            this.statement.setBoolean(index, x);
        }
    }

    @Override
    public void setByte(int parameterIndex, byte x) throws SQLException {
        for (int index : this.indexMapping[parameterIndex - 1]) {
            this.statement.setByte(index, x);
        }
    }

    @Override
    public void setShort(int parameterIndex, short x) throws SQLException {
        for (int index : this.indexMapping[parameterIndex - 1]) {
            this.statement.setShort(index, x);
        }
    }

    @Override
    public void setInt(int parameterIndex, int x) throws SQLException {
        for (int index : this.indexMapping[parameterIndex - 1]) {
            this.statement.setInt(index, x);
        }
    }

    @Override
    public void setLong(int parameterIndex, long x) throws SQLException {
        for (int index : this.indexMapping[parameterIndex - 1]) {
            this.statement.setLong(index, x);
        }
    }

    @Override
    public void setFloat(int parameterIndex, float x) throws SQLException {
        for (int index : this.indexMapping[parameterIndex - 1]) {
            this.statement.setFloat(index, x);
        }
    }

    @Override
    public void setDouble(int parameterIndex, double x) throws SQLException {
        for (int index : this.indexMapping[parameterIndex - 1]) {
            this.statement.setDouble(index, x);
        }
    }

    @Override
    public void setBigDecimal(int parameterIndex, BigDecimal x) throws SQLException {
        for (int index : this.indexMapping[parameterIndex - 1]) {
            this.statement.setBigDecimal(index, x);
        }
    }

    @Override
    public void setString(int parameterIndex, String x) throws SQLException {
        for (int index : this.indexMapping[parameterIndex - 1]) {
            this.statement.setString(index, x);
        }
    }

    @Override
    public void setBytes(int parameterIndex, byte[] x) throws SQLException {
        for (int index : this.indexMapping[parameterIndex - 1]) {
            this.statement.setBytes(index, x);
        }
    }

    @Override
    public void setDate(int parameterIndex, Date x) throws SQLException {
        for (int index : this.indexMapping[parameterIndex - 1]) {
            this.statement.setDate(index, x);
        }
    }

    @Override
    public void setTime(int parameterIndex, Time x) throws SQLException {
        for (int index : this.indexMapping[parameterIndex - 1]) {
            this.statement.setTime(index, x);
        }
    }

    @Override
    public void setTimestamp(int parameterIndex, Timestamp x) throws SQLException {
        for (int index : this.indexMapping[parameterIndex - 1]) {
            this.statement.setTimestamp(index, x);
        }
    }

    @Override
    public void setObject(int parameterIndex, Object x, int targetSqlType) throws SQLException {
        for (int index : this.indexMapping[parameterIndex - 1]) {
            this.statement.setObject(index, x, targetSqlType);
        }
    }

    @Override
    public void setObject(int parameterIndex, Object x) throws SQLException {
        for (int index : this.indexMapping[parameterIndex - 1]) {
            this.statement.setObject(index, x);
        }
    }

    @Override
    public void setRef(int parameterIndex, Ref x) throws SQLException {
        for (int index : this.indexMapping[parameterIndex - 1]) {
            this.statement.setRef(index, x);
        }
    }

    @Override
    public void setBlob(int parameterIndex, Blob x) throws SQLException {
        for (int index : this.indexMapping[parameterIndex - 1]) {
            this.statement.setBlob(index, x);
        }
    }

    @Override
    public void setClob(int parameterIndex, Clob x) throws SQLException {
        for (int index : this.indexMapping[parameterIndex - 1]) {
            this.statement.setClob(index, x);
        }
    }

    @Override
    public void setArray(int parameterIndex, Array x) throws SQLException {
        for (int index : this.indexMapping[parameterIndex - 1]) {
            this.statement.setArray(index, x);
        }
    }

    @Override
    public void setDate(int parameterIndex, Date x, Calendar cal) throws SQLException {
        for (int index : this.indexMapping[parameterIndex - 1]) {
            this.statement.setDate(index, x, cal);
        }
    }

    @Override
    public void setTime(int parameterIndex, Time x, Calendar cal) throws SQLException {
        for (int index : this.indexMapping[parameterIndex - 1]) {
            this.statement.setTime(index, x, cal);
        }
    }

    @Override
    public void setTimestamp(int parameterIndex, Timestamp x, Calendar cal) throws SQLException {
        for (int index : this.indexMapping[parameterIndex - 1]) {
            this.statement.setTimestamp(index, x, cal);
        }
    }

    @Override
    public void setNull(int parameterIndex, int sqlType, String typeName) throws SQLException {
        for (int index : this.indexMapping[parameterIndex - 1]) {
            this.statement.setNull(index, sqlType, typeName);
        }
    }

    @Override
    public void setURL(int parameterIndex, URL x) throws SQLException {
        for (int index : this.indexMapping[parameterIndex - 1]) {
            this.statement.setURL(index, x);
        }
    }

    @Override
    public void setRowId(int parameterIndex, RowId x) throws SQLException {
        for (int index : this.indexMapping[parameterIndex - 1]) {
            this.statement.setRowId(index, x);
        }
    }

    @Override
    public void setNString(int parameterIndex, String value) throws SQLException {
        for (int index : this.indexMapping[parameterIndex - 1]) {
            this.statement.setNString(index, value);
        }
    }

    @Override
    public void setNClob(int parameterIndex, NClob value) throws SQLException {
        for (int index : this.indexMapping[parameterIndex - 1]) {
            this.statement.setNClob(index, value);
        }
    }

    @Override
    public void setNClob(int parameterIndex, Reader reader, long length) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setSQLXML(int parameterIndex, SQLXML xmlObject) throws SQLException {
        for (int index : this.indexMapping[parameterIndex - 1]) {
            this.statement.setSQLXML(index, xmlObject);
        }
    }

    @Override
    public void setObject(int parameterIndex, Object x, int targetSqlType, int scaleOrLength) throws SQLException {
        for (int index : this.indexMapping[parameterIndex - 1]) {
            this.statement.setObject(index, x, targetSqlType, scaleOrLength);
        }
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x, int length) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setUnicodeStream(int parameterIndex, InputStream x, int length) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x, int length) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader, int length) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setNCharacterStream(int parameterIndex, Reader value, long length) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setClob(int parameterIndex, Reader reader, long length) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setBlob(int parameterIndex, InputStream inputStream, long length) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x, long length) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x, long length) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader, long length) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x) throws SQLException {
        for (int index : this.indexMapping[parameterIndex - 1]) {
            this.statement.setBinaryStream(index, x);
        }
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setNCharacterStream(int parameterIndex, Reader value) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setClob(int parameterIndex, Reader reader) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setBlob(int parameterIndex, InputStream inputStream) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setNClob(int parameterIndex, Reader reader) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean execute() throws SQLException {
        return this.statement.execute();
    }

    @Override
    public void addBatch() throws SQLException {
        this.statement.addBatch();
    }

    @Override
    public ResultSet executeQuery() throws SQLException {
        return this.statement.executeQuery();
    }

    @Override
    public int executeUpdate() throws SQLException {
        return this.statement.executeUpdate();
    }

    @Override
    public void clearParameters() throws SQLException {
        this.statement.clearParameters();
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        return this.statement.getMetaData();
    }

    @Override
    public ParameterMetaData getParameterMetaData() throws SQLException {
        return this.statement.getParameterMetaData();
    }

    @Override
    public ResultSet executeQuery(String sql) throws SQLException {
        return this.statement.executeQuery(sql);
    }

    @Override
    public int executeUpdate(String sql) throws SQLException {
        return this.statement.executeUpdate(sql);
    }

    @Override
    public void close() throws SQLException {
        this.statement.close();
    }

    @Override
    public int getMaxFieldSize() throws SQLException {
        return this.statement.getMaxFieldSize();
    }

    @Override
    public void setMaxFieldSize(int max) throws SQLException {
        this.statement.setMaxFieldSize(max);
    }

    @Override
    public int getMaxRows() throws SQLException {
        return this.statement.getMaxRows();
    }

    @Override
    public void setMaxRows(int max) throws SQLException {
        this.statement.setMaxRows(max);
    }

    @Override
    public void setEscapeProcessing(boolean enable) throws SQLException {
        this.statement.setEscapeProcessing(enable);
    }

    @Override
    public int getQueryTimeout() throws SQLException {
        return this.statement.getQueryTimeout();
    }

    @Override
    public void setQueryTimeout(int seconds) throws SQLException {
        this.statement.setQueryTimeout(seconds);
    }

    @Override
    public void cancel() throws SQLException {
        this.statement.cancel();
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        return this.statement.getWarnings();
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.statement.clearWarnings();
    }

    @Override
    public void setCursorName(String name) throws SQLException {
        this.statement.setCursorName(name);
    }

    @Override
    public boolean execute(String sql) throws SQLException {
        return this.statement.execute(sql);
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        return this.statement.getResultSet();
    }

    @Override
    public int getUpdateCount() throws SQLException {
        return this.statement.getUpdateCount();
    }

    @Override
    public boolean getMoreResults() throws SQLException {
        return this.statement.getMoreResults();
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
        this.statement.setFetchDirection(direction);
    }

    @Override
    public int getFetchDirection() throws SQLException {
        return this.statement.getFetchDirection();
    }

    @Override
    public void setFetchSize(int rows) throws SQLException {
        this.statement.setFetchSize(rows);
    }

    @Override
    public int getFetchSize() throws SQLException {
        return this.statement.getFetchSize();
    }

    @Override
    public int getResultSetConcurrency() throws SQLException {
        return this.statement.getResultSetConcurrency();
    }

    @Override
    public int getResultSetType() throws SQLException {
        return this.statement.getResultSetType();
    }

    @Override
    public void addBatch(String sql) throws SQLException {
        this.statement.addBatch(sql);
    }

    @Override
    public void clearBatch() throws SQLException {
        this.statement.clearBatch();
    }

    @Override
    public int[] executeBatch() throws SQLException {
        return this.statement.executeBatch();
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.statement.getConnection();
    }

    @Override
    public boolean getMoreResults(int current) throws SQLException {
        return this.statement.getMoreResults(current);
    }

    @Override
    public ResultSet getGeneratedKeys() throws SQLException {
        return this.statement.getGeneratedKeys();
    }

    @Override
    public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        return this.statement.executeUpdate(sql, autoGeneratedKeys);
    }

    @Override
    public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        return this.statement.executeUpdate(sql, columnIndexes);
    }

    @Override
    public int executeUpdate(String sql, String[] columnNames) throws SQLException {
        return this.statement.executeUpdate(sql, columnNames);
    }

    @Override
    public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        return this.statement.execute(sql, autoGeneratedKeys);
    }

    @Override
    public boolean execute(String sql, int[] columnIndexes) throws SQLException {
        return this.statement.execute(sql, columnIndexes);
    }

    @Override
    public boolean execute(String sql, String[] columnNames) throws SQLException {
        return this.statement.execute(sql, columnNames);
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        return this.statement.getResultSetHoldability();
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.statement.isClosed();
    }

    @Override
    public void setPoolable(boolean poolable) throws SQLException {
        this.statement.setPoolable(poolable);
    }

    @Override
    public boolean isPoolable() throws SQLException {
        return this.statement.isPoolable();
    }

    @Override
    public void closeOnCompletion() throws SQLException {
        this.statement.closeOnCompletion();
    }

    @Override
    public boolean isCloseOnCompletion() throws SQLException {
        return this.statement.isCloseOnCompletion();
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        return this.statement.unwrap(iface);
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return this.statement.isWrapperFor(iface);
    }

    public static FieldNamedPreparedStatement prepareStatement(Connection connection, String sql, String[] fieldNames) throws SQLException {
        String parsedSQL;
        Preconditions.checkNotNull((Object)connection, (Object)"connection must not be null.");
        Preconditions.checkNotNull((Object)sql, (Object)"sql must not be null.");
        Preconditions.checkNotNull((Object)fieldNames, (Object)"fieldNames must not be null.");
        int[][] indexMapping = new int[fieldNames.length][];
        if (sql.contains("?")) {
            parsedSQL = sql;
            for (int i = 0; i < fieldNames.length; ++i) {
                indexMapping[i] = new int[]{i + 1};
            }
        } else {
            HashMap<String, List<Integer>> parameterMap = new HashMap<String, List<Integer>>();
            parsedSQL = FieldNamedPreparedStatement.parseNamedStatement(sql, parameterMap);
            parameterMap.keySet().forEach(namedParameter -> {
                boolean namedParameterExist = Arrays.asList(fieldNames).stream().anyMatch(field -> field.equals(namedParameter));
                Preconditions.checkArgument((boolean)namedParameterExist, (Object)String.format("Named parameters [%s] not in source columns, check SQL: %s", namedParameter, sql));
            });
            for (int i = 0; i < fieldNames.length; ++i) {
                String fieldName = fieldNames[i];
                boolean parameterExist = parameterMap.keySet().stream().anyMatch(parameter -> parameter.equals(fieldName));
                indexMapping[i] = parameterExist ? parameterMap.get(fieldName).stream().mapToInt(v -> v).toArray() : new int[]{};
            }
        }
        log.info("PrepareStatement sql is:\n{}\n", (Object)parsedSQL);
        return new FieldNamedPreparedStatement(connection.prepareStatement(parsedSQL), indexMapping);
    }

    @VisibleForTesting
    public static String parseNamedStatement(String sql, Map<String, List<Integer>> paramMap) {
        Pattern pattern = Pattern.compile(":([\\p{L}\\p{Nl}\\p{Nd}\\p{Pc}\\$\\-\\.@%&*#~!?^+=<>|]+)");
        Matcher matcher = pattern.matcher(sql);
        StringBuffer result = new StringBuffer();
        int fieldIndex = 1;
        while (matcher.find()) {
            String parameterName = matcher.group(1);
            Preconditions.checkArgument((!parameterName.isEmpty() ? 1 : 0) != 0, (Object)"Named parameters in SQL statement must not be empty.");
            paramMap.computeIfAbsent(parameterName, n -> new ArrayList()).add(fieldIndex++);
            matcher.appendReplacement(result, "?");
        }
        matcher.appendTail(result);
        return result.toString();
    }

    public FieldNamedPreparedStatement(PreparedStatement statement, int[][] indexMapping) {
        this.statement = statement;
        this.indexMapping = indexMapping;
    }
}

