/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.iotdb.sink;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.iotdb.rpc.IoTDBConnectionException;
import org.apache.iotdb.rpc.StatementExecutionException;
import org.apache.iotdb.session.Session;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.seatunnel.common.exception.CommonErrorCodeDeprecated;
import org.apache.seatunnel.common.exception.SeaTunnelErrorCode;
import org.apache.seatunnel.connectors.seatunnel.iotdb.config.SinkConfig;
import org.apache.seatunnel.connectors.seatunnel.iotdb.exception.IotdbConnectorErrorCode;
import org.apache.seatunnel.connectors.seatunnel.iotdb.exception.IotdbConnectorException;
import org.apache.seatunnel.connectors.seatunnel.iotdb.serialize.IoTDBRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IoTDBSinkClient {
    private static final Logger log = LoggerFactory.getLogger(IoTDBSinkClient.class);
    private final SinkConfig sinkConfig;
    private final List<IoTDBRecord> batchList;
    private Session session;
    private volatile boolean initialize;
    private volatile Exception flushException;

    public IoTDBSinkClient(SinkConfig sinkConfig) {
        this.sinkConfig = sinkConfig;
        this.batchList = new ArrayList<IoTDBRecord>();
    }

    private void tryInit() throws IOException {
        if (this.initialize) {
            return;
        }
        Session.Builder sessionBuilder = new Session.Builder().nodeUrls(this.sinkConfig.getNodeUrls()).username(this.sinkConfig.getUsername()).password(this.sinkConfig.getPassword());
        if (this.sinkConfig.getThriftDefaultBufferSize() != null) {
            sessionBuilder.thriftDefaultBufferSize(this.sinkConfig.getThriftDefaultBufferSize());
        }
        if (this.sinkConfig.getThriftMaxFrameSize() != null) {
            sessionBuilder.thriftMaxFrameSize(this.sinkConfig.getThriftMaxFrameSize());
        }
        if (this.sinkConfig.getZoneId() != null) {
            sessionBuilder.zoneId(this.sinkConfig.getZoneId());
        }
        this.session = sessionBuilder.build();
        try {
            if (this.sinkConfig.getConnectionTimeoutInMs() != null) {
                this.session.open(this.sinkConfig.getEnableRPCCompression(), this.sinkConfig.getConnectionTimeoutInMs());
            } else if (this.sinkConfig.getEnableRPCCompression() != null) {
                this.session.open(this.sinkConfig.getEnableRPCCompression());
            } else {
                this.session.open();
            }
        }
        catch (IoTDBConnectionException e) {
            log.error("Initialize IoTDB client failed.", (Throwable)e);
            throw new IotdbConnectorException(IotdbConnectorErrorCode.INITIALIZE_CLIENT_FAILED, "Initialize IoTDB client failed.", e);
        }
        this.initialize = true;
    }

    public synchronized void write(IoTDBRecord record) throws IOException {
        this.tryInit();
        this.checkFlushException();
        this.batchList.add(record);
        if (this.sinkConfig.getBatchSize() > 0 && this.batchList.size() >= this.sinkConfig.getBatchSize()) {
            this.flush();
        }
    }

    public synchronized void close() throws IOException {
        this.flush();
        try {
            if (this.session != null) {
                this.session.close();
            }
        }
        catch (IoTDBConnectionException e) {
            log.error("Close IoTDB client failed.", (Throwable)e);
            throw new IotdbConnectorException(IotdbConnectorErrorCode.CLOSE_CLIENT_FAILED, "Close IoTDB client failed.", e);
        }
    }

    synchronized void flush() throws IOException {
        this.checkFlushException();
        if (this.batchList.isEmpty()) {
            return;
        }
        BatchRecords batchRecords = new BatchRecords(this.batchList);
        for (int i = 0; i <= this.sinkConfig.getMaxRetries(); ++i) {
            try {
                if (batchRecords.getTypesList().isEmpty()) {
                    this.session.insertRecords(batchRecords.getDeviceIds(), batchRecords.getTimestamps(), batchRecords.getMeasurementsList(), batchRecords.getStringValuesList());
                    continue;
                }
                this.session.insertRecords(batchRecords.getDeviceIds(), batchRecords.getTimestamps(), batchRecords.getMeasurementsList(), batchRecords.getTypesList(), batchRecords.getValuesList());
                continue;
            }
            catch (IoTDBConnectionException | StatementExecutionException e) {
                log.error("Writing records to IoTDB failed, retry times = {}", (Object)i, (Object)e);
                if (i >= this.sinkConfig.getMaxRetries()) {
                    throw new IotdbConnectorException((SeaTunnelErrorCode)CommonErrorCodeDeprecated.FLUSH_DATA_FAILED, "Writing records to IoTDB failed.", e);
                }
                try {
                    long backoff = Math.min(this.sinkConfig.getRetryBackoffMultiplierMs() * i, this.sinkConfig.getMaxRetryBackoffMs());
                    Thread.sleep(backoff);
                    continue;
                }
                catch (InterruptedException ex) {
                    Thread.currentThread().interrupt();
                    throw new IotdbConnectorException((SeaTunnelErrorCode)CommonErrorCodeDeprecated.FLUSH_DATA_FAILED, "Unable to flush; interrupted while doing another attempt.", e);
                }
            }
        }
        this.batchList.clear();
    }

    private void checkFlushException() {
        if (this.flushException != null) {
            throw new IotdbConnectorException((SeaTunnelErrorCode)CommonErrorCodeDeprecated.FLUSH_DATA_FAILED, "Writing records to IoTDB failed.", this.flushException);
        }
    }

    private static class BatchRecords {
        private final List<String> deviceIds;
        private final List<Long> timestamps;
        private final List<List<String>> measurementsList;
        private final List<List<TSDataType>> typesList;
        private final List<List<Object>> valuesList;

        public BatchRecords(List<IoTDBRecord> batchList) {
            int batchSize = batchList.size();
            this.deviceIds = new ArrayList<String>(batchSize);
            this.timestamps = new ArrayList<Long>(batchSize);
            this.measurementsList = new ArrayList<List<String>>(batchSize);
            this.typesList = new ArrayList<List<TSDataType>>(batchSize);
            this.valuesList = new ArrayList<List<Object>>(batchSize);
            for (IoTDBRecord record : batchList) {
                this.deviceIds.add(record.getDevice());
                this.timestamps.add(record.getTimestamp());
                this.measurementsList.add(record.getMeasurements());
                if (record.getTypes() != null && !record.getTypes().isEmpty()) {
                    this.typesList.add(record.getTypes());
                }
                this.valuesList.add(record.getValues());
            }
        }

        private List<List<String>> getStringValuesList() {
            List<List<String>> tmp = this.valuesList;
            return tmp;
        }

        public List<String> getDeviceIds() {
            return this.deviceIds;
        }

        public List<Long> getTimestamps() {
            return this.timestamps;
        }

        public List<List<String>> getMeasurementsList() {
            return this.measurementsList;
        }

        public List<List<TSDataType>> getTypesList() {
            return this.typesList;
        }

        public List<List<Object>> getValuesList() {
            return this.valuesList;
        }
    }
}

