/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.tsfile.file.metadata.enums;

import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.iotdb.tsfile.exception.write.UnSupportedDataTypeException;

public enum TSDataType {
    BOOLEAN(0),
    INT32(1),
    INT64(2),
    FLOAT(3),
    DOUBLE(4),
    TEXT(5),
    VECTOR(6);

    private final byte type;

    private TSDataType(byte type) {
        this.type = type;
    }

    public static TSDataType deserialize(byte type) {
        return TSDataType.getTsDataType(type);
    }

    private static TSDataType getTsDataType(byte type) {
        switch (type) {
            case 0: {
                return BOOLEAN;
            }
            case 1: {
                return INT32;
            }
            case 2: {
                return INT64;
            }
            case 3: {
                return FLOAT;
            }
            case 4: {
                return DOUBLE;
            }
            case 5: {
                return TEXT;
            }
            case 6: {
                return VECTOR;
            }
        }
        throw new IllegalArgumentException("Invalid input: " + type);
    }

    public static TSDataType deserializeFrom(ByteBuffer buffer) {
        return TSDataType.deserialize(buffer.get());
    }

    public static int getSerializedSize() {
        return 1;
    }

    public void serializeTo(ByteBuffer byteBuffer) {
        byteBuffer.put(this.serialize());
    }

    public void serializeTo(DataOutputStream outputStream) throws IOException {
        outputStream.write(this.serialize());
    }

    public int getDataTypeSize() {
        switch (this) {
            case BOOLEAN: {
                return 1;
            }
            case INT32: 
            case FLOAT: {
                return 4;
            }
            case TEXT: 
            case INT64: 
            case DOUBLE: 
            case VECTOR: {
                return 8;
            }
        }
        throw new UnSupportedDataTypeException(this.toString());
    }

    public byte serialize() {
        return this.type;
    }

    public boolean isNumeric() {
        switch (this) {
            case INT32: 
            case FLOAT: 
            case INT64: 
            case DOUBLE: {
                return true;
            }
            case BOOLEAN: 
            case TEXT: 
            case VECTOR: {
                return false;
            }
        }
        throw new UnSupportedDataTypeException(this.toString());
    }
}

