/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.influxdb.client;

import java.io.IOException;
import java.net.ConnectException;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.apache.seatunnel.common.exception.SeaTunnelErrorCode;
import org.apache.seatunnel.connectors.seatunnel.influxdb.config.InfluxDBConfig;
import org.apache.seatunnel.connectors.seatunnel.influxdb.config.SinkConfig;
import org.apache.seatunnel.connectors.seatunnel.influxdb.exception.InfluxdbConnectorErrorCode;
import org.apache.seatunnel.connectors.seatunnel.influxdb.exception.InfluxdbConnectorException;
import org.influxdb.InfluxDB;
import org.influxdb.impl.InfluxDBImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import shaded.okhttp3.HttpUrl;
import shaded.okhttp3.Interceptor;
import shaded.okhttp3.OkHttpClient;
import shaded.okhttp3.Request;
import shaded.okhttp3.Response;

public class InfluxDBClient {
    private static final Logger log = LoggerFactory.getLogger(InfluxDBClient.class);

    public static InfluxDB getInfluxDB(final InfluxDBConfig config) throws ConnectException {
        OkHttpClient.Builder clientBuilder = new OkHttpClient.Builder().connectTimeout(config.getConnectTimeOut(), TimeUnit.MILLISECONDS).readTimeout(config.getQueryTimeOut(), TimeUnit.SECONDS);
        InfluxDB.ResponseFormat format = InfluxDB.ResponseFormat.valueOf(config.getFormat());
        clientBuilder.addInterceptor(new Interceptor(){

            @Override
            public Response intercept(Interceptor.Chain chain) throws IOException {
                Request request = chain.request();
                HttpUrl httpUrl = request.url().newBuilder().addQueryParameter("epoch", config.getEpoch()).build();
                Request build = request.newBuilder().url(httpUrl).build();
                return chain.proceed(build);
            }
        });
        InfluxDBImpl influxdb = new InfluxDBImpl(config.getUrl(), StringUtils.isEmpty((CharSequence)config.getUsername()) ? "" : config.getUsername(), StringUtils.isEmpty((CharSequence)config.getPassword()) ? "" : config.getPassword(), clientBuilder, format);
        String version = influxdb.version();
        if (!influxdb.ping().isGood()) {
            throw new InfluxdbConnectorException((SeaTunnelErrorCode)InfluxdbConnectorErrorCode.CONNECT_FAILED, String.format("Connect influxdb failed, the url is: {%s}", config.getUrl()));
        }
        log.info("connect influxdb successful. sever version :{}.", (Object)version);
        return influxdb;
    }

    public static void setWriteProperty(InfluxDB influxdb, SinkConfig sinkConfig) {
        String rp = sinkConfig.getRp();
        if (!StringUtils.isEmpty((CharSequence)rp)) {
            influxdb.setRetentionPolicy(rp);
        }
    }

    public static InfluxDB getWriteClient(SinkConfig sinkConfig) throws ConnectException {
        InfluxDB influxdb = InfluxDBClient.getInfluxDB(sinkConfig);
        influxdb.setDatabase(sinkConfig.getDatabase());
        InfluxDBClient.setWriteProperty(InfluxDBClient.getInfluxDB(sinkConfig), sinkConfig);
        return influxdb;
    }
}

