/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.format.text;

import java.io.IOException;
import java.math.BigDecimal;
import java.nio.charset.StandardCharsets;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.temporal.ChronoField;
import java.time.temporal.TemporalAccessor;
import java.time.temporal.TemporalQueries;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;
import org.apache.seatunnel.api.serialization.DeserializationSchema;
import org.apache.seatunnel.api.table.catalog.CatalogTable;
import org.apache.seatunnel.api.table.catalog.TablePath;
import org.apache.seatunnel.api.table.type.ArrayType;
import org.apache.seatunnel.api.table.type.MapType;
import org.apache.seatunnel.api.table.type.SeaTunnelDataType;
import org.apache.seatunnel.api.table.type.SeaTunnelRow;
import org.apache.seatunnel.api.table.type.SeaTunnelRowType;
import org.apache.seatunnel.common.exception.CommonError;
import org.apache.seatunnel.common.exception.CommonErrorCode;
import org.apache.seatunnel.common.exception.SeaTunnelErrorCode;
import org.apache.seatunnel.common.utils.DateTimeUtils;
import org.apache.seatunnel.common.utils.DateUtils;
import org.apache.seatunnel.common.utils.EncodingUtils;
import org.apache.seatunnel.common.utils.TimeUtils;
import org.apache.seatunnel.format.text.constant.TextFormatConstant;
import org.apache.seatunnel.format.text.exception.SeaTunnelTextFormatException;
import org.apache.seatunnel.format.text.splitor.DefaultTextLineSplitor;
import org.apache.seatunnel.format.text.splitor.TextLineSplitor;

public class TextDeserializationSchema
implements DeserializationSchema<SeaTunnelRow> {
    private final SeaTunnelRowType seaTunnelRowType;
    private final String[] separators;
    private final String encoding;
    private final TextLineSplitor splitor;
    private final CatalogTable catalogTable;
    public static final DateTimeFormatter TIME_FORMAT = new DateTimeFormatterBuilder().appendPattern("HH:mm:ss").appendFraction(ChronoField.NANO_OF_SECOND, 0, 9, true).toFormatter();
    public Map<String, DateTimeFormatter> fieldFormatterMap = new HashMap<String, DateTimeFormatter>();

    private TextDeserializationSchema(@NonNull SeaTunnelRowType seaTunnelRowType, String[] separators, String encoding, TextLineSplitor splitor, CatalogTable catalogTable) {
        if (seaTunnelRowType == null) {
            throw new NullPointerException("seaTunnelRowType is marked non-null but is null");
        }
        this.seaTunnelRowType = seaTunnelRowType;
        this.separators = separators;
        this.encoding = encoding;
        this.splitor = splitor;
        this.catalogTable = catalogTable;
    }

    public static Builder builder() {
        return new Builder();
    }

    public SeaTunnelRow deserialize(byte[] message) throws IOException {
        if (message == null || message.length == 0) {
            return null;
        }
        String content = new String(message, EncodingUtils.tryParseCharset((String)this.encoding));
        Map<Integer, String> splitsMap = this.splitLineBySeaTunnelRowType(content, this.seaTunnelRowType, 0);
        Object[] objects = new Object[this.seaTunnelRowType.getTotalFields()];
        for (int i = 0; i < objects.length; ++i) {
            objects[i] = this.convert(splitsMap.get(i), this.seaTunnelRowType.getFieldType(i), 0, this.seaTunnelRowType.getFieldNames()[i]);
        }
        SeaTunnelRow seaTunnelRow = new SeaTunnelRow(objects);
        Optional<TablePath> tablePath = Optional.ofNullable(this.catalogTable).map(CatalogTable::getTablePath);
        if (tablePath.isPresent()) {
            seaTunnelRow.setTableId(tablePath.toString());
        }
        return seaTunnelRow;
    }

    public SeaTunnelDataType<SeaTunnelRow> getProducedType() {
        return this.seaTunnelRowType;
    }

    private Map<Integer, String> splitLineBySeaTunnelRowType(String line, SeaTunnelRowType seaTunnelRowType, int level) {
        int i;
        String[] splits = this.splitor.spliteLine(line, this.separators[level]);
        LinkedHashMap<Integer, String> splitsMap = new LinkedHashMap<Integer, String>();
        SeaTunnelDataType[] fieldTypes = seaTunnelRowType.getFieldTypes();
        for (i = 0; i < splits.length; ++i) {
            splitsMap.put(i, splits[i]);
        }
        if (fieldTypes.length > splits.length) {
            for (i = splits.length; i < fieldTypes.length; ++i) {
                splitsMap.put(i, null);
            }
        }
        return splitsMap;
    }

    private Object convert(String field, SeaTunnelDataType<?> fieldType, int level, String fieldName) {
        if (StringUtils.isBlank(field)) {
            return null;
        }
        switch (fieldType.getSqlType()) {
            case ARRAY: {
                SeaTunnelDataType elementType = ((ArrayType)fieldType).getElementType();
                String[] elements = field.split(this.separators[level + 1]);
                ArrayList<Object> objectArrayList = new ArrayList<Object>();
                for (String element : elements) {
                    objectArrayList.add(this.convert(element, elementType, level + 1, fieldName));
                }
                switch (elementType.getSqlType()) {
                    case STRING: {
                        return objectArrayList.toArray(new String[0]);
                    }
                    case BOOLEAN: {
                        return objectArrayList.toArray(new Boolean[0]);
                    }
                    case TINYINT: {
                        return objectArrayList.toArray(new Byte[0]);
                    }
                    case SMALLINT: {
                        return objectArrayList.toArray(new Short[0]);
                    }
                    case INT: {
                        return objectArrayList.toArray(new Integer[0]);
                    }
                    case BIGINT: {
                        return objectArrayList.toArray(new Long[0]);
                    }
                    case FLOAT: {
                        return objectArrayList.toArray(new Float[0]);
                    }
                    case DOUBLE: {
                        return objectArrayList.toArray(new Double[0]);
                    }
                    case DECIMAL: {
                        return objectArrayList.toArray(new BigDecimal[0]);
                    }
                    case DATE: {
                        return objectArrayList.toArray(new LocalDate[0]);
                    }
                    case TIME: {
                        return objectArrayList.toArray(new LocalTime[0]);
                    }
                    case TIMESTAMP: {
                        return objectArrayList.toArray(new LocalDateTime[0]);
                    }
                }
                throw new SeaTunnelTextFormatException((SeaTunnelErrorCode)CommonErrorCode.UNSUPPORTED_DATA_TYPE, String.format("SeaTunnel array not support this data type [%s]", elementType.getSqlType()));
            }
            case MAP: {
                String[] kvs;
                SeaTunnelDataType keyType = ((MapType)fieldType).getKeyType();
                SeaTunnelDataType valueType = ((MapType)fieldType).getValueType();
                LinkedHashMap<Object, Object> objectMap = new LinkedHashMap<Object, Object>();
                for (String kv : kvs = field.split(this.separators[level + 1])) {
                    String[] splits = kv.split(this.separators[level + 2]);
                    if (splits.length < 2) {
                        objectMap.put(this.convert(splits[0], keyType, level + 1, fieldName), null);
                        continue;
                    }
                    objectMap.put(this.convert(splits[0], keyType, level + 1, fieldName), this.convert(splits[1], valueType, level + 1, fieldName));
                }
                return objectMap;
            }
            case STRING: {
                return field;
            }
            case BOOLEAN: {
                return Boolean.parseBoolean(field);
            }
            case TINYINT: {
                return Byte.parseByte(field);
            }
            case SMALLINT: {
                return Short.parseShort(field);
            }
            case INT: {
                return Integer.parseInt(field);
            }
            case BIGINT: {
                return Long.parseLong(field);
            }
            case FLOAT: {
                return Float.valueOf(Float.parseFloat(field));
            }
            case DOUBLE: {
                return Double.parseDouble(field);
            }
            case DECIMAL: {
                return new BigDecimal(field);
            }
            case NULL: {
                return null;
            }
            case BYTES: {
                return field.getBytes(StandardCharsets.UTF_8);
            }
            case DATE: {
                DateTimeFormatter dateFormatter = this.fieldFormatterMap.get(fieldName);
                if (dateFormatter == null) {
                    dateFormatter = DateUtils.matchDateFormatter((String)field);
                    this.fieldFormatterMap.put(fieldName, dateFormatter);
                }
                if (dateFormatter == null) {
                    throw CommonError.formatDateError((String)field, (String)fieldName);
                }
                return dateFormatter.parse(field).query(TemporalQueries.localDate());
            }
            case TIME: {
                TemporalAccessor parsedTime = TIME_FORMAT.parse(field);
                return parsedTime.query(TemporalQueries.localTime());
            }
            case TIMESTAMP: {
                DateTimeFormatter dateTimeFormatter = this.fieldFormatterMap.get(fieldName);
                if (dateTimeFormatter == null) {
                    dateTimeFormatter = DateTimeUtils.matchDateTimeFormatter((String)field);
                    this.fieldFormatterMap.put(fieldName, dateTimeFormatter);
                }
                if (dateTimeFormatter == null) {
                    throw CommonError.formatDateTimeError((String)field, (String)fieldName);
                }
                TemporalAccessor parsedTimestamp = dateTimeFormatter.parse(field);
                LocalTime localTime = parsedTimestamp.query(TemporalQueries.localTime());
                LocalDate localDate = parsedTimestamp.query(TemporalQueries.localDate());
                return LocalDateTime.of(localDate, localTime);
            }
            case ROW: {
                Map<Integer, String> splitsMap = this.splitLineBySeaTunnelRowType(field, (SeaTunnelRowType)fieldType, level + 1);
                Object[] objects = new Object[splitsMap.size()];
                String[] eleFieldNames = ((SeaTunnelRowType)fieldType).getFieldNames();
                for (int i = 0; i < objects.length; ++i) {
                    objects[i] = this.convert(splitsMap.get(i), ((SeaTunnelRowType)fieldType).getFieldType(i), level + 1, fieldName + "." + eleFieldNames[i]);
                }
                return new SeaTunnelRow(objects);
            }
        }
        throw CommonError.unsupportedDataType((String)"SeaTunnel", (String)fieldType.getSqlType().toString(), (String)fieldName);
    }

    public static class Builder {
        private SeaTunnelRowType seaTunnelRowType;
        private CatalogTable catalogTable;
        private String[] separators = (String[])TextFormatConstant.SEPARATOR.clone();
        private DateUtils.Formatter dateFormatter = DateUtils.Formatter.YYYY_MM_DD;
        private DateTimeUtils.Formatter dateTimeFormatter = DateTimeUtils.Formatter.YYYY_MM_DD_HH_MM_SS;
        private TimeUtils.Formatter timeFormatter = TimeUtils.Formatter.HH_MM_SS;
        private String encoding = StandardCharsets.UTF_8.name();
        private TextLineSplitor textLineSplitor = new DefaultTextLineSplitor();

        private Builder() {
        }

        public Builder setCatalogTable(CatalogTable catalogTable) {
            this.catalogTable = catalogTable;
            return this;
        }

        public Builder seaTunnelRowType(SeaTunnelRowType seaTunnelRowType) {
            this.seaTunnelRowType = seaTunnelRowType;
            return this;
        }

        public Builder delimiter(String delimiter) {
            this.separators[0] = delimiter;
            return this;
        }

        public Builder separators(String[] separators) {
            this.separators = separators;
            return this;
        }

        public Builder dateFormatter(DateUtils.Formatter dateFormatter) {
            this.dateFormatter = dateFormatter;
            return this;
        }

        public Builder dateTimeFormatter(DateTimeUtils.Formatter dateTimeFormatter) {
            this.dateTimeFormatter = dateTimeFormatter;
            return this;
        }

        public Builder timeFormatter(TimeUtils.Formatter timeFormatter) {
            this.timeFormatter = timeFormatter;
            return this;
        }

        public Builder encoding(String encoding) {
            this.encoding = encoding;
            return this;
        }

        public Builder textLineSplitor(TextLineSplitor splitor) {
            this.textLineSplitor = splitor;
            return this;
        }

        public TextDeserializationSchema build() {
            return new TextDeserializationSchema(this.seaTunnelRowType, this.separators, this.encoding, this.textLineSplitor, this.catalogTable);
        }
    }
}

