/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.file.sink.writer;

import java.io.IOException;
import java.io.OutputStream;
import java.util.LinkedHashMap;
import lombok.NonNull;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.seatunnel.api.table.type.SeaTunnelRow;
import org.apache.seatunnel.common.exception.CommonError;
import org.apache.seatunnel.connectors.seatunnel.file.sink.config.FileSinkConfig;
import org.apache.seatunnel.connectors.seatunnel.file.sink.util.ExcelGenerator;
import org.apache.seatunnel.connectors.seatunnel.file.sink.writer.AbstractWriteStrategy;

public class ExcelWriteStrategy
extends AbstractWriteStrategy {
    private final LinkedHashMap<String, ExcelGenerator> beingWrittenWriter = new LinkedHashMap();

    public ExcelWriteStrategy(FileSinkConfig fileSinkConfig) {
        super(fileSinkConfig);
    }

    @Override
    public void write(SeaTunnelRow seaTunnelRow) {
        super.write(seaTunnelRow);
        String filePath = this.getOrCreateFilePathBeingWritten(seaTunnelRow);
        ExcelGenerator excelGenerator = this.getOrCreateExcelGenerator(filePath);
        excelGenerator.writeData(seaTunnelRow);
    }

    @Override
    public void finishAndCloseFile() {
        this.beingWrittenWriter.forEach((k, v) -> {
            try {
                this.hadoopFileSystemProxy.createFile((String)k);
                FSDataOutputStream fileOutputStream = this.hadoopFileSystemProxy.getOutputStream((String)k);
                v.flushAndCloseExcel((OutputStream)fileOutputStream);
                fileOutputStream.close();
            }
            catch (IOException e) {
                throw CommonError.fileOperationFailed((String)"ExcelFile", (String)"write", (String)k, (Throwable)e);
            }
            this.needMoveFiles.put(k, this.getTargetLocation((String)k));
        });
        this.beingWrittenWriter.clear();
    }

    private ExcelGenerator getOrCreateExcelGenerator(@NonNull String filePath) {
        if (filePath == null) {
            throw new NullPointerException("filePath is marked non-null but is null");
        }
        ExcelGenerator excelGenerator = this.beingWrittenWriter.get(filePath);
        if (excelGenerator == null) {
            excelGenerator = new ExcelGenerator(this.sinkColumnsIndexInRow, this.seaTunnelRowType, this.fileSinkConfig);
            this.beingWrittenWriter.put(filePath, excelGenerator);
        }
        return excelGenerator;
    }
}

