/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.file.config;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;

public class HadoopConf
implements Serializable {
    private static final String HDFS_IMPL = "org.apache.hadoop.hdfs.DistributedFileSystem";
    private static final String SCHEMA = "hdfs";
    protected Map<String, String> extraOptions = new HashMap<String, String>();
    protected String hdfsNameKey;
    protected String hdfsSitePath;
    protected String remoteUser;
    private String krb5Path;
    protected String kerberosPrincipal;
    protected String kerberosKeytabPath;

    public HadoopConf(String hdfsNameKey) {
        this.hdfsNameKey = hdfsNameKey;
    }

    public String getFsHdfsImpl() {
        return HDFS_IMPL;
    }

    public String getSchema() {
        return SCHEMA;
    }

    public void setExtraOptionsForConfiguration(Configuration configuration) {
        if (!this.extraOptions.isEmpty()) {
            this.removeUnwantedOverwritingProps(this.extraOptions);
            this.extraOptions.forEach((arg_0, arg_1) -> ((Configuration)configuration).set(arg_0, arg_1));
        }
        if (StringUtils.isNotBlank(this.hdfsSitePath)) {
            Configuration hdfsSiteConfiguration = new Configuration();
            hdfsSiteConfiguration.addResource(new Path(this.hdfsSitePath));
            this.unsetUnwantedOverwritingProps(hdfsSiteConfiguration);
            configuration.addResource(hdfsSiteConfiguration);
        }
    }

    private void removeUnwantedOverwritingProps(Map extraOptions) {
        extraOptions.remove(this.getFsDefaultNameKey());
        extraOptions.remove(this.getHdfsImplKey());
        extraOptions.remove(this.getHdfsImplDisableCacheKey());
    }

    public void unsetUnwantedOverwritingProps(Configuration hdfsSiteConfiguration) {
        hdfsSiteConfiguration.unset(this.getFsDefaultNameKey());
        hdfsSiteConfiguration.unset(this.getHdfsImplKey());
        hdfsSiteConfiguration.unset(this.getHdfsImplDisableCacheKey());
    }

    public Configuration toConfiguration() {
        Configuration configuration = new Configuration();
        configuration.setBoolean("parquet.avro.readInt96AsFixed", true);
        configuration.setBoolean("parquet.avro.add-list-element-records", false);
        configuration.setBoolean("parquet.avro.write-old-list-structure", true);
        configuration.setBoolean(this.getHdfsImplDisableCacheKey(), true);
        configuration.set(this.getFsDefaultNameKey(), this.getHdfsNameKey());
        configuration.set(this.getHdfsImplKey(), this.getFsHdfsImpl());
        return configuration;
    }

    public String getFsDefaultNameKey() {
        return "fs.defaultFS";
    }

    public String getHdfsImplKey() {
        return String.format("fs.%s.impl", this.getSchema());
    }

    public String getHdfsImplDisableCacheKey() {
        return String.format("fs.%s.impl.disable.cache", this.getSchema());
    }

    public Map<String, String> getExtraOptions() {
        return this.extraOptions;
    }

    public String getHdfsNameKey() {
        return this.hdfsNameKey;
    }

    public String getHdfsSitePath() {
        return this.hdfsSitePath;
    }

    public String getRemoteUser() {
        return this.remoteUser;
    }

    public String getKrb5Path() {
        return this.krb5Path;
    }

    public String getKerberosPrincipal() {
        return this.kerberosPrincipal;
    }

    public String getKerberosKeytabPath() {
        return this.kerberosKeytabPath;
    }

    public void setExtraOptions(Map<String, String> extraOptions) {
        this.extraOptions = extraOptions;
    }

    public void setHdfsNameKey(String hdfsNameKey) {
        this.hdfsNameKey = hdfsNameKey;
    }

    public void setHdfsSitePath(String hdfsSitePath) {
        this.hdfsSitePath = hdfsSitePath;
    }

    public void setRemoteUser(String remoteUser) {
        this.remoteUser = remoteUser;
    }

    public void setKrb5Path(String krb5Path) {
        this.krb5Path = krb5Path;
    }

    public void setKerberosPrincipal(String kerberosPrincipal) {
        this.kerberosPrincipal = kerberosPrincipal;
    }

    public void setKerberosKeytabPath(String kerberosKeytabPath) {
        this.kerberosKeytabPath = kerberosKeytabPath;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof HadoopConf)) {
            return false;
        }
        HadoopConf other = (HadoopConf)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Map<String, String> this$extraOptions = this.getExtraOptions();
        Map<String, String> other$extraOptions = other.getExtraOptions();
        if (this$extraOptions == null ? other$extraOptions != null : !((Object)this$extraOptions).equals(other$extraOptions)) {
            return false;
        }
        String this$hdfsNameKey = this.getHdfsNameKey();
        String other$hdfsNameKey = other.getHdfsNameKey();
        if (this$hdfsNameKey == null ? other$hdfsNameKey != null : !this$hdfsNameKey.equals(other$hdfsNameKey)) {
            return false;
        }
        String this$hdfsSitePath = this.getHdfsSitePath();
        String other$hdfsSitePath = other.getHdfsSitePath();
        if (this$hdfsSitePath == null ? other$hdfsSitePath != null : !this$hdfsSitePath.equals(other$hdfsSitePath)) {
            return false;
        }
        String this$remoteUser = this.getRemoteUser();
        String other$remoteUser = other.getRemoteUser();
        if (this$remoteUser == null ? other$remoteUser != null : !this$remoteUser.equals(other$remoteUser)) {
            return false;
        }
        String this$krb5Path = this.getKrb5Path();
        String other$krb5Path = other.getKrb5Path();
        if (this$krb5Path == null ? other$krb5Path != null : !this$krb5Path.equals(other$krb5Path)) {
            return false;
        }
        String this$kerberosPrincipal = this.getKerberosPrincipal();
        String other$kerberosPrincipal = other.getKerberosPrincipal();
        if (this$kerberosPrincipal == null ? other$kerberosPrincipal != null : !this$kerberosPrincipal.equals(other$kerberosPrincipal)) {
            return false;
        }
        String this$kerberosKeytabPath = this.getKerberosKeytabPath();
        String other$kerberosKeytabPath = other.getKerberosKeytabPath();
        return !(this$kerberosKeytabPath == null ? other$kerberosKeytabPath != null : !this$kerberosKeytabPath.equals(other$kerberosKeytabPath));
    }

    protected boolean canEqual(Object other) {
        return other instanceof HadoopConf;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Map<String, String> $extraOptions = this.getExtraOptions();
        result = result * 59 + ($extraOptions == null ? 43 : ((Object)$extraOptions).hashCode());
        String $hdfsNameKey = this.getHdfsNameKey();
        result = result * 59 + ($hdfsNameKey == null ? 43 : $hdfsNameKey.hashCode());
        String $hdfsSitePath = this.getHdfsSitePath();
        result = result * 59 + ($hdfsSitePath == null ? 43 : $hdfsSitePath.hashCode());
        String $remoteUser = this.getRemoteUser();
        result = result * 59 + ($remoteUser == null ? 43 : $remoteUser.hashCode());
        String $krb5Path = this.getKrb5Path();
        result = result * 59 + ($krb5Path == null ? 43 : $krb5Path.hashCode());
        String $kerberosPrincipal = this.getKerberosPrincipal();
        result = result * 59 + ($kerberosPrincipal == null ? 43 : $kerberosPrincipal.hashCode());
        String $kerberosKeytabPath = this.getKerberosKeytabPath();
        result = result * 59 + ($kerberosKeytabPath == null ? 43 : $kerberosKeytabPath.hashCode());
        return result;
    }

    public String toString() {
        return "HadoopConf(extraOptions=" + this.getExtraOptions() + ", hdfsNameKey=" + this.getHdfsNameKey() + ", hdfsSitePath=" + this.getHdfsSitePath() + ", remoteUser=" + this.getRemoteUser() + ", krb5Path=" + this.getKrb5Path() + ", kerberosPrincipal=" + this.getKerberosPrincipal() + ", kerberosKeytabPath=" + this.getKerberosKeytabPath() + ")";
    }
}

