/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.file.source.reader;

import org.apache.seatunnel.api.configuration.ReadonlyConfig;
import org.apache.seatunnel.common.exception.CommonErrorCodeDeprecated;
import org.apache.seatunnel.common.exception.SeaTunnelErrorCode;
import org.apache.seatunnel.connectors.seatunnel.file.config.FileBaseSourceOptions;
import org.apache.seatunnel.connectors.seatunnel.file.config.FileFormat;
import org.apache.seatunnel.connectors.seatunnel.file.config.HadoopConf;
import org.apache.seatunnel.connectors.seatunnel.file.exception.FileConnectorException;
import org.apache.seatunnel.connectors.seatunnel.file.source.reader.ReadStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReadStrategyFactory {
    private static final Logger log = LoggerFactory.getLogger(ReadStrategyFactory.class);

    private ReadStrategyFactory() {
    }

    public static ReadStrategy of(ReadonlyConfig readonlyConfig, HadoopConf hadoopConf) {
        ReadStrategy readStrategy = ReadStrategyFactory.of(((FileFormat)readonlyConfig.get(FileBaseSourceOptions.FILE_FORMAT_TYPE)).name());
        readStrategy.setPluginConfig(readonlyConfig.toConfig());
        readStrategy.init(hadoopConf);
        return readStrategy;
    }

    public static ReadStrategy of(String fileType) {
        try {
            FileFormat fileFormat = FileFormat.valueOf(fileType.toUpperCase());
            return fileFormat.getReadStrategy();
        }
        catch (IllegalArgumentException e) {
            String errorMsg = String.format("File source connector not support this file type [%s], please check your config", fileType);
            throw new FileConnectorException((SeaTunnelErrorCode)CommonErrorCodeDeprecated.ILLEGAL_ARGUMENT, errorMsg);
        }
    }
}

