/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.file.source.reader;

import java.io.IOException;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.chrono.ChronoLocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Text;
import org.apache.seatunnel.api.configuration.ReadonlyConfig;
import org.apache.seatunnel.api.source.Collector;
import org.apache.seatunnel.api.table.type.ArrayType;
import org.apache.seatunnel.api.table.type.BasicType;
import org.apache.seatunnel.api.table.type.DecimalType;
import org.apache.seatunnel.api.table.type.LocalTimeType;
import org.apache.seatunnel.api.table.type.MapType;
import org.apache.seatunnel.api.table.type.PrimitiveByteArrayType;
import org.apache.seatunnel.api.table.type.SeaTunnelDataType;
import org.apache.seatunnel.api.table.type.SeaTunnelRow;
import org.apache.seatunnel.api.table.type.SeaTunnelRowType;
import org.apache.seatunnel.api.table.type.SqlType;
import org.apache.seatunnel.api.table.type.TypeUtil;
import org.apache.seatunnel.common.exception.CommonErrorCodeDeprecated;
import org.apache.seatunnel.common.exception.SeaTunnelErrorCode;
import org.apache.seatunnel.connectors.seatunnel.file.config.FileBaseSourceOptions;
import org.apache.seatunnel.connectors.seatunnel.file.exception.FileConnectorErrorCode;
import org.apache.seatunnel.connectors.seatunnel.file.exception.FileConnectorException;
import org.apache.seatunnel.connectors.seatunnel.file.sink.writer.OrcWriteStrategy;
import org.apache.seatunnel.connectors.seatunnel.file.source.reader.AbstractReadStrategy;
import org.apache.seatunnel.shade.com.typesafe.config.Config;
import org.apache.seatunnel.shade.connector.file.org.apache.orc.OrcFile;
import org.apache.seatunnel.shade.connector.file.org.apache.orc.Reader;
import org.apache.seatunnel.shade.connector.file.org.apache.orc.RecordReader;
import org.apache.seatunnel.shade.connector.file.org.apache.orc.TypeDescription;
import org.apache.seatunnel.shade.connector.file.org.apache.orc.storage.ql.exec.vector.BytesColumnVector;
import org.apache.seatunnel.shade.connector.file.org.apache.orc.storage.ql.exec.vector.ColumnVector;
import org.apache.seatunnel.shade.connector.file.org.apache.orc.storage.ql.exec.vector.DecimalColumnVector;
import org.apache.seatunnel.shade.connector.file.org.apache.orc.storage.ql.exec.vector.DoubleColumnVector;
import org.apache.seatunnel.shade.connector.file.org.apache.orc.storage.ql.exec.vector.ListColumnVector;
import org.apache.seatunnel.shade.connector.file.org.apache.orc.storage.ql.exec.vector.LongColumnVector;
import org.apache.seatunnel.shade.connector.file.org.apache.orc.storage.ql.exec.vector.MapColumnVector;
import org.apache.seatunnel.shade.connector.file.org.apache.orc.storage.ql.exec.vector.StructColumnVector;
import org.apache.seatunnel.shade.connector.file.org.apache.orc.storage.ql.exec.vector.TimestampColumnVector;
import org.apache.seatunnel.shade.connector.file.org.apache.orc.storage.ql.exec.vector.UnionColumnVector;
import org.apache.seatunnel.shade.connector.file.org.apache.orc.storage.ql.exec.vector.VectorizedRowBatch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OrcReadStrategy
extends AbstractReadStrategy {
    private static final Logger log = LoggerFactory.getLogger(OrcReadStrategy.class);
    private static final long MIN_SIZE = 16384L;

    @Override
    public void read(String path, String tableId, Collector<SeaTunnelRow> output) throws FileConnectorException, IOException {
        if (Boolean.FALSE.equals(this.checkFileType(path))) {
            String errorMsg = String.format("This file [%s] is not a orc file, please check the format of this file", path);
            throw new FileConnectorException((SeaTunnelErrorCode)FileConnectorErrorCode.FILE_TYPE_INVALID, errorMsg);
        }
        Map<String, String> partitionsMap = this.parsePartitionsByPath(path);
        try (Reader reader = this.hadoopFileSystemProxy.doWithHadoopAuth((configuration, userGroupInformation) -> {
            OrcFile.ReaderOptions readerOptions = OrcFile.readerOptions(configuration);
            return OrcFile.createReader(new Path(path), readerOptions);
        });){
            TypeDescription schema = TypeDescription.createStruct();
            for (int i = 0; i < this.seaTunnelRowType.getTotalFields(); ++i) {
                TypeDescription typeDescription = OrcWriteStrategy.buildFieldWithRowType(this.seaTunnelRowType.getFieldType(i));
                schema.addField(this.seaTunnelRowType.getFieldName(i), typeDescription);
            }
            List<TypeDescription> children = schema.getChildren();
            RecordReader rows = reader.rows(reader.options().schema(schema));
            VectorizedRowBatch rowBatch = schema.createRowBatch();
            while (rows.nextBatch(rowBatch)) {
                int num = 0;
                for (int i = 0; i < rowBatch.size; ++i) {
                    Object[] fields;
                    int numCols = rowBatch.numCols;
                    if (this.isMergePartition) {
                        int index = numCols;
                        fields = new Object[numCols + partitionsMap.size()];
                        for (String value : partitionsMap.values()) {
                            fields[index++] = value;
                        }
                    } else {
                        fields = new Object[numCols];
                    }
                    ColumnVector[] cols = rowBatch.cols;
                    for (int j = 0; j < numCols; ++j) {
                        fields[j] = cols[j] == null ? null : this.readColumn(cols[j], children.get(j), this.seaTunnelRowType.getFieldType(j), num);
                    }
                    SeaTunnelRow seaTunnelRow = new SeaTunnelRow(fields);
                    seaTunnelRow.setTableId(tableId);
                    output.collect((Object)seaTunnelRow);
                    ++num;
                }
            }
        }
    }

    @Override
    public SeaTunnelRowType getSeaTunnelRowTypeInfo(String path) throws FileConnectorException {
        return this.getSeaTunnelRowTypeInfoWithUserConfigRowType(path, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public SeaTunnelRowType getSeaTunnelRowTypeInfoWithUserConfigRowType(String path, SeaTunnelRowType configRowType) throws FileConnectorException {
        try (Reader reader = this.hadoopFileSystemProxy.doWithHadoopAuth((configuration, userGroupInformation) -> {
            OrcFile.ReaderOptions readerOptions = OrcFile.readerOptions(configuration);
            return OrcFile.createReader(new Path(path), readerOptions);
        });){
            TypeDescription schema = reader.getSchema();
            List<String> fieldNames = schema.getFieldNames();
            if (this.readColumns.isEmpty()) {
                this.readColumns.addAll(fieldNames);
            }
            String[] fields = new String[this.readColumns.size()];
            SeaTunnelDataType[] types = new SeaTunnelDataType[this.readColumns.size()];
            for (int i = 0; i < this.readColumns.size(); ++i) {
                fields[i] = (String)this.readColumns.get(i);
                int index = fieldNames.indexOf(this.readColumns.get(i));
                if (index == -1) {
                    throw new FileConnectorException((SeaTunnelErrorCode)CommonErrorCodeDeprecated.TABLE_SCHEMA_GET_FAILED, String.format("Column [%s] does not exists in table schema [%s]", this.readColumns.get(i), String.join((CharSequence)",", fieldNames)));
                }
                types[i] = this.orcDataType2SeaTunnelDataType(schema.getChildren().get(index), configRowType != null && configRowType.getTotalFields() > i ? configRowType.getFieldType(i) : null);
            }
            this.seaTunnelRowType = new SeaTunnelRowType(fields, types);
            this.seaTunnelRowTypeWithPartition = this.mergePartitionTypes(path, this.seaTunnelRowType);
            SeaTunnelRowType seaTunnelRowType = this.getActualSeaTunnelRowTypeInfo();
            return seaTunnelRowType;
        }
        catch (IOException e) {
            String errorMsg = String.format("Create orc reader for this file [%s] failed", path);
            throw new FileConnectorException((SeaTunnelErrorCode)CommonErrorCodeDeprecated.READER_OPERATION_FAILED, errorMsg, e);
        }
    }

    @Override
    boolean checkFileType(String path) {
        try {
            boolean checkResult;
            FSDataInputStream in = this.hadoopFileSystemProxy.getInputStream(path);
            long size = this.hadoopFileSystemProxy.getFileStatus(path).getLen();
            int readSize = (int)Math.min(size, 16384L);
            in.seek(size - (long)readSize);
            ByteBuffer buffer = ByteBuffer.allocate(readSize);
            in.readFully(buffer.array(), buffer.arrayOffset() + buffer.position(), buffer.remaining());
            int psLen = buffer.get(readSize - 1) & 0xFF;
            int len = "ORC".length();
            if (psLen < len + 1) {
                in.close();
                return false;
            }
            int offset = buffer.arrayOffset() + buffer.position() + buffer.limit() - 1 - len;
            byte[] array = buffer.array();
            if (Text.decode((byte[])array, (int)offset, (int)len).equals("ORC")) {
                checkResult = true;
            } else {
                in.seek(0L);
                byte[] header = new byte[len];
                in.readFully(header, 0, len);
                checkResult = Text.decode((byte[])header, (int)0, (int)len).equals("ORC");
            }
            in.close();
            return checkResult;
        }
        catch (IOException e) {
            String errorMsg = String.format("Check orc file [%s] failed", path);
            throw new FileConnectorException(FileConnectorErrorCode.FILE_TYPE_INVALID, errorMsg, e);
        }
    }

    private SeaTunnelDataType<?> getFinalType(SeaTunnelDataType<?> fileType, SeaTunnelDataType<?> configType) {
        if (configType == null) {
            return fileType;
        }
        return TypeUtil.canConvert(fileType, configType) ? configType : fileType;
    }

    private SeaTunnelDataType<?> orcDataType2SeaTunnelDataType(TypeDescription typeDescription, SeaTunnelDataType<?> configType) {
        switch (typeDescription.getCategory()) {
            case BOOLEAN: {
                return this.getFinalType((SeaTunnelDataType<?>)BasicType.BOOLEAN_TYPE, configType);
            }
            case INT: {
                return this.getFinalType((SeaTunnelDataType<?>)BasicType.INT_TYPE, configType);
            }
            case BYTE: {
                return this.getFinalType((SeaTunnelDataType<?>)BasicType.BYTE_TYPE, configType);
            }
            case SHORT: {
                return this.getFinalType((SeaTunnelDataType<?>)BasicType.SHORT_TYPE, configType);
            }
            case LONG: {
                return this.getFinalType((SeaTunnelDataType<?>)BasicType.LONG_TYPE, configType);
            }
            case FLOAT: {
                return this.getFinalType((SeaTunnelDataType<?>)BasicType.FLOAT_TYPE, configType);
            }
            case DOUBLE: {
                return this.getFinalType((SeaTunnelDataType<?>)BasicType.DOUBLE_TYPE, configType);
            }
            case BINARY: {
                return this.getFinalType((SeaTunnelDataType<?>)PrimitiveByteArrayType.INSTANCE, configType);
            }
            case STRING: 
            case VARCHAR: 
            case CHAR: {
                return this.getFinalType((SeaTunnelDataType<?>)BasicType.STRING_TYPE, configType);
            }
            case DATE: {
                return this.getFinalType((SeaTunnelDataType<?>)LocalTimeType.LOCAL_DATE_TYPE, configType);
            }
            case TIMESTAMP: {
                if (configType != null && configType.getSqlType().equals((Object)SqlType.TIME)) {
                    return LocalTimeType.LOCAL_TIME_TYPE;
                }
                return this.getFinalType((SeaTunnelDataType<?>)LocalTimeType.LOCAL_DATE_TIME_TYPE, configType);
            }
            case DECIMAL: {
                int precision = typeDescription.getPrecision();
                int scale = typeDescription.getScale();
                return this.getFinalType((SeaTunnelDataType<?>)new DecimalType(precision, scale), configType);
            }
            case LIST: {
                TypeDescription listType = typeDescription.getChildren().get(0);
                SeaTunnelDataType<?> seaTunnelDataType = this.orcDataType2SeaTunnelDataType(listType, null);
                if (configType instanceof ArrayType) {
                    SeaTunnelDataType elementType = ((ArrayType)configType).getElementType();
                    seaTunnelDataType = this.orcDataType2SeaTunnelDataType(listType, elementType);
                }
                switch (seaTunnelDataType.getSqlType()) {
                    case STRING: {
                        return ArrayType.STRING_ARRAY_TYPE;
                    }
                    case BOOLEAN: {
                        return ArrayType.BOOLEAN_ARRAY_TYPE;
                    }
                    case TINYINT: {
                        return ArrayType.BYTE_ARRAY_TYPE;
                    }
                    case SMALLINT: {
                        return ArrayType.SHORT_ARRAY_TYPE;
                    }
                    case INT: {
                        return ArrayType.INT_ARRAY_TYPE;
                    }
                    case BIGINT: {
                        return ArrayType.LONG_ARRAY_TYPE;
                    }
                    case FLOAT: {
                        return ArrayType.FLOAT_ARRAY_TYPE;
                    }
                    case DOUBLE: {
                        return ArrayType.DOUBLE_ARRAY_TYPE;
                    }
                }
                String errorMsg = String.format("SeaTunnel array type not supported this genericType [%s] yet", seaTunnelDataType);
                throw new FileConnectorException((SeaTunnelErrorCode)CommonErrorCodeDeprecated.UNSUPPORTED_DATA_TYPE, errorMsg);
            }
            case MAP: {
                TypeDescription keyType = typeDescription.getChildren().get(0);
                TypeDescription valueType = typeDescription.getChildren().get(1);
                if (configType instanceof MapType) {
                    SeaTunnelDataType<?> keyDataType = ((MapType)configType).getKeyType();
                    SeaTunnelDataType<?> valueDataType = ((MapType)configType).getValueType();
                    keyDataType = this.orcDataType2SeaTunnelDataType(keyType, keyDataType);
                    valueDataType = this.orcDataType2SeaTunnelDataType(valueType, valueDataType);
                    return new MapType(keyDataType, valueDataType);
                }
                return new MapType(this.orcDataType2SeaTunnelDataType(keyType, null), this.orcDataType2SeaTunnelDataType(valueType, null));
            }
            case STRUCT: {
                List<TypeDescription> children = typeDescription.getChildren();
                String[] fieldNames = typeDescription.getFieldNames().toArray(TYPE_ARRAY_STRING);
                SeaTunnelDataType[] fieldTypes = new SeaTunnelDataType[children.size()];
                if (configType instanceof SeaTunnelRowType) {
                    for (int i = 0; i < children.size(); ++i) {
                        fieldTypes[i] = this.orcDataType2SeaTunnelDataType(children.get(i), ((SeaTunnelRowType)configType).getFieldType(i));
                    }
                } else {
                    fieldTypes = (SeaTunnelDataType[])children.stream().map(f -> this.orcDataType2SeaTunnelDataType((TypeDescription)f, null)).toArray(SeaTunnelDataType[]::new);
                }
                return new SeaTunnelRowType(fieldNames, fieldTypes);
            }
        }
        String errorMsg = String.format("SeaTunnel file connector not supported this orc type [%s] yet", new Object[]{typeDescription.getCategory()});
        throw new FileConnectorException((SeaTunnelErrorCode)CommonErrorCodeDeprecated.UNSUPPORTED_DATA_TYPE, errorMsg);
    }

    private Object readColumn(ColumnVector colVec, TypeDescription colType, @Nullable SeaTunnelDataType<?> dataType, int rowNum) {
        Object columnObj = null;
        if (!colVec.isNull[rowNum]) {
            switch (colVec.type) {
                case LONG: {
                    columnObj = this.readLongVal(colVec, colType, dataType, rowNum);
                    break;
                }
                case DOUBLE: {
                    columnObj = ((DoubleColumnVector)colVec).vector[rowNum];
                    if (colType.getCategory() == TypeDescription.Category.FLOAT) {
                        columnObj = Float.valueOf(((Double)columnObj).floatValue());
                    }
                    if (dataType == null || !dataType.getSqlType().equals((Object)SqlType.STRING)) break;
                    columnObj = columnObj.toString();
                    break;
                }
                case BYTES: {
                    columnObj = this.readBytesVal(colVec, colType, dataType, rowNum);
                    break;
                }
                case DECIMAL: {
                    columnObj = this.readDecimalVal(colVec, dataType, rowNum);
                    break;
                }
                case TIMESTAMP: {
                    columnObj = this.readTimestampVal(colVec, colType, dataType, rowNum);
                    break;
                }
                case STRUCT: {
                    columnObj = this.readStructVal(colVec, colType, dataType, rowNum);
                    break;
                }
                case LIST: {
                    columnObj = this.readListVal(colVec, colType, rowNum);
                    break;
                }
                case MAP: {
                    columnObj = this.readMapVal(colVec, colType, rowNum);
                    break;
                }
                case UNION: {
                    columnObj = this.readUnionVal(colVec, colType, rowNum);
                    break;
                }
                default: {
                    throw new FileConnectorException((SeaTunnelErrorCode)CommonErrorCodeDeprecated.ILLEGAL_ARGUMENT, "ReadColumn: unsupported ORC file column type: " + colVec.type.name());
                }
            }
        }
        return columnObj;
    }

    private Object readLongVal(ColumnVector colVec, TypeDescription colType, SeaTunnelDataType<?> dataType, int rowNum) {
        Object colObj = null;
        if (!colVec.isNull[rowNum]) {
            LongColumnVector longVec = (LongColumnVector)colVec;
            long longVal = longVec.vector[rowNum];
            colObj = longVal;
            if (colType.getCategory() == TypeDescription.Category.INT) {
                colObj = (int)longVal;
            } else if (colType.getCategory() == TypeDescription.Category.BOOLEAN) {
                colObj = longVal == 1L ? Boolean.TRUE : Boolean.FALSE;
            } else if (colType.getCategory() == TypeDescription.Category.DATE) {
                colObj = LocalDate.ofEpochDay(longVal);
            } else if (colType.getCategory() == TypeDescription.Category.BYTE) {
                colObj = (byte)longVal;
            } else if (colType.getCategory() == TypeDescription.Category.SHORT) {
                colObj = (short)longVal;
            }
            if (dataType != null && dataType.getSqlType().equals((Object)SqlType.STRING)) {
                colObj = colObj.toString();
            }
        }
        return colObj;
    }

    private Object readBytesVal(ColumnVector colVec, TypeDescription typeDescription, SeaTunnelDataType<?> dataType, int rowNum) {
        Charset charset = StandardCharsets.UTF_8;
        if (this.pluginConfig != null) {
            charset = ReadonlyConfig.fromConfig((Config)this.pluginConfig).getOptional(FileBaseSourceOptions.ENCODING).map(Charset::forName).orElse(StandardCharsets.UTF_8);
        }
        Object bytesObj = null;
        if (!colVec.isNull[rowNum]) {
            BytesColumnVector bytesVector = (BytesColumnVector)colVec;
            bytesObj = this.bytesVectorToString(bytesVector, rowNum, charset);
            if (typeDescription.getCategory() == TypeDescription.Category.BINARY && bytesObj != null) {
                bytesObj = ((String)bytesObj).getBytes(charset);
            }
            if (dataType != null && dataType.getSqlType().equals((Object)SqlType.STRING) && bytesObj != null) {
                bytesObj = bytesObj.toString();
            }
        }
        return bytesObj;
    }

    private Object bytesVectorToString(BytesColumnVector bytesVector, int row, Charset charset) {
        if (bytesVector.isRepeating) {
            row = 0;
        }
        return !bytesVector.noNulls && bytesVector.isNull[row] ? null : new String(bytesVector.vector[row], bytesVector.start[row], bytesVector.length[row], charset);
    }

    private Object readDecimalVal(ColumnVector colVec, SeaTunnelDataType<?> dataType, int rowNum) {
        Object decimalObj = null;
        if (!colVec.isNull[rowNum]) {
            DecimalColumnVector decimalVec = (DecimalColumnVector)colVec;
            decimalObj = decimalVec.vector[rowNum].getHiveDecimal().bigDecimalValue();
            if (dataType != null && dataType.getSqlType().equals((Object)SqlType.STRING) && decimalObj != null) {
                decimalObj = decimalObj.toString();
            }
        }
        return decimalObj;
    }

    private Object readTimestampVal(ColumnVector colVec, TypeDescription colType, SeaTunnelDataType<?> dataType, int rowNum) {
        Object timestampVal = null;
        if (!colVec.isNull[rowNum]) {
            TimestampColumnVector timestampVec = (TimestampColumnVector)colVec;
            int nanos = timestampVec.nanos[rowNum];
            long millis = timestampVec.time[rowNum];
            Timestamp timestamp = new Timestamp(millis);
            timestamp.setNanos(nanos);
            timestampVal = timestamp.toLocalDateTime();
            if (colType.getCategory() == TypeDescription.Category.DATE) {
                timestampVal = LocalDate.ofEpochDay(timestamp.getTime());
            } else if (dataType != null && dataType.getSqlType() == SqlType.TIME) {
                timestampVal = LocalTime.of(((LocalDateTime)timestampVal).getHour(), ((LocalDateTime)timestampVal).getMinute(), ((LocalDateTime)timestampVal).getSecond(), ((LocalDateTime)timestampVal).getNano());
            }
            if (dataType != null && dataType.getSqlType().equals((Object)SqlType.STRING) && timestampVal != null) {
                timestampVal = timestampVal.toString();
            }
        }
        return timestampVal;
    }

    private Object readStructVal(ColumnVector colVec, TypeDescription colType, SeaTunnelDataType<?> dataType, int rowNum) {
        SeaTunnelRow structObj = null;
        if (!colVec.isNull[rowNum]) {
            StructColumnVector structVector = (StructColumnVector)colVec;
            ColumnVector[] fieldVec = structVector.fields;
            Object[] fieldValues = new Object[fieldVec.length];
            List<TypeDescription> fieldTypes = colType.getChildren();
            for (int i = 0; i < fieldVec.length; ++i) {
                if (dataType instanceof SeaTunnelRowType) {
                    SeaTunnelDataType fieldType = ((SeaTunnelRowType)dataType).getFieldType(i);
                    fieldValues[i] = this.readColumn(fieldVec[i], fieldTypes.get(i), fieldType, rowNum);
                    continue;
                }
                fieldValues[i] = this.readColumn(fieldVec[i], fieldTypes.get(i), null, rowNum);
            }
            structObj = new SeaTunnelRow(fieldValues);
        }
        return structObj;
    }

    private Object readMapVal(ColumnVector colVec, TypeDescription colType, int rowNum) {
        HashMap<Object, Object> objMap = new HashMap<Object, Object>();
        MapColumnVector mapVector = (MapColumnVector)colVec;
        if (this.checkMapColumnVectorTypes(mapVector)) {
            int mapSize = (int)mapVector.lengths[rowNum];
            int offset = (int)mapVector.offsets[rowNum];
            List<TypeDescription> mapTypes = colType.getChildren();
            TypeDescription keyType = mapTypes.get(0);
            TypeDescription valueType = mapTypes.get(1);
            ColumnVector keyChild = mapVector.keys;
            ColumnVector valueChild = mapVector.values;
            Object[] keyList = this.readMapVector(keyChild, keyType, offset, mapSize);
            Object[] valueList = this.readMapVector(valueChild, valueType, offset, mapSize);
            for (int i = 0; i < keyList.length; ++i) {
                objMap.put(keyList[i], valueList[i]);
            }
        } else {
            throw new FileConnectorException((SeaTunnelErrorCode)CommonErrorCodeDeprecated.ILLEGAL_ARGUMENT, "readMapVal: unsupported key or value types");
        }
        return objMap;
    }

    private boolean checkMapColumnVectorTypes(MapColumnVector mapVector) {
        ColumnVector.Type keyType = mapVector.keys.type;
        ColumnVector.Type valueType = mapVector.values.type;
        return keyType == ColumnVector.Type.BYTES || keyType == ColumnVector.Type.LONG || keyType == ColumnVector.Type.DOUBLE && valueType == ColumnVector.Type.LONG || valueType == ColumnVector.Type.DOUBLE || valueType == ColumnVector.Type.BYTES || valueType == ColumnVector.Type.DECIMAL || valueType == ColumnVector.Type.TIMESTAMP;
    }

    private Object[] readMapVector(ColumnVector mapVector, TypeDescription childType, int offset, int numValues) {
        Object[] mapList;
        switch (mapVector.type) {
            case BYTES: {
                mapList = this.readBytesListVector((BytesColumnVector)mapVector, childType, offset, numValues);
                break;
            }
            case LONG: {
                mapList = this.readLongListVector((LongColumnVector)mapVector, childType, offset, numValues);
                break;
            }
            case DOUBLE: {
                mapList = this.readDoubleListVector((DoubleColumnVector)mapVector, childType, offset, numValues);
                break;
            }
            case DECIMAL: {
                mapList = this.readDecimalListVector((DecimalColumnVector)mapVector, offset, numValues);
                break;
            }
            case TIMESTAMP: {
                mapList = this.readTimestampListVector((TimestampColumnVector)mapVector, childType, offset, numValues);
                break;
            }
            default: {
                throw new FileConnectorException((SeaTunnelErrorCode)CommonErrorCodeDeprecated.UNSUPPORTED_DATA_TYPE, mapVector.type.name() + " is not supported for MapColumnVectors");
            }
        }
        return mapList;
    }

    private Object readUnionVal(ColumnVector colVec, TypeDescription colType, int rowNum) {
        TypeDescription fieldType;
        UnionColumnVector unionVector = (UnionColumnVector)colVec;
        int tagVal = unionVector.tags[rowNum];
        List<TypeDescription> unionFieldTypes = colType.getChildren();
        if (tagVal < unionFieldTypes.size()) {
            fieldType = unionFieldTypes.get(tagVal);
            if (tagVal >= unionVector.fields.length) {
                throw new FileConnectorException((SeaTunnelErrorCode)CommonErrorCodeDeprecated.ILLEGAL_ARGUMENT, "readUnionVal: union tag value out of range for union column vectors");
            }
        } else {
            throw new FileConnectorException((SeaTunnelErrorCode)CommonErrorCodeDeprecated.ILLEGAL_ARGUMENT, "readUnionVal: union tag value out of range for union types");
        }
        ColumnVector fieldVector = unionVector.fields[tagVal];
        Object unionValue = this.readColumn(fieldVector, fieldType, null, rowNum);
        Pair<TypeDescription, Object> columnValuePair = Pair.of(fieldType, unionValue);
        return columnValuePair;
    }

    private Object readListVal(ColumnVector colVec, TypeDescription colType, int rowNum) {
        Object listValues = null;
        if (!colVec.isNull[rowNum]) {
            ListColumnVector listVector = (ListColumnVector)colVec;
            ColumnVector listChildVector = listVector.child;
            TypeDescription childType = colType.getChildren().get(0);
            switch (listChildVector.type) {
                case LONG: {
                    listValues = this.readLongListValues(listVector, childType, rowNum);
                    break;
                }
                case DOUBLE: {
                    listValues = this.readDoubleListValues(listVector, colType, rowNum);
                    break;
                }
                case BYTES: {
                    listValues = this.readBytesListValues(listVector, childType, rowNum);
                    break;
                }
                case DECIMAL: {
                    listValues = this.readDecimalListValues(listVector, rowNum);
                    break;
                }
                case TIMESTAMP: {
                    listValues = this.readTimestampListValues(listVector, childType, rowNum);
                    break;
                }
                default: {
                    throw new FileConnectorException((SeaTunnelErrorCode)CommonErrorCodeDeprecated.UNSUPPORTED_DATA_TYPE, listVector.type.name() + " is not supported for ListColumnVectors");
                }
            }
        }
        return listValues;
    }

    private Object readLongListValues(ListColumnVector listVector, TypeDescription childType, int rowNum) {
        int offset = (int)listVector.offsets[rowNum];
        int numValues = (int)listVector.lengths[rowNum];
        LongColumnVector longVector = (LongColumnVector)listVector.child;
        return this.readLongListVector(longVector, childType, offset, numValues);
    }

    private Object[] readLongListVector(LongColumnVector longVector, TypeDescription childType, int offset, int numValues) {
        ArrayList<Comparable<Boolean>> longList = new ArrayList<Comparable<Boolean>>();
        for (int i = 0; i < numValues; ++i) {
            if (!longVector.isNull[offset + i]) {
                long longVal = longVector.vector[offset + i];
                if (childType.getCategory() == TypeDescription.Category.BOOLEAN) {
                    Boolean boolVal = longVal == 0L ? Boolean.valueOf(false) : Boolean.valueOf(true);
                    longList.add(boolVal);
                    continue;
                }
                if (childType.getCategory() == TypeDescription.Category.INT) {
                    Integer intObj = (int)longVal;
                    longList.add(intObj);
                    continue;
                }
                if (childType.getCategory() == TypeDescription.Category.BYTE) {
                    Byte byteObj = (byte)longVal;
                    longList.add(byteObj);
                    continue;
                }
                if (childType.getCategory() == TypeDescription.Category.SHORT) {
                    Short shortObj = (short)longVal;
                    longList.add(shortObj);
                    continue;
                }
                longList.add(Long.valueOf(longVal));
                continue;
            }
            longList.add(null);
        }
        if (childType.getCategory() == TypeDescription.Category.BOOLEAN) {
            return longList.toArray(TYPE_ARRAY_BOOLEAN);
        }
        if (childType.getCategory() == TypeDescription.Category.INT) {
            return longList.toArray(TYPE_ARRAY_INTEGER);
        }
        if (childType.getCategory() == TypeDescription.Category.BYTE) {
            return longList.toArray(TYPE_ARRAY_BYTE);
        }
        if (childType.getCategory() == TypeDescription.Category.SHORT) {
            return longList.toArray(TYPE_ARRAY_SHORT);
        }
        return longList.toArray(TYPE_ARRAY_LONG);
    }

    private Object readDoubleListValues(ListColumnVector listVector, TypeDescription colType, int rowNum) {
        int offset = (int)listVector.offsets[rowNum];
        int numValues = (int)listVector.lengths[rowNum];
        DoubleColumnVector doubleVec = (DoubleColumnVector)listVector.child;
        return this.readDoubleListVector(doubleVec, colType, offset, numValues);
    }

    private Object[] readDoubleListVector(DoubleColumnVector doubleVec, TypeDescription colType, int offset, int numValues) {
        ArrayList<Number> doubleList = new ArrayList<Number>();
        for (int i = 0; i < numValues; ++i) {
            if (!doubleVec.isNull[offset + i]) {
                Double doubleVal = doubleVec.vector[offset + i];
                if (colType.getCategory() == TypeDescription.Category.FLOAT) {
                    doubleList.add(Float.valueOf(doubleVal.floatValue()));
                    continue;
                }
                doubleList.add(doubleVal);
                continue;
            }
            doubleList.add(null);
        }
        if (colType.getCategory() == TypeDescription.Category.FLOAT) {
            return doubleList.toArray(TYPE_ARRAY_FLOAT);
        }
        return doubleList.toArray(TYPE_ARRAY_DOUBLE);
    }

    private Object readBytesListValues(ListColumnVector listVector, TypeDescription childType, int rowNum) {
        int offset = (int)listVector.offsets[rowNum];
        int numValues = (int)listVector.lengths[rowNum];
        BytesColumnVector bytesVec = (BytesColumnVector)listVector.child;
        return this.readBytesListVector(bytesVec, childType, offset, numValues);
    }

    private Object[] readBytesListVector(BytesColumnVector bytesVec, TypeDescription childType, int offset, int numValues) {
        ArrayList<Object> bytesValList = new ArrayList<Object>();
        for (int i = 0; i < numValues; ++i) {
            if (!bytesVec.isNull[offset + i]) {
                byte[] byteArray = bytesVec.vector[offset + i];
                int vecLen = bytesVec.length[offset + i];
                int vecStart = bytesVec.start[offset + i];
                byte[] vecCopy = Arrays.copyOfRange(byteArray, vecStart, vecStart + vecLen);
                if (childType.getCategory() == TypeDescription.Category.STRING) {
                    String str = new String(vecCopy);
                    bytesValList.add(str);
                    continue;
                }
                bytesValList.add(vecCopy);
                continue;
            }
            bytesValList.add(null);
        }
        if (childType.getCategory() == TypeDescription.Category.STRING) {
            return bytesValList.toArray(TYPE_ARRAY_STRING);
        }
        return bytesValList.toArray();
    }

    private Object readDecimalListValues(ListColumnVector listVector, int rowNum) {
        int offset = (int)listVector.offsets[rowNum];
        int numValues = (int)listVector.lengths[rowNum];
        DecimalColumnVector decimalVec = (DecimalColumnVector)listVector.child;
        return this.readDecimalListVector(decimalVec, offset, numValues);
    }

    private Object[] readDecimalListVector(DecimalColumnVector decimalVector, int offset, int numValues) {
        ArrayList<BigDecimal> decimalList = new ArrayList<BigDecimal>();
        for (int i = 0; i < numValues; ++i) {
            if (!decimalVector.isNull[offset + i]) {
                BigDecimal bigDecimal = decimalVector.vector[i].getHiveDecimal().bigDecimalValue();
                decimalList.add(bigDecimal);
                continue;
            }
            decimalList.add(null);
        }
        return decimalList.toArray(TYPE_ARRAY_BIG_DECIMAL);
    }

    private Object readTimestampListValues(ListColumnVector listVector, TypeDescription childType, int rowNum) {
        int offset = (int)listVector.offsets[rowNum];
        int numValues = (int)listVector.lengths[rowNum];
        TimestampColumnVector timestampVec = (TimestampColumnVector)listVector.child;
        return this.readTimestampListVector(timestampVec, childType, offset, numValues);
    }

    private Object[] readTimestampListVector(TimestampColumnVector timestampVector, TypeDescription childType, int offset, int numValues) {
        ArrayList<Comparable<ChronoLocalDate>> timestampList = new ArrayList<Comparable<ChronoLocalDate>>();
        for (int i = 0; i < numValues; ++i) {
            if (!timestampVector.isNull[offset + i]) {
                int nanos = timestampVector.nanos[offset + i];
                long millis = timestampVector.time[offset + i];
                Timestamp timestamp = new Timestamp(millis);
                timestamp.setNanos(nanos);
                if (childType.getCategory() == TypeDescription.Category.DATE) {
                    LocalDate localDate = LocalDate.ofEpochDay(timestamp.getTime());
                    timestampList.add(localDate);
                    continue;
                }
                timestampList.add(timestamp.toLocalDateTime());
                continue;
            }
            timestampList.add(null);
        }
        if (childType.getCategory() == TypeDescription.Category.DATE) {
            return timestampList.toArray(TYPE_ARRAY_LOCAL_DATE);
        }
        return timestampList.toArray(TYPE_ARRAY_LOCAL_DATETIME);
    }
}

