/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.file.config;

import java.io.File;
import java.io.Serializable;
import java.util.Locale;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;
import org.apache.seatunnel.common.utils.DateTimeUtils;
import org.apache.seatunnel.common.utils.DateUtils;
import org.apache.seatunnel.common.utils.TimeUtils;
import org.apache.seatunnel.connectors.seatunnel.file.config.CompressFormat;
import org.apache.seatunnel.connectors.seatunnel.file.config.DelimiterConfig;
import org.apache.seatunnel.connectors.seatunnel.file.config.FileBaseSinkOptions;
import org.apache.seatunnel.connectors.seatunnel.file.config.FileFormat;
import org.apache.seatunnel.shade.com.google.common.base.Preconditions;
import org.apache.seatunnel.shade.com.typesafe.config.Config;

public class BaseFileSinkConfig
implements DelimiterConfig,
Serializable {
    private static final long serialVersionUID = 1L;
    protected CompressFormat compressFormat = (CompressFormat)FileBaseSinkOptions.COMPRESS_CODEC.defaultValue();
    protected String fieldDelimiter;
    protected int sheetMaxRows = (Integer)FileBaseSinkOptions.SHEET_MAX_ROWS.defaultValue();
    protected String rowDelimiter = (String)FileBaseSinkOptions.ROW_DELIMITER.defaultValue();
    protected int batchSize = (Integer)FileBaseSinkOptions.BATCH_SIZE.defaultValue();
    protected String path;
    protected String fileNameExpression = (String)FileBaseSinkOptions.FILE_NAME_EXPRESSION.defaultValue();
    protected boolean singleFileMode = (Boolean)FileBaseSinkOptions.SINGLE_FILE_MODE.defaultValue();
    protected boolean createEmptyFileWhenNoData = (Boolean)FileBaseSinkOptions.CREATE_EMPTY_FILE_WHEN_NO_DATA.defaultValue();
    protected FileFormat fileFormat;
    protected String filenameExtension = (String)FileBaseSinkOptions.FILENAME_EXTENSION.defaultValue();
    protected DateUtils.Formatter dateFormat = DateUtils.Formatter.YYYY_MM_DD;
    protected DateTimeUtils.Formatter datetimeFormat = DateTimeUtils.Formatter.YYYY_MM_DD_HH_MM_SS;
    protected TimeUtils.Formatter timeFormat = TimeUtils.Formatter.HH_MM_SS;
    protected Boolean enableHeaderWriter = false;

    public BaseFileSinkConfig(@NonNull Config config) {
        if (config == null) {
            throw new NullPointerException("config is marked non-null but is null");
        }
        if (config.hasPath(FileBaseSinkOptions.COMPRESS_CODEC.key())) {
            String compressCodec = config.getString(FileBaseSinkOptions.COMPRESS_CODEC.key());
            this.compressFormat = CompressFormat.valueOf(compressCodec.toUpperCase());
        }
        if (config.hasPath(FileBaseSinkOptions.BATCH_SIZE.key())) {
            this.batchSize = config.getInt(FileBaseSinkOptions.BATCH_SIZE.key());
        }
        if (config.hasPath(FileBaseSinkOptions.SHEET_MAX_ROWS.key()) && StringUtils.isNotEmpty(config.getString(FileBaseSinkOptions.SHEET_MAX_ROWS.key()))) {
            this.sheetMaxRows = config.getInt(FileBaseSinkOptions.SHEET_MAX_ROWS.key());
        }
        if (config.hasPath(FileBaseSinkOptions.ROW_DELIMITER.key())) {
            this.rowDelimiter = config.getString(FileBaseSinkOptions.ROW_DELIMITER.key());
        }
        if (config.hasPath(FileBaseSinkOptions.FILE_PATH.key()) && !StringUtils.isBlank(config.getString(FileBaseSinkOptions.FILE_PATH.key()))) {
            this.path = config.getString(FileBaseSinkOptions.FILE_PATH.key());
        }
        Preconditions.checkNotNull((Object)this.path);
        if (this.path.equals(File.separator)) {
            this.path = "";
        }
        if (config.hasPath(FileBaseSinkOptions.FILE_NAME_EXPRESSION.key()) && !StringUtils.isBlank(config.getString(FileBaseSinkOptions.FILE_NAME_EXPRESSION.key()))) {
            this.fileNameExpression = config.getString(FileBaseSinkOptions.FILE_NAME_EXPRESSION.key());
        }
        if (config.hasPath(FileBaseSinkOptions.SINGLE_FILE_MODE.key())) {
            this.singleFileMode = config.getBoolean(FileBaseSinkOptions.SINGLE_FILE_MODE.key());
        }
        if (config.hasPath(FileBaseSinkOptions.CREATE_EMPTY_FILE_WHEN_NO_DATA.key())) {
            this.createEmptyFileWhenNoData = config.getBoolean(FileBaseSinkOptions.CREATE_EMPTY_FILE_WHEN_NO_DATA.key());
        }
        this.fileFormat = config.hasPath(FileBaseSinkOptions.FILE_FORMAT_TYPE.key()) && !StringUtils.isBlank(config.getString(FileBaseSinkOptions.FILE_FORMAT_TYPE.key())) ? FileFormat.valueOf(config.getString(FileBaseSinkOptions.FILE_FORMAT_TYPE.key()).toUpperCase(Locale.ROOT)) : (FileFormat)FileBaseSinkOptions.FILE_FORMAT_TYPE.defaultValue();
        this.fieldDelimiter = config.hasPath(FileBaseSinkOptions.FIELD_DELIMITER.key()) && StringUtils.isNotEmpty(config.getString(FileBaseSinkOptions.FIELD_DELIMITER.key())) ? config.getString(FileBaseSinkOptions.FIELD_DELIMITER.key()) : (FileFormat.CSV.equals(this.fileFormat) ? "," : (String)FileBaseSinkOptions.FIELD_DELIMITER.defaultValue());
        if (config.hasPath(FileBaseSinkOptions.FILENAME_EXTENSION.key()) && !StringUtils.isBlank(config.getString(FileBaseSinkOptions.FILENAME_EXTENSION.key()))) {
            this.filenameExtension = config.getString(FileBaseSinkOptions.FILENAME_EXTENSION.key());
        }
        if (config.hasPath(FileBaseSinkOptions.DATE_FORMAT_LEGACY.key())) {
            this.dateFormat = DateUtils.Formatter.parse((String)config.getString(FileBaseSinkOptions.DATE_FORMAT_LEGACY.key()));
        }
        if (config.hasPath(FileBaseSinkOptions.DATETIME_FORMAT_LEGACY.key())) {
            this.datetimeFormat = DateTimeUtils.Formatter.parse((String)config.getString(FileBaseSinkOptions.DATETIME_FORMAT_LEGACY.key()));
        }
        if (config.hasPath(FileBaseSinkOptions.TIME_FORMAT_LEGACY.key())) {
            this.timeFormat = TimeUtils.Formatter.parse((String)config.getString(FileBaseSinkOptions.TIME_FORMAT_LEGACY.key()));
        }
        if (config.hasPath(FileBaseSinkOptions.ENABLE_HEADER_WRITE.key())) {
            this.enableHeaderWriter = config.getBoolean(FileBaseSinkOptions.ENABLE_HEADER_WRITE.key());
        }
    }

    public BaseFileSinkConfig() {
    }

    public CompressFormat getCompressFormat() {
        return this.compressFormat;
    }

    @Override
    public String getFieldDelimiter() {
        return this.fieldDelimiter;
    }

    public int getSheetMaxRows() {
        return this.sheetMaxRows;
    }

    @Override
    public String getRowDelimiter() {
        return this.rowDelimiter;
    }

    public int getBatchSize() {
        return this.batchSize;
    }

    public String getPath() {
        return this.path;
    }

    public String getFileNameExpression() {
        return this.fileNameExpression;
    }

    public boolean isSingleFileMode() {
        return this.singleFileMode;
    }

    public boolean isCreateEmptyFileWhenNoData() {
        return this.createEmptyFileWhenNoData;
    }

    public FileFormat getFileFormat() {
        return this.fileFormat;
    }

    public String getFilenameExtension() {
        return this.filenameExtension;
    }

    public DateUtils.Formatter getDateFormat() {
        return this.dateFormat;
    }

    public DateTimeUtils.Formatter getDatetimeFormat() {
        return this.datetimeFormat;
    }

    public TimeUtils.Formatter getTimeFormat() {
        return this.timeFormat;
    }

    public Boolean getEnableHeaderWriter() {
        return this.enableHeaderWriter;
    }

    public void setCompressFormat(CompressFormat compressFormat) {
        this.compressFormat = compressFormat;
    }

    public void setFieldDelimiter(String fieldDelimiter) {
        this.fieldDelimiter = fieldDelimiter;
    }

    public void setSheetMaxRows(int sheetMaxRows) {
        this.sheetMaxRows = sheetMaxRows;
    }

    public void setRowDelimiter(String rowDelimiter) {
        this.rowDelimiter = rowDelimiter;
    }

    public void setBatchSize(int batchSize) {
        this.batchSize = batchSize;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setFileNameExpression(String fileNameExpression) {
        this.fileNameExpression = fileNameExpression;
    }

    public void setSingleFileMode(boolean singleFileMode) {
        this.singleFileMode = singleFileMode;
    }

    public void setCreateEmptyFileWhenNoData(boolean createEmptyFileWhenNoData) {
        this.createEmptyFileWhenNoData = createEmptyFileWhenNoData;
    }

    public void setFileFormat(FileFormat fileFormat) {
        this.fileFormat = fileFormat;
    }

    public void setFilenameExtension(String filenameExtension) {
        this.filenameExtension = filenameExtension;
    }

    public void setDateFormat(DateUtils.Formatter dateFormat) {
        this.dateFormat = dateFormat;
    }

    public void setDatetimeFormat(DateTimeUtils.Formatter datetimeFormat) {
        this.datetimeFormat = datetimeFormat;
    }

    public void setTimeFormat(TimeUtils.Formatter timeFormat) {
        this.timeFormat = timeFormat;
    }

    public void setEnableHeaderWriter(Boolean enableHeaderWriter) {
        this.enableHeaderWriter = enableHeaderWriter;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BaseFileSinkConfig)) {
            return false;
        }
        BaseFileSinkConfig other = (BaseFileSinkConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getSheetMaxRows() != other.getSheetMaxRows()) {
            return false;
        }
        if (this.getBatchSize() != other.getBatchSize()) {
            return false;
        }
        if (this.isSingleFileMode() != other.isSingleFileMode()) {
            return false;
        }
        if (this.isCreateEmptyFileWhenNoData() != other.isCreateEmptyFileWhenNoData()) {
            return false;
        }
        Boolean this$enableHeaderWriter = this.getEnableHeaderWriter();
        Boolean other$enableHeaderWriter = other.getEnableHeaderWriter();
        if (this$enableHeaderWriter == null ? other$enableHeaderWriter != null : !((Object)this$enableHeaderWriter).equals(other$enableHeaderWriter)) {
            return false;
        }
        CompressFormat this$compressFormat = this.getCompressFormat();
        CompressFormat other$compressFormat = other.getCompressFormat();
        if (this$compressFormat == null ? other$compressFormat != null : !this$compressFormat.equals(other$compressFormat)) {
            return false;
        }
        String this$fieldDelimiter = this.getFieldDelimiter();
        String other$fieldDelimiter = other.getFieldDelimiter();
        if (this$fieldDelimiter == null ? other$fieldDelimiter != null : !this$fieldDelimiter.equals(other$fieldDelimiter)) {
            return false;
        }
        String this$rowDelimiter = this.getRowDelimiter();
        String other$rowDelimiter = other.getRowDelimiter();
        if (this$rowDelimiter == null ? other$rowDelimiter != null : !this$rowDelimiter.equals(other$rowDelimiter)) {
            return false;
        }
        String this$path = this.getPath();
        String other$path = other.getPath();
        if (this$path == null ? other$path != null : !this$path.equals(other$path)) {
            return false;
        }
        String this$fileNameExpression = this.getFileNameExpression();
        String other$fileNameExpression = other.getFileNameExpression();
        if (this$fileNameExpression == null ? other$fileNameExpression != null : !this$fileNameExpression.equals(other$fileNameExpression)) {
            return false;
        }
        FileFormat this$fileFormat = this.getFileFormat();
        FileFormat other$fileFormat = other.getFileFormat();
        if (this$fileFormat == null ? other$fileFormat != null : !this$fileFormat.equals(other$fileFormat)) {
            return false;
        }
        String this$filenameExtension = this.getFilenameExtension();
        String other$filenameExtension = other.getFilenameExtension();
        if (this$filenameExtension == null ? other$filenameExtension != null : !this$filenameExtension.equals(other$filenameExtension)) {
            return false;
        }
        DateUtils.Formatter this$dateFormat = this.getDateFormat();
        DateUtils.Formatter other$dateFormat = other.getDateFormat();
        if (this$dateFormat == null ? other$dateFormat != null : !this$dateFormat.equals(other$dateFormat)) {
            return false;
        }
        DateTimeUtils.Formatter this$datetimeFormat = this.getDatetimeFormat();
        DateTimeUtils.Formatter other$datetimeFormat = other.getDatetimeFormat();
        if (this$datetimeFormat == null ? other$datetimeFormat != null : !this$datetimeFormat.equals(other$datetimeFormat)) {
            return false;
        }
        TimeUtils.Formatter this$timeFormat = this.getTimeFormat();
        TimeUtils.Formatter other$timeFormat = other.getTimeFormat();
        return !(this$timeFormat == null ? other$timeFormat != null : !this$timeFormat.equals(other$timeFormat));
    }

    protected boolean canEqual(Object other) {
        return other instanceof BaseFileSinkConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getSheetMaxRows();
        result = result * 59 + this.getBatchSize();
        result = result * 59 + (this.isSingleFileMode() ? 79 : 97);
        result = result * 59 + (this.isCreateEmptyFileWhenNoData() ? 79 : 97);
        Boolean $enableHeaderWriter = this.getEnableHeaderWriter();
        result = result * 59 + ($enableHeaderWriter == null ? 43 : ((Object)$enableHeaderWriter).hashCode());
        CompressFormat $compressFormat = this.getCompressFormat();
        result = result * 59 + ($compressFormat == null ? 43 : $compressFormat.hashCode());
        String $fieldDelimiter = this.getFieldDelimiter();
        result = result * 59 + ($fieldDelimiter == null ? 43 : $fieldDelimiter.hashCode());
        String $rowDelimiter = this.getRowDelimiter();
        result = result * 59 + ($rowDelimiter == null ? 43 : $rowDelimiter.hashCode());
        String $path = this.getPath();
        result = result * 59 + ($path == null ? 43 : $path.hashCode());
        String $fileNameExpression = this.getFileNameExpression();
        result = result * 59 + ($fileNameExpression == null ? 43 : $fileNameExpression.hashCode());
        FileFormat $fileFormat = this.getFileFormat();
        result = result * 59 + ($fileFormat == null ? 43 : $fileFormat.hashCode());
        String $filenameExtension = this.getFilenameExtension();
        result = result * 59 + ($filenameExtension == null ? 43 : $filenameExtension.hashCode());
        DateUtils.Formatter $dateFormat = this.getDateFormat();
        result = result * 59 + ($dateFormat == null ? 43 : $dateFormat.hashCode());
        DateTimeUtils.Formatter $datetimeFormat = this.getDatetimeFormat();
        result = result * 59 + ($datetimeFormat == null ? 43 : $datetimeFormat.hashCode());
        TimeUtils.Formatter $timeFormat = this.getTimeFormat();
        result = result * 59 + ($timeFormat == null ? 43 : $timeFormat.hashCode());
        return result;
    }

    public String toString() {
        return "BaseFileSinkConfig(compressFormat=" + this.getCompressFormat() + ", fieldDelimiter=" + this.getFieldDelimiter() + ", sheetMaxRows=" + this.getSheetMaxRows() + ", rowDelimiter=" + this.getRowDelimiter() + ", batchSize=" + this.getBatchSize() + ", path=" + this.getPath() + ", fileNameExpression=" + this.getFileNameExpression() + ", singleFileMode=" + this.isSingleFileMode() + ", createEmptyFileWhenNoData=" + this.isCreateEmptyFileWhenNoData() + ", fileFormat=" + this.getFileFormat() + ", filenameExtension=" + this.getFilenameExtension() + ", dateFormat=" + this.getDateFormat() + ", datetimeFormat=" + this.getDatetimeFormat() + ", timeFormat=" + this.getTimeFormat() + ", enableHeaderWriter=" + this.getEnableHeaderWriter() + ")";
    }
}

