/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.excel.metadata.csv;

import com.alibaba.excel.metadata.csv.CsvCell;
import com.alibaba.excel.metadata.csv.CsvSheet;
import com.alibaba.excel.metadata.csv.CsvWorkbook;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.compress.utils.Lists;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;

public class CsvRow
implements Row {
    private final List<CsvCell> cellList = Lists.newArrayList();
    private final CsvWorkbook csvWorkbook;
    private final CsvSheet csvSheet;
    private Integer rowIndex;
    private CellStyle cellStyle;

    public CsvRow(CsvWorkbook csvWorkbook, CsvSheet csvSheet, Integer rowIndex) {
        this.csvWorkbook = csvWorkbook;
        this.csvSheet = csvSheet;
        this.rowIndex = rowIndex;
    }

    @Override
    public Cell createCell(int column) {
        CsvCell cell = new CsvCell(this.csvWorkbook, this.csvSheet, this, column, null);
        this.cellList.add(cell);
        return cell;
    }

    @Override
    public Cell createCell(int column, CellType type) {
        CsvCell cell = new CsvCell(this.csvWorkbook, this.csvSheet, this, column, type);
        this.cellList.add(cell);
        return cell;
    }

    @Override
    public void removeCell(Cell cell) {
        this.cellList.remove(cell);
    }

    @Override
    public void setRowNum(int rowNum) {
        this.rowIndex = rowNum;
    }

    @Override
    public int getRowNum() {
        return this.rowIndex;
    }

    @Override
    public Cell getCell(int cellnum) {
        if (cellnum >= this.cellList.size()) {
            return null;
        }
        return this.cellList.get(cellnum - 1);
    }

    @Override
    public Cell getCell(int cellnum, Row.MissingCellPolicy policy) {
        return this.getCell(cellnum);
    }

    @Override
    public short getFirstCellNum() {
        if (CollectionUtils.isEmpty(this.cellList)) {
            return -1;
        }
        return 0;
    }

    @Override
    public short getLastCellNum() {
        if (CollectionUtils.isEmpty(this.cellList)) {
            return -1;
        }
        return (short)this.cellList.size();
    }

    @Override
    public int getPhysicalNumberOfCells() {
        return this.getRowNum();
    }

    @Override
    public void setHeight(short height) {
    }

    @Override
    public void setZeroHeight(boolean zHeight) {
    }

    @Override
    public boolean getZeroHeight() {
        return false;
    }

    @Override
    public void setHeightInPoints(float height) {
    }

    @Override
    public short getHeight() {
        return 0;
    }

    @Override
    public float getHeightInPoints() {
        return 0.0f;
    }

    @Override
    public boolean isFormatted() {
        return false;
    }

    @Override
    public CellStyle getRowStyle() {
        return this.cellStyle;
    }

    @Override
    public void setRowStyle(CellStyle style) {
        this.cellStyle = style;
    }

    @Override
    public Iterator<Cell> cellIterator() {
        return this.cellList.iterator();
    }

    @Override
    public Sheet getSheet() {
        return this.csvSheet;
    }

    @Override
    public int getOutlineLevel() {
        return 0;
    }

    @Override
    public void shiftCellsRight(int firstShiftColumnIndex, int lastShiftColumnIndex, int step) {
    }

    @Override
    public void shiftCellsLeft(int firstShiftColumnIndex, int lastShiftColumnIndex, int step) {
    }

    @Override
    public Iterator<Cell> iterator() {
        return this.cellIterator();
    }

    public List<CsvCell> getCellList() {
        return this.cellList;
    }

    public CsvWorkbook getCsvWorkbook() {
        return this.csvWorkbook;
    }

    public CsvSheet getCsvSheet() {
        return this.csvSheet;
    }

    public Integer getRowIndex() {
        return this.rowIndex;
    }

    public CellStyle getCellStyle() {
        return this.cellStyle;
    }

    public void setRowIndex(Integer rowIndex) {
        this.rowIndex = rowIndex;
    }

    public void setCellStyle(CellStyle cellStyle) {
        this.cellStyle = cellStyle;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CsvRow)) {
            return false;
        }
        CsvRow other = (CsvRow)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$rowIndex = this.getRowIndex();
        Integer other$rowIndex = other.getRowIndex();
        if (this$rowIndex == null ? other$rowIndex != null : !((Object)this$rowIndex).equals(other$rowIndex)) {
            return false;
        }
        List<CsvCell> this$cellList = this.getCellList();
        List<CsvCell> other$cellList = other.getCellList();
        if (this$cellList == null ? other$cellList != null : !((Object)this$cellList).equals(other$cellList)) {
            return false;
        }
        CsvWorkbook this$csvWorkbook = this.getCsvWorkbook();
        CsvWorkbook other$csvWorkbook = other.getCsvWorkbook();
        if (this$csvWorkbook == null ? other$csvWorkbook != null : !((Object)this$csvWorkbook).equals(other$csvWorkbook)) {
            return false;
        }
        CsvSheet this$csvSheet = this.getCsvSheet();
        CsvSheet other$csvSheet = other.getCsvSheet();
        if (this$csvSheet == null ? other$csvSheet != null : !((Object)this$csvSheet).equals(other$csvSheet)) {
            return false;
        }
        CellStyle this$cellStyle = this.getCellStyle();
        CellStyle other$cellStyle = other.getCellStyle();
        return !(this$cellStyle == null ? other$cellStyle != null : !this$cellStyle.equals(other$cellStyle));
    }

    protected boolean canEqual(Object other) {
        return other instanceof CsvRow;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $rowIndex = this.getRowIndex();
        result = result * 59 + ($rowIndex == null ? 43 : ((Object)$rowIndex).hashCode());
        List<CsvCell> $cellList = this.getCellList();
        result = result * 59 + ($cellList == null ? 43 : ((Object)$cellList).hashCode());
        CsvWorkbook $csvWorkbook = this.getCsvWorkbook();
        result = result * 59 + ($csvWorkbook == null ? 43 : ((Object)$csvWorkbook).hashCode());
        CsvSheet $csvSheet = this.getCsvSheet();
        result = result * 59 + ($csvSheet == null ? 43 : ((Object)$csvSheet).hashCode());
        CellStyle $cellStyle = this.getCellStyle();
        result = result * 59 + ($cellStyle == null ? 43 : $cellStyle.hashCode());
        return result;
    }
}

