/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.file.sink;

import java.util.List;
import java.util.Optional;
import org.apache.seatunnel.api.common.JobContext;
import org.apache.seatunnel.api.configuration.ReadonlyConfig;
import org.apache.seatunnel.api.serialization.DefaultSerializer;
import org.apache.seatunnel.api.serialization.Serializer;
import org.apache.seatunnel.api.sink.DataSaveMode;
import org.apache.seatunnel.api.sink.DefaultSaveModeHandler;
import org.apache.seatunnel.api.sink.SaveModeHandler;
import org.apache.seatunnel.api.sink.SchemaSaveMode;
import org.apache.seatunnel.api.sink.SeaTunnelSink;
import org.apache.seatunnel.api.sink.SinkAggregatedCommitter;
import org.apache.seatunnel.api.sink.SinkWriter;
import org.apache.seatunnel.api.sink.SupportMultiTableSink;
import org.apache.seatunnel.api.sink.SupportSaveMode;
import org.apache.seatunnel.api.table.catalog.Catalog;
import org.apache.seatunnel.api.table.catalog.CatalogTable;
import org.apache.seatunnel.api.table.factory.CatalogFactory;
import org.apache.seatunnel.api.table.factory.FactoryUtil;
import org.apache.seatunnel.api.table.type.SeaTunnelRow;
import org.apache.seatunnel.connectors.seatunnel.file.config.FileBaseSinkOptions;
import org.apache.seatunnel.connectors.seatunnel.file.config.HadoopConf;
import org.apache.seatunnel.connectors.seatunnel.file.sink.BaseFileSinkWriter;
import org.apache.seatunnel.connectors.seatunnel.file.sink.commit.FileAggregatedCommitInfo;
import org.apache.seatunnel.connectors.seatunnel.file.sink.commit.FileCommitInfo;
import org.apache.seatunnel.connectors.seatunnel.file.sink.commit.FileSinkAggregatedCommitter;
import org.apache.seatunnel.connectors.seatunnel.file.sink.config.FileSinkConfig;
import org.apache.seatunnel.connectors.seatunnel.file.sink.state.FileSinkState;
import org.apache.seatunnel.connectors.seatunnel.file.sink.writer.WriteStrategy;
import org.apache.seatunnel.connectors.seatunnel.file.sink.writer.WriteStrategyFactory;

public abstract class BaseMultipleTableFileSink
implements SeaTunnelSink<SeaTunnelRow, FileSinkState, FileCommitInfo, FileAggregatedCommitInfo>,
SupportMultiTableSink,
SupportSaveMode {
    private final HadoopConf hadoopConf;
    private final CatalogTable catalogTable;
    private final FileSinkConfig fileSinkConfig;
    private String jobId;
    private JobContext jobContext;
    private final ReadonlyConfig readonlyConfig;

    public abstract String getPluginName();

    public BaseMultipleTableFileSink(HadoopConf hadoopConf, ReadonlyConfig readonlyConfig, CatalogTable catalogTable) {
        this.readonlyConfig = readonlyConfig;
        this.hadoopConf = hadoopConf;
        this.fileSinkConfig = new FileSinkConfig(readonlyConfig.toConfig(), catalogTable.getSeaTunnelRowType());
        this.catalogTable = catalogTable;
    }

    public void preCheckConfig() {
        if (((Boolean)this.readonlyConfig.get(FileBaseSinkOptions.SINGLE_FILE_MODE)).booleanValue() && this.jobContext.isEnableCheckpoint()) {
            throw new IllegalArgumentException("Single file mode is not supported when checkpoint is enabled or in streaming mode.");
        }
    }

    public void setJobContext(JobContext jobContext) {
        this.jobContext = jobContext;
        this.preCheckConfig();
    }

    public SinkWriter<SeaTunnelRow, FileCommitInfo, FileSinkState> restoreWriter(SinkWriter.Context context, List<FileSinkState> states) {
        return new BaseFileSinkWriter(this.createWriteStrategy(), this.hadoopConf, context, this.jobContext.getJobId(), states);
    }

    public Optional<SinkAggregatedCommitter<FileCommitInfo, FileAggregatedCommitInfo>> createAggregatedCommitter() {
        return Optional.of(new FileSinkAggregatedCommitter(this.hadoopConf));
    }

    public BaseFileSinkWriter createWriter(SinkWriter.Context context) {
        return new BaseFileSinkWriter(this.createWriteStrategy(), this.hadoopConf, context, this.jobContext.getJobId());
    }

    public Optional<Serializer<FileCommitInfo>> getCommitInfoSerializer() {
        return Optional.of(new DefaultSerializer());
    }

    public Optional<Serializer<FileAggregatedCommitInfo>> getAggregatedCommitInfoSerializer() {
        return Optional.of(new DefaultSerializer());
    }

    public Optional<Serializer<FileSinkState>> getWriterStateSerializer() {
        return Optional.of(new DefaultSerializer());
    }

    protected WriteStrategy createWriteStrategy() {
        WriteStrategy writeStrategy = WriteStrategyFactory.of(this.fileSinkConfig.getFileFormat(), this.fileSinkConfig);
        writeStrategy.setCatalogTable(this.catalogTable);
        return writeStrategy;
    }

    public Optional<SaveModeHandler> getSaveModeHandler() {
        CatalogFactory catalogFactory = (CatalogFactory)FactoryUtil.discoverFactory((ClassLoader)Thread.currentThread().getContextClassLoader(), CatalogFactory.class, (String)this.getPluginName());
        if (catalogFactory == null) {
            return Optional.empty();
        }
        Catalog catalog = catalogFactory.createCatalog(this.getPluginName(), this.readonlyConfig);
        SchemaSaveMode schemaSaveMode = (SchemaSaveMode)this.readonlyConfig.get(FileBaseSinkOptions.SCHEMA_SAVE_MODE);
        DataSaveMode dataSaveMode = (DataSaveMode)this.readonlyConfig.get(FileBaseSinkOptions.DATA_SAVE_MODE);
        return Optional.of(new DefaultSaveModeHandler(schemaSaveMode, dataSaveMode, catalog, this.catalogTable, null));
    }
}

