/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.file.local.sink;

import com.google.auto.service.AutoService;
import java.util.Arrays;
import org.apache.seatunnel.api.configuration.Option;
import org.apache.seatunnel.api.configuration.ReadonlyConfig;
import org.apache.seatunnel.api.configuration.util.OptionRule;
import org.apache.seatunnel.api.options.SinkConnectorCommonOptions;
import org.apache.seatunnel.api.table.catalog.CatalogTable;
import org.apache.seatunnel.api.table.connector.TableSink;
import org.apache.seatunnel.api.table.factory.Factory;
import org.apache.seatunnel.api.table.factory.TableSinkFactoryContext;
import org.apache.seatunnel.api.table.type.SeaTunnelRow;
import org.apache.seatunnel.connectors.seatunnel.file.config.FileBaseSinkOptions;
import org.apache.seatunnel.connectors.seatunnel.file.config.FileFormat;
import org.apache.seatunnel.connectors.seatunnel.file.config.FileSystemType;
import org.apache.seatunnel.connectors.seatunnel.file.factory.BaseMultipleTableFileSinkFactory;
import org.apache.seatunnel.connectors.seatunnel.file.local.sink.LocalFileSink;
import org.apache.seatunnel.connectors.seatunnel.file.sink.commit.FileAggregatedCommitInfo;
import org.apache.seatunnel.connectors.seatunnel.file.sink.commit.FileCommitInfo;
import org.apache.seatunnel.connectors.seatunnel.file.sink.state.FileSinkState;

@AutoService(value={Factory.class})
public class LocalFileSinkFactory
extends BaseMultipleTableFileSinkFactory {
    public String factoryIdentifier() {
        return FileSystemType.LOCAL.getFileSystemPluginName();
    }

    public OptionRule optionRule() {
        return OptionRule.builder().required(new Option[]{FileBaseSinkOptions.FILE_PATH}).optional(new Option[]{FileBaseSinkOptions.FILE_FORMAT_TYPE}).optional(new Option[]{FileBaseSinkOptions.SCHEMA_SAVE_MODE}).optional(new Option[]{FileBaseSinkOptions.DATA_SAVE_MODE}).optional(new Option[]{SinkConnectorCommonOptions.MULTI_TABLE_SINK_REPLICA}).conditional(FileBaseSinkOptions.FILE_FORMAT_TYPE, (Object)FileFormat.TEXT, new Option[]{FileBaseSinkOptions.ROW_DELIMITER, FileBaseSinkOptions.FIELD_DELIMITER, FileBaseSinkOptions.TXT_COMPRESS, FileBaseSinkOptions.ENABLE_HEADER_WRITE}).conditional(FileBaseSinkOptions.FILE_FORMAT_TYPE, (Object)FileFormat.CSV, new Option[]{FileBaseSinkOptions.ROW_DELIMITER, FileBaseSinkOptions.TXT_COMPRESS, FileBaseSinkOptions.ENABLE_HEADER_WRITE}).conditional(FileBaseSinkOptions.FILE_FORMAT_TYPE, (Object)FileFormat.JSON, new Option[]{FileBaseSinkOptions.ROW_DELIMITER, FileBaseSinkOptions.TXT_COMPRESS}).conditional(FileBaseSinkOptions.FILE_FORMAT_TYPE, (Object)FileFormat.ORC, new Option[]{FileBaseSinkOptions.ORC_COMPRESS}).conditional(FileBaseSinkOptions.FILE_FORMAT_TYPE, (Object)FileFormat.PARQUET, new Option[]{FileBaseSinkOptions.PARQUET_COMPRESS, FileBaseSinkOptions.PARQUET_AVRO_WRITE_FIXED_AS_INT96, FileBaseSinkOptions.PARQUET_AVRO_WRITE_TIMESTAMP_AS_INT96}).conditional(FileBaseSinkOptions.FILE_FORMAT_TYPE, (Object)FileFormat.XML, new Option[]{FileBaseSinkOptions.XML_USE_ATTR_FORMAT, FileBaseSinkOptions.XML_ROOT_TAG, FileBaseSinkOptions.XML_ROW_TAG}).optional(new Option[]{FileBaseSinkOptions.CUSTOM_FILENAME}).conditional(FileBaseSinkOptions.CUSTOM_FILENAME, (Object)true, new Option[]{FileBaseSinkOptions.FILE_NAME_EXPRESSION, FileBaseSinkOptions.FILENAME_TIME_FORMAT}).optional(new Option[]{FileBaseSinkOptions.HAVE_PARTITION}).conditional(FileBaseSinkOptions.HAVE_PARTITION, (Object)true, new Option[]{FileBaseSinkOptions.PARTITION_BY, FileBaseSinkOptions.PARTITION_DIR_EXPRESSION, FileBaseSinkOptions.IS_PARTITION_FIELD_WRITE_IN_FILE}).conditional(FileBaseSinkOptions.FILE_FORMAT_TYPE, Arrays.asList(FileFormat.TEXT, FileFormat.JSON, FileFormat.CSV, FileFormat.XML), new Option[]{FileBaseSinkOptions.ENCODING}).optional(new Option[]{FileBaseSinkOptions.SINK_COLUMNS}).optional(new Option[]{FileBaseSinkOptions.IS_ENABLE_TRANSACTION}).optional(new Option[]{FileBaseSinkOptions.DATE_FORMAT_LEGACY}).optional(new Option[]{FileBaseSinkOptions.DATETIME_FORMAT_LEGACY}).optional(new Option[]{FileBaseSinkOptions.TIME_FORMAT_LEGACY}).optional(new Option[]{FileBaseSinkOptions.SINGLE_FILE_MODE}).optional(new Option[]{FileBaseSinkOptions.BATCH_SIZE}).optional(new Option[]{FileBaseSinkOptions.CREATE_EMPTY_FILE_WHEN_NO_DATA}).optional(new Option[]{FileBaseSinkOptions.FILENAME_EXTENSION}).optional(new Option[]{FileBaseSinkOptions.TMP_PATH}).build();
    }

    public TableSink<SeaTunnelRow, FileSinkState, FileCommitInfo, FileAggregatedCommitInfo> createSink(TableSinkFactoryContext context) {
        ReadonlyConfig readonlyConfig = context.getOptions();
        CatalogTable catalogTable = context.getCatalogTable();
        return () -> new LocalFileSink(readonlyConfig, catalogTable);
    }
}

