/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.elasticsearch.sink;

import com.google.auto.service.AutoService;
import org.apache.seatunnel.api.configuration.Option;
import org.apache.seatunnel.api.configuration.ReadonlyConfig;
import org.apache.seatunnel.api.configuration.util.OptionRule;
import org.apache.seatunnel.api.options.SinkConnectorCommonOptions;
import org.apache.seatunnel.api.table.catalog.CatalogTable;
import org.apache.seatunnel.api.table.catalog.TableIdentifier;
import org.apache.seatunnel.api.table.connector.TableSink;
import org.apache.seatunnel.api.table.factory.Factory;
import org.apache.seatunnel.api.table.factory.TableSinkFactory;
import org.apache.seatunnel.api.table.factory.TableSinkFactoryContext;
import org.apache.seatunnel.connectors.seatunnel.elasticsearch.config.AuthTypeEnum;
import org.apache.seatunnel.connectors.seatunnel.elasticsearch.config.ElasticsearchBaseOptions;
import org.apache.seatunnel.connectors.seatunnel.elasticsearch.config.ElasticsearchSinkOptions;
import org.apache.seatunnel.connectors.seatunnel.elasticsearch.sink.ElasticsearchSink;

@AutoService(value={Factory.class})
public class ElasticsearchSinkFactory
implements TableSinkFactory {
    public String factoryIdentifier() {
        return "Elasticsearch";
    }

    public OptionRule optionRule() {
        return OptionRule.builder().required(new Option[]{ElasticsearchBaseOptions.HOSTS, ElasticsearchSinkOptions.INDEX, ElasticsearchSinkOptions.SCHEMA_SAVE_MODE, ElasticsearchSinkOptions.DATA_SAVE_MODE}).optional(new Option[]{ElasticsearchSinkOptions.INDEX_TYPE, ElasticsearchSinkOptions.PRIMARY_KEYS, ElasticsearchSinkOptions.KEY_DELIMITER, ElasticsearchBaseOptions.USERNAME, ElasticsearchBaseOptions.PASSWORD, ElasticsearchSinkOptions.MAX_RETRY_COUNT, ElasticsearchSinkOptions.MAX_BATCH_SIZE, ElasticsearchBaseOptions.TLS_VERIFY_CERTIFICATE, ElasticsearchBaseOptions.TLS_VERIFY_HOSTNAME, ElasticsearchBaseOptions.TLS_KEY_STORE_PATH, ElasticsearchBaseOptions.TLS_KEY_STORE_PASSWORD, ElasticsearchBaseOptions.TLS_TRUST_STORE_PATH, ElasticsearchBaseOptions.TLS_TRUST_STORE_PASSWORD, SinkConnectorCommonOptions.MULTI_TABLE_SINK_REPLICA}).optional(new Option[]{ElasticsearchBaseOptions.AUTH_TYPE}).conditional(ElasticsearchBaseOptions.AUTH_TYPE, (Object)AuthTypeEnum.API_KEY, new Option[]{ElasticsearchBaseOptions.API_KEY_ID, ElasticsearchBaseOptions.API_KEY}).conditional(ElasticsearchBaseOptions.AUTH_TYPE, (Object)AuthTypeEnum.API_KEY_ENCODED, new Option[]{ElasticsearchBaseOptions.API_KEY_ENCODED}).build();
    }

    public TableSink createSink(TableSinkFactoryContext context) {
        ReadonlyConfig readonlyConfig = context.getOptions();
        String original = (String)readonlyConfig.get(ElasticsearchSinkOptions.INDEX);
        CatalogTable newTable = CatalogTable.of((TableIdentifier)TableIdentifier.of((String)context.getCatalogTable().getCatalogName(), (String)context.getCatalogTable().getTablePath().getDatabaseName(), (String)original), (CatalogTable)context.getCatalogTable());
        return () -> new ElasticsearchSink(readonlyConfig, newTable);
    }
}

