/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.elasticsearch.serialize.type;

import org.apache.seatunnel.connectors.seatunnel.elasticsearch.constant.ElasticsearchVersion;
import org.apache.seatunnel.connectors.seatunnel.elasticsearch.dto.ElasticsearchClusterInfo;
import org.apache.seatunnel.connectors.seatunnel.elasticsearch.serialize.type.IndexTypeSerializer;
import org.apache.seatunnel.connectors.seatunnel.elasticsearch.serialize.type.impl.NotIndexTypeSerializer;
import org.apache.seatunnel.connectors.seatunnel.elasticsearch.serialize.type.impl.RequiredIndexTypeSerializer;

public class IndexTypeSerializerFactory {
    private static final String DEFAULT_TYPE = "st";

    private IndexTypeSerializerFactory() {
    }

    public static IndexTypeSerializer getIndexTypeSerializer(ElasticsearchClusterInfo elasticsearchClusterInfo, String type) {
        if (elasticsearchClusterInfo.isOpensearch()) {
            return new NotIndexTypeSerializer();
        }
        ElasticsearchVersion elasticsearchVersion = elasticsearchClusterInfo.getElasticsearchVersion();
        if (elasticsearchVersion == ElasticsearchVersion.ES2 || elasticsearchVersion == ElasticsearchVersion.ES5) {
            if (type == null || "".equals(type)) {
                type = DEFAULT_TYPE;
            }
            return new RequiredIndexTypeSerializer(type);
        }
        if (elasticsearchVersion == ElasticsearchVersion.ES6 && type != null && !"".equals(type)) {
            return new RequiredIndexTypeSerializer(type);
        }
        return new NotIndexTypeSerializer();
    }
}

