/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.elasticsearch.client.auth;

import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Optional;
import org.apache.http.impl.nio.client.HttpAsyncClientBuilder;
import org.apache.seatunnel.api.configuration.ReadonlyConfig;
import org.apache.seatunnel.connectors.seatunnel.elasticsearch.client.auth.AbstractAuthenticationProvider;
import org.apache.seatunnel.connectors.seatunnel.elasticsearch.config.ElasticsearchBaseOptions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApiKeyEncodedAuthProvider
extends AbstractAuthenticationProvider {
    private static final Logger log = LoggerFactory.getLogger(ApiKeyEncodedAuthProvider.class);
    private static final String AUTH_TYPE = "api_key_encoded";
    private static final String API_KEY_HEADER = "Authorization";
    private static final String API_KEY_PREFIX = "ApiKey ";

    @Override
    protected void configureAuthentication(HttpAsyncClientBuilder httpClientBuilder, ReadonlyConfig config) {
        Optional apiKeyEncoded = config.getOptional(ElasticsearchBaseOptions.API_KEY_ENCODED);
        if (apiKeyEncoded.isPresent()) {
            log.debug("Configuring encoded API key authentication");
            httpClientBuilder.addInterceptorFirst((request, context) -> request.setHeader(API_KEY_HEADER, API_KEY_PREFIX + (String)apiKeyEncoded.get()));
            log.info("Encoded API key authentication configured successfully");
        } else {
            log.debug("No encoded API key provided, skipping encoded API key authentication configuration");
        }
    }

    @Override
    public String getAuthType() {
        return AUTH_TYPE;
    }

    @Override
    public void validate(ReadonlyConfig config) {
        Optional apiKeyEncoded = config.getOptional(ElasticsearchBaseOptions.API_KEY_ENCODED);
        if (!apiKeyEncoded.isPresent()) {
            throw new IllegalArgumentException("API key authentication with auth_type='api_key_encoded' requires api_key_encoded");
        }
        this.validateEncodedApiKey((String)apiKeyEncoded.get());
        log.debug("Encoded API key authentication configuration validated");
    }

    private void validateEncodedApiKey(String apiKeyEncoded) {
        if (apiKeyEncoded == null || apiKeyEncoded.trim().isEmpty()) {
            throw new IllegalArgumentException("Encoded API key cannot be null or empty");
        }
        try {
            byte[] decoded = Base64.getDecoder().decode(apiKeyEncoded);
            String decodedStr = new String(decoded, StandardCharsets.UTF_8);
            if (!decodedStr.contains(":")) {
                throw new IllegalArgumentException("Encoded API key must be Base64 encoded 'id:key' format");
            }
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Invalid encoded API key format: " + e.getMessage(), e);
        }
    }
}

