/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.elasticsearch.client.auth;

import java.util.Optional;
import javax.net.ssl.SSLContext;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.TrustAllStrategy;
import org.apache.http.impl.nio.client.HttpAsyncClientBuilder;
import org.apache.http.ssl.SSLContexts;
import org.apache.seatunnel.api.configuration.ReadonlyConfig;
import org.apache.seatunnel.connectors.seatunnel.elasticsearch.client.auth.AuthenticationProvider;
import org.apache.seatunnel.connectors.seatunnel.elasticsearch.config.ElasticsearchBaseOptions;
import org.apache.seatunnel.connectors.seatunnel.elasticsearch.util.SSLUtils;
import org.elasticsearch.client.RestClientBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractAuthenticationProvider
implements AuthenticationProvider {
    private static final Logger log = LoggerFactory.getLogger(AbstractAuthenticationProvider.class);

    @Override
    public final void configure(RestClientBuilder builder, ReadonlyConfig config) {
        builder.setHttpClientConfigCallback(httpClientBuilder -> {
            this.configureAuthentication(httpClientBuilder, config);
            this.configureTLS(httpClientBuilder, config);
            return httpClientBuilder;
        });
    }

    protected abstract void configureAuthentication(HttpAsyncClientBuilder var1, ReadonlyConfig var2);

    protected void configureTLS(HttpAsyncClientBuilder httpClientBuilder, ReadonlyConfig config) {
        boolean tlsVerifyCertificate = (Boolean)config.get(ElasticsearchBaseOptions.TLS_VERIFY_CERTIFICATE);
        boolean tlsVerifyHostnames = (Boolean)config.get(ElasticsearchBaseOptions.TLS_VERIFY_HOSTNAME);
        try {
            if (tlsVerifyCertificate) {
                Optional truststorePassword;
                Optional truststorePath;
                Optional keystorePassword;
                Optional keystorePath = config.getOptional(ElasticsearchBaseOptions.TLS_KEY_STORE_PATH);
                Optional<SSLContext> sslContext = SSLUtils.buildSSLContext(keystorePath, keystorePassword = config.getOptional(ElasticsearchBaseOptions.TLS_KEY_STORE_PASSWORD), truststorePath = config.getOptional(ElasticsearchBaseOptions.TLS_TRUST_STORE_PATH), truststorePassword = config.getOptional(ElasticsearchBaseOptions.TLS_TRUST_STORE_PASSWORD));
                if (sslContext.isPresent()) {
                    httpClientBuilder.setSSLContext(sslContext.get());
                    log.debug("Custom SSL context configured with keystore/truststore");
                } else {
                    log.debug("No custom SSL context configured, using default");
                }
            } else {
                SSLContext sslContext = SSLContexts.custom().loadTrustMaterial(new TrustAllStrategy()).build();
                httpClientBuilder.setSSLContext(sslContext);
                log.warn("TLS certificate verification disabled - not recommended for production");
            }
            if (!tlsVerifyHostnames) {
                httpClientBuilder.setSSLHostnameVerifier(NoopHostnameVerifier.INSTANCE);
                log.warn("TLS hostname verification disabled - not recommended for production");
            }
            log.debug("TLS configuration completed - certificate verification: {}, hostname verification: {}", (Object)tlsVerifyCertificate, (Object)tlsVerifyHostnames);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to configure TLS settings", e);
        }
    }
}

