/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.datahub.client.example.examples;

import com.aliyun.datahub.client.DatahubClient;
import com.aliyun.datahub.client.DatahubClientBuilder;
import com.aliyun.datahub.client.auth.AliyunAccount;
import com.aliyun.datahub.client.common.DatahubConfig;
import com.aliyun.datahub.client.exception.AuthorizationFailureException;
import com.aliyun.datahub.client.exception.DatahubClientException;
import com.aliyun.datahub.client.exception.InvalidParameterException;
import com.aliyun.datahub.client.exception.NoPermissionException;
import com.aliyun.datahub.client.exception.ResourceAlreadyExistException;
import com.aliyun.datahub.client.exception.ResourceNotFoundException;
import com.aliyun.datahub.client.model.GetProjectResult;
import com.aliyun.datahub.client.model.ListProjectResult;

public class ProjectExample {
    private static DatahubClient datahubClient;

    public static void init() {
        datahubClient = DatahubClientBuilder.newBuilder().setDatahubConfig(new DatahubConfig("", new AliyunAccount("", ""), true)).build();
    }

    public static void createProject() {
        try {
            datahubClient.createProject("", "");
            System.out.println("create project successful");
        }
        catch (InvalidParameterException e) {
            e.printStackTrace();
            throw e;
        }
        catch (AuthorizationFailureException e) {
            e.printStackTrace();
            throw e;
        }
        catch (ResourceAlreadyExistException e) {
            System.out.println("project already exists, create project successful");
        }
        catch (DatahubClientException e) {
            e.printStackTrace();
            throw e;
        }
    }

    public static void deleteProject() {
        try {
            datahubClient.deleteProject("");
            System.out.println("delete project successful");
        }
        catch (InvalidParameterException e) {
            e.printStackTrace();
            throw e;
        }
        catch (AuthorizationFailureException e) {
            e.printStackTrace();
            throw e;
        }
        catch (ResourceNotFoundException e) {
            System.out.println("project already exists, create project successful");
        }
        catch (NoPermissionException e) {
            e.printStackTrace();
            throw e;
        }
        catch (DatahubClientException e) {
            e.printStackTrace();
            throw e;
        }
    }

    public static void updateProject() {
        try {
            String newComment = "new project comment";
            datahubClient.updateProject("", newComment);
            System.out.println("update project successful");
        }
        catch (InvalidParameterException e) {
            e.printStackTrace();
            throw e;
        }
        catch (AuthorizationFailureException e) {
            e.printStackTrace();
            throw e;
        }
        catch (ResourceNotFoundException e) {
            e.printStackTrace();
            throw e;
        }
        catch (DatahubClientException e) {
            e.printStackTrace();
            throw e;
        }
    }

    public static void listProject() {
        try {
            ListProjectResult listProjectResult = datahubClient.listProject();
            if (listProjectResult.getProjectNames().size() > 0) {
                for (String pName : listProjectResult.getProjectNames()) {
                    System.out.println(pName);
                }
            }
        }
        catch (AuthorizationFailureException e) {
            e.printStackTrace();
            throw e;
        }
        catch (DatahubClientException e) {
            e.printStackTrace();
            throw e;
        }
    }

    public static void getProject() {
        try {
            GetProjectResult getProjectResult = datahubClient.getProject("");
            System.out.println(getProjectResult.getCreateTime() + "\t" + getProjectResult.getLastModifyTime() + "\t" + getProjectResult.getComment());
        }
        catch (InvalidParameterException e) {
            e.printStackTrace();
            throw e;
        }
        catch (AuthorizationFailureException e) {
            e.printStackTrace();
            throw e;
        }
        catch (ResourceNotFoundException e) {
            e.printStackTrace();
            throw e;
        }
        catch (DatahubClientException e) {
            e.printStackTrace();
            throw e;
        }
    }

    public static void main(String[] args2) {
        ProjectExample.init();
        ProjectExample.createProject();
        ProjectExample.listProject();
        ProjectExample.updateProject();
        ProjectExample.getProject();
        ProjectExample.deleteProject();
    }
}

