/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.datahub.client.example.examples;

import com.aliyun.datahub.client.DatahubClient;
import com.aliyun.datahub.client.DatahubClientBuilder;
import com.aliyun.datahub.client.auth.AliyunAccount;
import com.aliyun.datahub.client.common.DatahubConfig;
import com.aliyun.datahub.client.exception.AuthorizationFailureException;
import com.aliyun.datahub.client.exception.DatahubClientException;
import com.aliyun.datahub.client.exception.InvalidParameterException;
import com.aliyun.datahub.client.exception.ResourceNotFoundException;
import com.aliyun.datahub.client.exception.SeekOutOfRangeException;
import com.aliyun.datahub.client.model.CursorType;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

public class CursorExample {
    private static DatahubClient datahubClient;

    public static void init() {
        datahubClient = DatahubClientBuilder.newBuilder().setDatahubConfig(new DatahubConfig("", new AliyunAccount("", ""), true)).build();
    }

    public static void getCursor() {
        String shardId = "0";
        try {
            String oldestCursor = datahubClient.getCursor("", "", shardId, CursorType.OLDEST).getCursor();
            String latestCursor = datahubClient.getCursor("", "", shardId, CursorType.LATEST).getCursor();
            long seq = datahubClient.getCursor("", "", shardId, CursorType.LATEST).getSequence();
            String seqCursor = datahubClient.getCursor("", "", shardId, CursorType.SEQUENCE, seq - 9L).getCursor();
            String time = "2019-07-01 09:00:00";
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            Date date = simpleDateFormat.parse(time);
            long timestamp = date.getTime();
            String timeCursor = datahubClient.getCursor("", "", shardId, CursorType.SYSTEM_TIME, timestamp).getCursor();
            System.out.println("get cursor successful");
        }
        catch (InvalidParameterException e) {
            e.printStackTrace();
            throw e;
        }
        catch (AuthorizationFailureException e) {
            e.printStackTrace();
            throw e;
        }
        catch (ResourceNotFoundException e) {
            e.printStackTrace();
            throw e;
        }
        catch (SeekOutOfRangeException e) {
            e.printStackTrace();
            throw e;
        }
        catch (DatahubClientException e) {
            e.printStackTrace();
            throw e;
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args2) {
    }
}

