/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.datahub.client.example;

import com.aliyun.datahub.client.example.BaseExample;
import com.aliyun.datahub.client.model.Field;
import com.aliyun.datahub.client.model.FieldType;
import com.aliyun.datahub.client.model.GetMeterInfoResult;
import com.aliyun.datahub.client.model.GetProjectResult;
import com.aliyun.datahub.client.model.GetTopicResult;
import com.aliyun.datahub.client.model.ListProjectResult;
import com.aliyun.datahub.client.model.ListShardResult;
import com.aliyun.datahub.client.model.ListTopicResult;
import com.aliyun.datahub.client.model.MergeShardResult;
import com.aliyun.datahub.client.model.RecordSchema;
import com.aliyun.datahub.client.model.RecordType;
import com.aliyun.datahub.client.model.SplitShardResult;

public class ProjectTopicExample
extends BaseExample {
    @Override
    public void runExample() {
        this.createProjectAndTopic();
        this.operateOnProject();
        this.operateOnTopic();
    }

    private void createProjectAndTopic() {
        this.client.createProject("** datahub project **", "test comment");
        this.client.createTopic("** datahub project **", "** datahub blob topic **", 4, 1, RecordType.BLOB, "test comment");
        RecordSchema schema = new RecordSchema();
        schema.addField(new Field("field1", FieldType.STRING));
        schema.addField(new Field("field2", FieldType.BIGINT));
        this.client.createTopic("** datahub project **", "** datahub tuple topic **", 4, 1, RecordType.TUPLE, schema, "test comment");
    }

    private void operateOnProject() {
        GetProjectResult getProjectResult = this.client.getProject("** datahub project **");
        ListProjectResult listProjectResult = this.client.listProject();
        this.client.updateProject("** datahub project **", "update comment");
    }

    private void operateOnTopic() {
        this.client.waitForShardReady("** datahub project **", "** datahub tuple topic **");
        ListShardResult listShardResult = this.client.listShard("** datahub project **", "** datahub tuple topic **");
        GetTopicResult getTopicResult = this.client.getTopic("** datahub project **", "** datahub tuple topic **");
        ListTopicResult listTopicResult = this.client.listTopic("** datahub project **");
        this.client.updateTopic("** datahub project **", "** datahub tuple topic **", "update comment");
        getTopicResult = this.client.getTopic("** datahub project **", "** datahub tuple topic **");
        SplitShardResult splitShardResult = this.client.splitShard("** datahub project **", "** datahub tuple topic **", "1");
        try {
            Thread.sleep(3000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        MergeShardResult mergeShardResult = this.client.mergeShard("** datahub project **", "** datahub tuple topic **", "4", "5");
        GetMeterInfoResult getMeterInfoResult = this.client.getMeterInfo("** datahub project **", "** datahub tuple topic **", "0");
        this.client.appendField("** datahub project **", "** datahub tuple topic **", new Field("field3", FieldType.STRING));
    }

    public void deleteProjectAndTopic() {
        this.client.deleteTopic("** datahub project **", "** datahub blob topic **");
        this.client.deleteTopic("** datahub project **", "** datahub tuple topic **");
        this.client.deleteProject("** datahub project **");
    }
}

