/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.databend.util;

import org.apache.seatunnel.api.table.catalog.Column;
import org.apache.seatunnel.api.table.converter.BasicTypeDefine;
import org.apache.seatunnel.api.table.type.DecimalType;
import org.apache.seatunnel.api.table.type.SqlType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DatabendTypeConverter {
    private static final Logger log = LoggerFactory.getLogger(DatabendTypeConverter.class);

    public static BasicTypeDefine convertToDatabendType(Column column) {
        SqlType sqlType = column.getDataType().getSqlType();
        String databendType = DatabendTypeConverter.mapToDatabendType(sqlType, column);
        return BasicTypeDefine.builder().name(column.getName()).columnType(databendType).nullable(column.isNullable()).comment(column.getComment()).defaultValue(column.getDefaultValue()).build();
    }

    private static String mapToDatabendType(SqlType sqlType, Column column) {
        switch (sqlType) {
            case STRING: {
                return "STRING";
            }
            case BOOLEAN: {
                return "BOOLEAN";
            }
            case TINYINT: {
                return "TINYINT";
            }
            case SMALLINT: {
                return "SMALLINT";
            }
            case INT: {
                return "INT";
            }
            case BIGINT: {
                return "BIGINT";
            }
            case FLOAT: {
                return "FLOAT";
            }
            case DOUBLE: {
                return "DOUBLE";
            }
            case DECIMAL: {
                DecimalType decimalType = (DecimalType)column.getDataType();
                return String.format("DECIMAL(%d,%d)", decimalType.getPrecision(), decimalType.getScale());
            }
            case DATE: {
                return "DATE";
            }
            case TIME: {
                return "TIME";
            }
            case TIMESTAMP: {
                return "TIMESTAMP";
            }
            case BYTES: {
                return "VARBINARY";
            }
            case ARRAY: {
                return "ARRAY(STRING)";
            }
            case MAP: {
                return "MAP(STRING, STRING)";
            }
            case NULL: {
                return "NULL";
            }
            case ROW: {
                return "STRING";
            }
        }
        log.warn("Unsupported SQL type: {}, fallback to STRING", (Object)sqlType);
        return "STRING";
    }
}

