/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.databend.exception;

import org.apache.seatunnel.common.exception.SeaTunnelErrorCode;

public enum DatabendConnectorErrorCode implements SeaTunnelErrorCode
{
    CONNECT_FAILED("DATABEND-01", "Failed to connect to Databend"),
    SQL_OPERATION_FAILED("DATABEND-02", "Failed to execute SQL in Databend"),
    PARSE_RESPONSE_FAILED("DATABEND-03", "Failed to parse data from Databend"),
    GENERATE_SQL_FAILED("DATABEND-04", "Failed to generate SQL for Databend"),
    DRIVER_NOT_FOUND("DATABEND-05", "Failed to get driver"),
    UNSUPPORTED_DATA_TYPE("DATABEND-06", "unsupported data type"),
    ILLEGAL_STATE("DATABEND-07", "illegal state"),
    SCHEMA_NOT_FOUND(10001, "Schema not found"),
    SCHEMA_MISMATCH(10002, "Schema mismatch");

    private final String code;
    private final String description;

    private DatabendConnectorErrorCode(String code, String description) {
        this.code = code;
        this.description = description;
    }

    private DatabendConnectorErrorCode(int code, String description) {
        this.code = "DATABEND-" + code;
        this.description = description;
    }

    public String getCode() {
        return this.code;
    }

    public String getDescription() {
        return this.description;
    }
}

