/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.databend.catalog;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.apache.seatunnel.api.configuration.ReadonlyConfig;
import org.apache.seatunnel.api.table.catalog.Catalog;
import org.apache.seatunnel.api.table.catalog.CatalogTable;
import org.apache.seatunnel.api.table.catalog.Column;
import org.apache.seatunnel.api.table.catalog.PhysicalColumn;
import org.apache.seatunnel.api.table.catalog.TableIdentifier;
import org.apache.seatunnel.api.table.catalog.TablePath;
import org.apache.seatunnel.api.table.catalog.TableSchema;
import org.apache.seatunnel.api.table.catalog.exception.CatalogException;
import org.apache.seatunnel.api.table.catalog.exception.DatabaseAlreadyExistException;
import org.apache.seatunnel.api.table.catalog.exception.DatabaseNotExistException;
import org.apache.seatunnel.api.table.catalog.exception.TableAlreadyExistException;
import org.apache.seatunnel.api.table.catalog.exception.TableNotExistException;
import org.apache.seatunnel.api.table.type.BasicType;
import org.apache.seatunnel.api.table.type.DecimalType;
import org.apache.seatunnel.api.table.type.LocalTimeType;
import org.apache.seatunnel.api.table.type.SeaTunnelDataType;
import org.apache.seatunnel.connectors.seatunnel.databend.config.DatabendOptions;
import org.apache.seatunnel.connectors.seatunnel.databend.exception.DatabendConnectorErrorCode;
import org.apache.seatunnel.connectors.seatunnel.databend.exception.DatabendConnectorException;
import org.apache.seatunnel.connectors.seatunnel.databend.util.DatabendUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DatabendCatalog
implements Catalog {
    private static final Logger log = LoggerFactory.getLogger(DatabendCatalog.class);
    private static final String DATABEND_DRIVER_NAME = "com.databend.jdbc.DatabendDriver";
    private final String catalogName;
    protected String defaultDatabase;
    private boolean isOpened;
    private ReadonlyConfig readonlyConfig;

    public DatabendCatalog(ReadonlyConfig readonlyConfig, String catalogName) {
        this.catalogName = catalogName;
        this.readonlyConfig = readonlyConfig;
    }

    public void createDatabase(TablePath tablePath, boolean ignoreIfExists) throws DatabaseAlreadyExistException, CatalogException {
        String databaseName = tablePath.getDatabaseName();
        this.createDatabase(databaseName, ignoreIfExists);
    }

    public void dropDatabase(TablePath tablePath, boolean ignoreIfNotExists) throws DatabaseNotExistException, CatalogException {
        String databaseName = tablePath.getDatabaseName();
        this.dropDatabase(databaseName, ignoreIfNotExists);
    }

    public void open() throws CatalogException {
        if (this.isOpened) {
            return;
        }
        try (Connection connection = this.getConnection();){
            log.info("Successfully connected to Databend");
            this.isOpened = true;
        }
        catch (SQLException e) {
            throw new DatabendConnectorException(DatabendConnectorErrorCode.CONNECT_FAILED, "Failed to connect to Databend server: " + e.getMessage(), e);
        }
    }

    public void close() throws CatalogException {
        this.isOpened = false;
    }

    public String name() {
        return this.catalogName;
    }

    public String getDefaultDatabase() throws CatalogException {
        return this.defaultDatabase;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean databaseExists(String databaseName) throws CatalogException {
        this.checkOpen();
        try (Connection connection = this.getConnection();
             ResultSet resultSet = connection.getMetaData().getSchemas();){
            String foundDb;
            do {
                if (!resultSet.next()) return false;
            } while (!databaseName.equalsIgnoreCase(foundDb = resultSet.getString("table_schema")));
            boolean bl = true;
            return bl;
        }
        catch (SQLException e) {
            throw new DatabendConnectorException(DatabendConnectorErrorCode.SQL_OPERATION_FAILED, "Failed to check if database exists: " + e.getMessage(), e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<String> listDatabases() throws CatalogException {
        this.checkOpen();
        try (Connection connection = this.getConnection();){
            ArrayList<String> databases = new ArrayList<String>();
            try (ResultSet resultSet = connection.getMetaData().getSchemas();){
                while (resultSet.next()) {
                    String databaseName = resultSet.getString("TABLE_SCHEM");
                    databases.add(databaseName);
                }
            }
            ArrayList<String> arrayList = databases;
            return arrayList;
        }
        catch (SQLException e) {
            throw new DatabendConnectorException(DatabendConnectorErrorCode.SQL_OPERATION_FAILED, "Failed to list databases: " + e.getMessage(), e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<String> listTables(String databaseName) throws CatalogException, DatabaseNotExistException {
        this.checkOpen();
        if (!this.databaseExists(databaseName)) {
            throw new DatabaseNotExistException(this.catalogName, databaseName);
        }
        try (Connection connection = this.getConnection();){
            DatabaseMetaData metaData = connection.getMetaData();
            ArrayList<String> tables = new ArrayList<String>();
            try (ResultSet resultSet = metaData.getTables(null, databaseName, null, new String[]{"TABLE"});){
                while (resultSet.next()) {
                    String tableName = resultSet.getString("TABLE_NAME");
                    tables.add(tableName);
                }
            }
            ArrayList<String> arrayList = tables;
            return arrayList;
        }
        catch (SQLException e) {
            throw new DatabendConnectorException(DatabendConnectorErrorCode.SQL_OPERATION_FAILED, "Failed to list tables: " + e.getMessage(), e);
        }
    }

    /*
     * Exception decompiling
     */
    public boolean tableExists(TablePath tablePath) throws CatalogException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public CatalogTable getTable(TablePath tablePath) throws CatalogException, TableNotExistException {
        this.checkOpen();
        if (!this.tableExists(tablePath)) {
            throw new TableNotExistException(this.catalogName, tablePath);
        }
        try (Connection connection = this.getConnection();){
            String databaseName = tablePath.getDatabaseName();
            String tableName = tablePath.getTableName();
            ArrayList<PhysicalColumn> columns = new ArrayList<PhysicalColumn>();
            try (ResultSet resultSet = connection.getMetaData().getColumns(null, databaseName, tableName, null);){
                while (resultSet.next()) {
                    String columnName = resultSet.getString("COLUMN_NAME");
                    String typeName = resultSet.getString("TYPE_NAME");
                    int dataType = resultSet.getInt("DATA_TYPE");
                    int columnSize = resultSet.getInt("COLUMN_SIZE");
                    int decimalDigits = resultSet.getInt("DECIMAL_DIGITS");
                    String isNullable = resultSet.getString("IS_NULLABLE");
                    String remarks = resultSet.getString("REMARKS");
                    SeaTunnelDataType<?> seaTunnelType = this.convertDatabendType(typeName, dataType, columnSize, decimalDigits);
                    PhysicalColumn.PhysicalColumnBuilder builder = PhysicalColumn.builder().name(columnName).dataType(seaTunnelType).nullable("YES".equalsIgnoreCase(isNullable));
                    if (remarks != null && !remarks.isEmpty()) {
                        builder.comment(remarks);
                    }
                    columns.add(builder.build());
                }
            }
            TableSchema tableSchema = TableSchema.builder().columns(columns).build();
            HashMap<String, Object> properties = new HashMap<String, Object>();
            properties.put("connector", "databend");
            properties.put("url", this.readonlyConfig.get(DatabendOptions.URL));
            properties.put("username", this.readonlyConfig.get(DatabendOptions.USERNAME));
            properties.put("password", this.readonlyConfig.get(DatabendOptions.PASSWORD));
            properties.put("database", this.readonlyConfig.get(DatabendOptions.DATABASE));
            properties.put("table", this.readonlyConfig.get(DatabendOptions.TABLE));
            TableIdentifier tableIdentifier = TableIdentifier.of((String)this.catalogName, (String)databaseName, (String)tableName);
            CatalogTable catalogTable = CatalogTable.of((TableIdentifier)tableIdentifier, (TableSchema)tableSchema, properties, Collections.emptyList(), null, (String)"false");
            return catalogTable;
        }
        catch (SQLException e) {
            throw new DatabendConnectorException(DatabendConnectorErrorCode.SQL_OPERATION_FAILED, "Failed to get table metadata: " + e.getMessage(), e);
        }
    }

    public void createTable(TablePath tablePath, CatalogTable table, boolean ignoreIfExists) throws TableAlreadyExistException, DatabaseNotExistException, CatalogException {
        this.checkOpen();
        String databaseName = tablePath.getDatabaseName();
        String tableName = tablePath.getTableName();
        if (!this.databaseExists(databaseName)) {
            throw new DatabaseNotExistException(this.catalogName, databaseName);
        }
        if (this.tableExists(tablePath)) {
            if (ignoreIfExists) {
                return;
            }
            throw new TableAlreadyExistException(this.catalogName, tablePath);
        }
        String createTableSql = this.buildCreateTableSql(databaseName, tableName, table.getTableSchema());
        try (Connection connection = this.getConnection();
             Statement statement = connection.createStatement();){
            statement.execute(createTableSql);
        }
        catch (SQLException e) {
            throw new DatabendConnectorException(DatabendConnectorErrorCode.SQL_OPERATION_FAILED, "Failed to create table: " + e.getMessage(), e);
        }
    }

    public void dropTable(TablePath tablePath, boolean ignoreIfNotExists) throws TableNotExistException, CatalogException {
        this.checkOpen();
        if (!this.tableExists(tablePath)) {
            if (ignoreIfNotExists) {
                return;
            }
            throw new TableNotExistException(this.catalogName, tablePath);
        }
        String databaseName = tablePath.getDatabaseName();
        String tableName = tablePath.getTableName();
        String dropTableSql = String.format("DROP TABLE %s.%s", databaseName, tableName);
        try (Connection connection = this.getConnection();
             Statement statement = connection.createStatement();){
            statement.execute(dropTableSql);
        }
        catch (SQLException e) {
            throw new DatabendConnectorException(DatabendConnectorErrorCode.SQL_OPERATION_FAILED, "Failed to drop table: " + e.getMessage(), e);
        }
    }

    public void createDatabase(String databaseName, boolean ignoreIfExists) throws DatabaseAlreadyExistException, CatalogException {
        this.checkOpen();
        if (this.databaseExists(databaseName)) {
            if (ignoreIfExists) {
                return;
            }
            throw new DatabaseAlreadyExistException(this.catalogName, databaseName);
        }
        String createDatabaseSql = String.format("CREATE DATABASE %s", databaseName);
        try (Connection connection = this.getConnection();
             Statement statement = connection.createStatement();){
            statement.execute(createDatabaseSql);
        }
        catch (SQLException e) {
            throw new DatabendConnectorException(DatabendConnectorErrorCode.SQL_OPERATION_FAILED, "Failed to create database: " + e.getMessage(), e);
        }
    }

    public void dropDatabase(String databaseName, boolean ignoreIfNotExists) throws DatabaseNotExistException, CatalogException {
        this.checkOpen();
        if (!this.databaseExists(databaseName)) {
            if (ignoreIfNotExists) {
                return;
            }
            throw new DatabaseNotExistException(this.catalogName, databaseName);
        }
        String dropDatabaseSql = String.format("DROP DATABASE %s", databaseName);
        try (Connection connection = this.getConnection();
             Statement statement = connection.createStatement();){
            statement.execute(dropDatabaseSql);
        }
        catch (SQLException e) {
            throw new DatabendConnectorException(DatabendConnectorErrorCode.SQL_OPERATION_FAILED, "Failed to drop database: " + e.getMessage(), e);
        }
    }

    private String buildCreateTableSql(String databaseName, String tableName, TableSchema tableSchema) {
        StringBuilder sb = new StringBuilder();
        sb.append("CREATE TABLE ").append(databaseName).append(".").append(tableName).append(" (");
        List columns = tableSchema.getColumns();
        for (int i = 0; i < columns.size(); ++i) {
            Column column = (Column)columns.get(i);
            sb.append(column.getName()).append(" ");
            sb.append(this.toDatabendTypeString(column.getDataType()));
            if (!column.isNullable()) {
                sb.append(" NOT NULL");
            }
            if (i >= columns.size() - 1) continue;
            sb.append(", ");
        }
        sb.append(")");
        return sb.toString();
    }

    private String toDatabendTypeString(SeaTunnelDataType<?> dataType) {
        switch (dataType.getSqlType()) {
            case BOOLEAN: {
                return "BOOLEAN";
            }
            case TINYINT: {
                return "TINYINT";
            }
            case SMALLINT: {
                return "SMALLINT";
            }
            case INT: {
                return "INT";
            }
            case BIGINT: {
                return "BIGINT";
            }
            case FLOAT: {
                return "FLOAT";
            }
            case DOUBLE: {
                return "DOUBLE";
            }
            case DECIMAL: {
                DecimalType decimalType = (DecimalType)dataType;
                return String.format("DECIMAL(%d, %d)", decimalType.getPrecision(), decimalType.getScale());
            }
            case BYTES: {
                return "VARBINARY";
            }
            case STRING: {
                return "VARCHAR";
            }
            case DATE: {
                return "DATE";
            }
            case TIME: {
                return "TIME";
            }
            case TIMESTAMP: {
                LocalTimeType timeType = (LocalTimeType)dataType;
                return String.format("TIMESTAMP(%d)", new Object[0]);
            }
        }
        throw new DatabendConnectorException(DatabendConnectorErrorCode.UNSUPPORTED_DATA_TYPE, "Unsupported data type: " + dataType.getSqlType());
    }

    private SeaTunnelDataType<?> convertDatabendType(String typeName, int sqlType, int columnSize, int decimalDigits) {
        switch (typeName = typeName.toUpperCase()) {
            case "BOOLEAN": {
                return BasicType.BOOLEAN_TYPE;
            }
            case "TINYINT": 
            case "INT8": {
                return BasicType.BYTE_TYPE;
            }
            case "SMALLINT": 
            case "INT16": {
                return BasicType.SHORT_TYPE;
            }
            case "INT": 
            case "INTEGER": 
            case "INT32": {
                return BasicType.INT_TYPE;
            }
            case "BIGINT": 
            case "INT64": {
                return BasicType.LONG_TYPE;
            }
            case "FLOAT": 
            case "FLOAT32": {
                return BasicType.FLOAT_TYPE;
            }
            case "DOUBLE": 
            case "FLOAT64": {
                return BasicType.DOUBLE_TYPE;
            }
            case "DECIMAL": {
                return new DecimalType(columnSize, decimalDigits);
            }
            case "STRING": 
            case "VARCHAR": 
            case "CHAR": 
            case "TEXT": {
                return BasicType.STRING_TYPE;
            }
            case "DATE": {
                return LocalTimeType.LOCAL_DATE_TYPE;
            }
            case "TIMESTAMP": {
                return LocalTimeType.LOCAL_DATE_TIME_TYPE;
            }
            case "VARBINARY": 
            case "BINARY": {
                return BasicType.BYTE_TYPE;
            }
        }
        log.warn("Unsupported Databend type: {}, fallback to STRING type", (Object)typeName);
        return BasicType.STRING_TYPE;
    }

    private Connection getConnection() throws SQLException {
        return DatabendUtil.createConnection(this.readonlyConfig);
    }

    private void checkOpen() {
        if (!this.isOpened) {
            throw new DatabendConnectorException(DatabendConnectorErrorCode.ILLEGAL_STATE, "Databend catalog is not opened. Please call open() first.");
        }
    }

    static {
        try {
            Class.forName(DATABEND_DRIVER_NAME);
        }
        catch (ClassNotFoundException e) {
            throw new DatabendConnectorException(DatabendConnectorErrorCode.DRIVER_NOT_FOUND, "Cannot find Databend JDBC driver", e);
        }
    }
}

