/*
 * Decompiled with CFR 0.152.
 */
package com.databend.jdbc.cloud;

import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Logger;
import javax.annotation.Nullable;
import okhttp3.MediaType;
import okhttp3.RequestBody;
import okio.BufferedSink;
import okio.Okio;
import okio.Source;
import org.checkerframework.checker.nullness.qual.NonNull;

class InputStreamRequestBody
extends RequestBody {
    private final InputStream inputStream;
    private final MediaType contentType;
    private final long fileSize;
    private static final Logger logger = Logger.getLogger(InputStreamRequestBody.class.getPackage().getName());

    public InputStreamRequestBody(MediaType contentType, InputStream inputStream2, long fileSize) {
        if (inputStream2 == null) {
            throw new NullPointerException("inputStream == null");
        }
        this.contentType = contentType;
        this.inputStream = inputStream2;
        this.fileSize = fileSize;
    }

    @Override
    @Nullable
    public MediaType contentType() {
        return this.contentType;
    }

    @Override
    public long contentLength() {
        return this.fileSize;
    }

    @Override
    public void writeTo(@NonNull BufferedSink sink2) throws IOException {
        try (Source source2 = Okio.source(this.inputStream);){
            sink2.writeAll(source2);
        }
        catch (IOException e) {
            logger.warning(String.format("writeTo failed, error is %s, cause is %s", e.getMessage(), e.getCause()));
        }
    }
}

