/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.jdbc.internal.split;

import java.io.Serializable;
import java.math.BigDecimal;
import java.math.RoundingMode;
import org.apache.seatunnel.connectors.seatunnel.jdbc.internal.split.JdbcParameterValuesProvider;
import org.apache.seatunnel.shade.com.google.common.base.Preconditions;

public class JdbcNumericBetweenParametersProvider
implements JdbcParameterValuesProvider {
    private final BigDecimal minVal;
    private final BigDecimal maxVal;
    private long batchSize;
    private int batchNum;

    public JdbcNumericBetweenParametersProvider(BigDecimal minVal, BigDecimal maxVal) {
        Preconditions.checkArgument((minVal.compareTo(maxVal) <= 0 ? 1 : 0) != 0, (Object)"minVal must not be larger than maxVal");
        this.minVal = minVal;
        this.maxVal = maxVal;
    }

    public JdbcNumericBetweenParametersProvider(long fetchSize, BigDecimal minVal, BigDecimal maxVal) {
        Preconditions.checkArgument((minVal.compareTo(maxVal) <= 0 ? 1 : 0) != 0, (Object)"minVal must not be larger than maxVal");
        this.minVal = minVal;
        this.maxVal = maxVal;
        this.ofBatchSize(fetchSize);
    }

    public JdbcNumericBetweenParametersProvider ofBatchSize(long batchSize) {
        Preconditions.checkArgument((batchSize > 0L ? 1 : 0) != 0, (Object)"Batch size must be positive");
        BigDecimal maxElemCount = this.maxVal.subtract(this.minVal).add(BigDecimal.valueOf(1L));
        if (BigDecimal.valueOf(batchSize).compareTo(maxElemCount) > 0) {
            batchSize = maxElemCount.longValue();
        }
        this.batchSize = batchSize;
        this.batchNum = new Double(Math.ceil(maxElemCount.divide(BigDecimal.valueOf(batchSize)).doubleValue())).intValue();
        return this;
    }

    public JdbcNumericBetweenParametersProvider ofBatchNum(int batchNum) {
        Preconditions.checkArgument((batchNum > 0 ? 1 : 0) != 0, (Object)"Batch number must be positive");
        BigDecimal maxElemCount = this.maxVal.subtract(this.minVal).add(BigDecimal.valueOf(1L));
        if (BigDecimal.valueOf(batchNum).compareTo(maxElemCount) > 0) {
            batchNum = maxElemCount.intValue();
        }
        this.batchNum = batchNum;
        this.batchSize = maxElemCount.divide(BigDecimal.valueOf(batchNum), 2, RoundingMode.HALF_UP).setScale(0, RoundingMode.CEILING).longValue();
        return this;
    }

    @Override
    public Serializable[][] getParameterValues() {
        Preconditions.checkState((this.batchSize > 0L ? 1 : 0) != 0, (Object)"Batch size and batch number must be positive. Have you called `ofBatchSize` or `ofBatchNum`?");
        BigDecimal maxElemCount = this.maxVal.subtract(this.minVal).add(BigDecimal.valueOf(1L));
        BigDecimal bigBatchNum = maxElemCount.subtract(BigDecimal.valueOf(this.batchSize - 1L)).multiply(BigDecimal.valueOf(this.batchNum));
        Serializable[][] parameters = new Serializable[this.batchNum][2];
        BigDecimal start = this.minVal;
        for (int i = 0; i < this.batchNum; ++i) {
            BigDecimal end = start.add(BigDecimal.valueOf(this.batchSize)).subtract(BigDecimal.valueOf(1L)).subtract(BigDecimal.valueOf(i).compareTo(bigBatchNum) >= 0 ? BigDecimal.ONE : BigDecimal.ZERO);
            parameters[i] = new BigDecimal[]{start, end};
            start = end.add(BigDecimal.valueOf(1L));
        }
        return parameters;
    }
}

