/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.jdbc.internal.dialect.xugu;

import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.Arrays;
import org.apache.seatunnel.api.table.catalog.Column;
import org.apache.seatunnel.api.table.converter.BasicTypeDefine;
import org.apache.seatunnel.connectors.seatunnel.common.source.TypeDefineUtils;
import org.apache.seatunnel.connectors.seatunnel.jdbc.internal.dialect.JdbcDialectTypeMapper;
import org.apache.seatunnel.connectors.seatunnel.jdbc.internal.dialect.xugu.XuguTypeConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XuguTypeMapper
implements JdbcDialectTypeMapper {
    private static final Logger log = LoggerFactory.getLogger(XuguTypeMapper.class);

    @Override
    public Column mappingColumn(BasicTypeDefine typeDefine) {
        return XuguTypeConverter.INSTANCE.convert(typeDefine);
    }

    @Override
    public Column mappingColumn(ResultSetMetaData metadata, int colIndex) throws SQLException {
        String columnName = metadata.getColumnLabel(colIndex);
        String nativeType = metadata.getColumnTypeName(colIndex);
        int isNullable = metadata.isNullable(colIndex);
        long precision = metadata.getPrecision(colIndex);
        int scale = metadata.getScale(colIndex);
        if (Arrays.asList("CHAR", "NCHAR", "VARCHAR", "VARCHAR2").contains(nativeType)) {
            long octetByteLength;
            precision = octetByteLength = TypeDefineUtils.charTo4ByteLength(precision).longValue();
        }
        BasicTypeDefine typeDefine = BasicTypeDefine.builder().name(columnName).columnType(nativeType).dataType(nativeType).nullable(isNullable == 1).length(Long.valueOf(precision)).precision(Long.valueOf(precision)).scale(Integer.valueOf(scale)).build();
        return this.mappingColumn(typeDefine);
    }
}

