/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.jdbc.internal.dialect.xugu;

import com.google.auto.service.AutoService;
import org.apache.seatunnel.api.table.catalog.Column;
import org.apache.seatunnel.api.table.catalog.PhysicalColumn;
import org.apache.seatunnel.api.table.converter.BasicTypeDefine;
import org.apache.seatunnel.api.table.converter.TypeConverter;
import org.apache.seatunnel.api.table.type.BasicType;
import org.apache.seatunnel.api.table.type.DecimalType;
import org.apache.seatunnel.api.table.type.LocalTimeType;
import org.apache.seatunnel.api.table.type.PrimitiveByteArrayType;
import org.apache.seatunnel.api.table.type.SeaTunnelDataType;
import org.apache.seatunnel.common.exception.CommonError;
import org.apache.seatunnel.connectors.seatunnel.common.source.TypeDefineUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@AutoService(value={TypeConverter.class})
public class XuguTypeConverter
implements TypeConverter<BasicTypeDefine> {
    private static final Logger log = LoggerFactory.getLogger(XuguTypeConverter.class);
    public static final String XUGU_NUMERIC = "NUMERIC";
    public static final String XUGU_NUMBER = "NUMBER";
    public static final String XUGU_DECIMAL = "DECIMAL";
    public static final String XUGU_INTEGER = "INTEGER";
    public static final String XUGU_INT = "INT";
    public static final String XUGU_BIGINT = "BIGINT";
    public static final String XUGU_TINYINT = "TINYINT";
    public static final String XUGU_SMALLINT = "SMALLINT";
    public static final String XUGU_FLOAT = "FLOAT";
    public static final String XUGU_DOUBLE = "DOUBLE";
    public static final String XUGU_CHAR = "CHAR";
    public static final String XUGU_NCHAR = "NCHAR";
    public static final String XUGU_VARCHAR = "VARCHAR";
    public static final String XUGU_VARCHAR2 = "VARCHAR2";
    public static final String XUGU_CLOB = "CLOB";
    public static final String XUGU_DATE = "DATE";
    public static final String XUGU_TIME = "TIME";
    public static final String XUGU_TIMESTAMP = "TIMESTAMP";
    public static final String XUGU_DATETIME = "DATETIME";
    public static final String XUGU_DATETIME_WITH_TIME_ZONE = "DATETIME WITH TIME ZONE";
    public static final String XUGU_TIME_WITH_TIME_ZONE = "TIME WITH TIME ZONE";
    public static final String XUGU_TIMESTAMP_WITH_TIME_ZONE = "TIMESTAMP WITH TIME ZONE";
    public static final String XUGU_BINARY = "BINARY";
    public static final String XUGU_BLOB = "BLOB";
    public static final String XUGU_GUID = "GUID";
    public static final String XUGU_BOOLEAN = "BOOLEAN";
    public static final String XUGU_BOOL = "BOOL";
    public static final String XUGU_JSON = "JSON";
    public static final int MAX_PRECISION = 38;
    public static final int DEFAULT_PRECISION = 38;
    public static final int MAX_SCALE = 38;
    public static final int DEFAULT_SCALE = 18;
    public static final int TIMESTAMP_DEFAULT_SCALE = 3;
    public static final int MAX_TIMESTAMP_SCALE = 6;
    public static final int MAX_TIME_SCALE = 3;
    public static final long MAX_VARCHAR_LENGTH = 60000L;
    public static final long POWER_2_16 = (long)Math.pow(2.0, 16.0);
    public static final long BYTES_2GB = (long)Math.pow(2.0, 31.0);
    public static final long MAX_BINARY_LENGTH = POWER_2_16 - 4L;
    public static final XuguTypeConverter INSTANCE = new XuguTypeConverter();

    public String identifier() {
        return "XUGU";
    }

    public Column convert(BasicTypeDefine typeDefine) {
        String xuguDataType;
        PhysicalColumn.PhysicalColumnBuilder builder = PhysicalColumn.builder().name(typeDefine.getName()).sourceType(typeDefine.getColumnType()).nullable(typeDefine.isNullable()).defaultValue(typeDefine.getDefaultValue()).comment(typeDefine.getComment());
        switch (xuguDataType = typeDefine.getDataType().toUpperCase()) {
            case "BOOLEAN": 
            case "BOOL": {
                builder.dataType((SeaTunnelDataType)BasicType.BOOLEAN_TYPE);
                break;
            }
            case "TINYINT": {
                builder.dataType((SeaTunnelDataType)BasicType.BYTE_TYPE);
                break;
            }
            case "SMALLINT": {
                builder.dataType((SeaTunnelDataType)BasicType.SHORT_TYPE);
                break;
            }
            case "INT": 
            case "INTEGER": {
                builder.dataType((SeaTunnelDataType)BasicType.INT_TYPE);
                break;
            }
            case "BIGINT": {
                builder.dataType((SeaTunnelDataType)BasicType.LONG_TYPE);
                break;
            }
            case "FLOAT": {
                builder.dataType((SeaTunnelDataType)BasicType.FLOAT_TYPE);
                break;
            }
            case "DOUBLE": {
                builder.dataType((SeaTunnelDataType)BasicType.DOUBLE_TYPE);
                break;
            }
            case "NUMBER": 
            case "DECIMAL": 
            case "NUMERIC": {
                DecimalType decimalType = typeDefine.getPrecision() != null && typeDefine.getPrecision() > 0L ? new DecimalType(typeDefine.getPrecision().intValue(), typeDefine.getScale().intValue()) : new DecimalType(38, 18);
                builder.dataType((SeaTunnelDataType)decimalType);
                builder.columnLength(Long.valueOf(decimalType.getPrecision()));
                builder.scale(Integer.valueOf(decimalType.getScale()));
                break;
            }
            case "CHAR": 
            case "NCHAR": {
                builder.dataType((SeaTunnelDataType)BasicType.STRING_TYPE);
                if (typeDefine.getLength() == null || typeDefine.getLength() <= 0L) {
                    builder.columnLength(TypeDefineUtils.charTo4ByteLength(1L));
                    break;
                }
                builder.columnLength(typeDefine.getLength());
                break;
            }
            case "VARCHAR": 
            case "VARCHAR2": {
                builder.dataType((SeaTunnelDataType)BasicType.STRING_TYPE);
                if (typeDefine.getLength() == null || typeDefine.getLength() <= 0L) {
                    builder.columnLength(TypeDefineUtils.charTo4ByteLength(60000L));
                    break;
                }
                builder.columnLength(typeDefine.getLength());
                break;
            }
            case "CLOB": {
                builder.dataType((SeaTunnelDataType)BasicType.STRING_TYPE);
                builder.columnLength(Long.valueOf(BYTES_2GB - 1L));
                break;
            }
            case "JSON": 
            case "GUID": {
                builder.dataType((SeaTunnelDataType)BasicType.STRING_TYPE);
                break;
            }
            case "BINARY": {
                builder.dataType((SeaTunnelDataType)PrimitiveByteArrayType.INSTANCE);
                builder.columnLength(Long.valueOf(MAX_BINARY_LENGTH));
                break;
            }
            case "BLOB": {
                builder.dataType((SeaTunnelDataType)PrimitiveByteArrayType.INSTANCE);
                builder.columnLength(Long.valueOf(BYTES_2GB - 1L));
                break;
            }
            case "DATE": {
                builder.dataType((SeaTunnelDataType)LocalTimeType.LOCAL_DATE_TYPE);
                break;
            }
            case "TIME": 
            case "TIME WITH TIME ZONE": {
                builder.dataType((SeaTunnelDataType)LocalTimeType.LOCAL_TIME_TYPE);
                break;
            }
            case "DATETIME": 
            case "DATETIME WITH TIME ZONE": {
                builder.dataType((SeaTunnelDataType)LocalTimeType.LOCAL_DATE_TIME_TYPE);
                break;
            }
            case "TIMESTAMP": 
            case "TIMESTAMP WITH TIME ZONE": {
                builder.dataType((SeaTunnelDataType)LocalTimeType.LOCAL_DATE_TIME_TYPE);
                if (typeDefine.getScale() == null) {
                    builder.scale(Integer.valueOf(3));
                    break;
                }
                builder.scale(typeDefine.getScale());
                break;
            }
            default: {
                throw CommonError.convertToSeaTunnelTypeError((String)"XUGU", (String)xuguDataType, (String)typeDefine.getName());
            }
        }
        return builder.build();
    }

    public BasicTypeDefine reconvert(Column column) {
        BasicTypeDefine.BasicTypeDefineBuilder builder = BasicTypeDefine.builder().name(column.getName()).nullable(column.isNullable()).comment(column.getComment()).defaultValue(column.getDefaultValue());
        switch (column.getDataType().getSqlType()) {
            case BOOLEAN: {
                builder.columnType(XUGU_BOOLEAN);
                builder.dataType(XUGU_BOOLEAN);
                break;
            }
            case TINYINT: {
                builder.columnType(XUGU_TINYINT);
                builder.dataType(XUGU_TINYINT);
                break;
            }
            case SMALLINT: {
                builder.columnType(XUGU_SMALLINT);
                builder.dataType(XUGU_SMALLINT);
                break;
            }
            case INT: {
                builder.columnType(XUGU_INTEGER);
                builder.dataType(XUGU_INTEGER);
                break;
            }
            case BIGINT: {
                builder.columnType(XUGU_BIGINT);
                builder.dataType(XUGU_BIGINT);
                break;
            }
            case FLOAT: {
                builder.columnType(XUGU_FLOAT);
                builder.dataType(XUGU_FLOAT);
                break;
            }
            case DOUBLE: {
                builder.columnType(XUGU_DOUBLE);
                builder.dataType(XUGU_DOUBLE);
                break;
            }
            case DECIMAL: {
                DecimalType decimalType = (DecimalType)column.getDataType();
                long precision = decimalType.getPrecision();
                int scale = decimalType.getScale();
                if (precision <= 0L) {
                    precision = 38L;
                    scale = 18;
                    log.warn("The decimal column {} type decimal({},{}) is out of range, which is precision less than 0, it will be converted to decimal({},{})", new Object[]{column.getName(), decimalType.getPrecision(), decimalType.getScale(), precision, scale});
                } else if (precision > 38L) {
                    scale = (int)Math.max(0L, (long)scale - (precision - 38L));
                    precision = 38L;
                    log.warn("The decimal column {} type decimal({},{}) is out of range, which exceeds the maximum precision of {}, it will be converted to decimal({},{})", new Object[]{column.getName(), decimalType.getPrecision(), decimalType.getScale(), 38, precision, scale});
                }
                if (scale < 0) {
                    scale = 0;
                    log.warn("The decimal column {} type decimal({},{}) is out of range, which is scale less than 0, it will be converted to decimal({},{})", new Object[]{column.getName(), decimalType.getPrecision(), decimalType.getScale(), precision, scale});
                } else if (scale > 38) {
                    scale = 38;
                    log.warn("The decimal column {} type decimal({},{}) is out of range, which exceeds the maximum scale of {}, it will be converted to decimal({},{})", new Object[]{column.getName(), decimalType.getPrecision(), decimalType.getScale(), 38, precision, scale});
                }
                builder.columnType(String.format("%s(%s,%s)", XUGU_NUMERIC, precision, scale));
                builder.dataType(XUGU_NUMERIC);
                builder.precision(Long.valueOf(precision));
                builder.scale(Integer.valueOf(scale));
                break;
            }
            case BYTES: {
                if (column.getColumnLength() == null || column.getColumnLength() <= 0L) {
                    builder.columnType(XUGU_BLOB);
                    builder.dataType(XUGU_BLOB);
                    break;
                }
                if (column.getColumnLength() <= MAX_BINARY_LENGTH) {
                    builder.columnType(XUGU_BINARY);
                    builder.dataType(XUGU_BINARY);
                    break;
                }
                builder.columnType(XUGU_BLOB);
                builder.dataType(XUGU_BLOB);
                break;
            }
            case STRING: {
                if (column.getColumnLength() == null || column.getColumnLength() <= 0L) {
                    builder.columnType(String.format("%s(%s)", XUGU_VARCHAR, 60000L));
                    builder.dataType(XUGU_VARCHAR);
                    break;
                }
                if (column.getColumnLength() <= 60000L) {
                    builder.columnType(String.format("%s(%s)", XUGU_VARCHAR, column.getColumnLength()));
                    builder.dataType(XUGU_VARCHAR);
                    break;
                }
                builder.columnType(XUGU_CLOB);
                builder.dataType(XUGU_CLOB);
                break;
            }
            case DATE: {
                builder.columnType(XUGU_DATE);
                builder.dataType(XUGU_DATE);
                break;
            }
            case TIME: {
                builder.dataType(XUGU_TIME);
                if (column.getScale() != null && column.getScale() > 0) {
                    Integer timeScale = column.getScale();
                    if (timeScale > 3) {
                        timeScale = 3;
                        log.warn("The time column {} type time({}) is out of range, which exceeds the maximum scale of {}, it will be converted to time({})", new Object[]{column.getName(), column.getScale(), 38, timeScale});
                    }
                    builder.columnType(String.format("%s(%s)", XUGU_TIME, timeScale));
                    builder.scale(timeScale);
                    break;
                }
                builder.columnType(XUGU_TIME);
                break;
            }
            case TIMESTAMP: {
                if (column.getScale() == null || column.getScale() <= 0) {
                    builder.columnType(XUGU_TIMESTAMP);
                } else {
                    int timestampScale = column.getScale();
                    if (column.getScale() > 6) {
                        timestampScale = 6;
                        log.warn("The timestamp column {} type timestamp({}) is out of range, which exceeds the maximum scale of {}, it will be converted to timestamp({})", new Object[]{column.getName(), column.getScale(), 6, timestampScale});
                    }
                    builder.columnType(String.format("TIMESTAMP(%s)", timestampScale));
                    builder.scale(Integer.valueOf(timestampScale));
                }
                builder.dataType(XUGU_TIMESTAMP);
                break;
            }
            default: {
                throw CommonError.convertToConnectorTypeError((String)"XUGU", (String)column.getDataType().getSqlType().name(), (String)column.getName());
            }
        }
        return builder.build();
    }
}

