/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.jdbc.internal.dialect.saphana;

import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.seatunnel.connectors.seatunnel.jdbc.internal.converter.JdbcRowConverter;
import org.apache.seatunnel.connectors.seatunnel.jdbc.internal.dialect.JdbcDialect;
import org.apache.seatunnel.connectors.seatunnel.jdbc.internal.dialect.JdbcDialectTypeMapper;
import org.apache.seatunnel.connectors.seatunnel.jdbc.internal.dialect.saphana.SapHanaJdbcRowConverter;
import org.apache.seatunnel.connectors.seatunnel.jdbc.internal.dialect.saphana.SapHanaTypeMapper;

public class SapHanaDialect
implements JdbcDialect {
    @Override
    public String dialectName() {
        return "SapHana";
    }

    @Override
    public JdbcRowConverter getRowConverter() {
        return new SapHanaJdbcRowConverter();
    }

    @Override
    public JdbcDialectTypeMapper getJdbcDialectTypeMapper() {
        return new SapHanaTypeMapper();
    }

    @Override
    public String quoteDatabaseIdentifier(String identifier) {
        return "\"" + identifier + "\"";
    }

    @Override
    public String quoteIdentifier(String identifier) {
        if (identifier.contains(".")) {
            String[] parts = identifier.split("\\.");
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < parts.length - 1; ++i) {
                sb.append("\"").append(parts[i]).append("\"").append(".");
            }
            return sb.append("\"").append(parts[parts.length - 1]).append("\"").toString();
        }
        return "\"" + identifier + "\"";
    }

    @Override
    public Optional<String> getUpsertStatement(String database, String tableName, String[] fieldNames, String[] uniqueKeyFields) {
        List nonUniqueKeyFields = Arrays.stream(fieldNames).filter(fieldName -> !Arrays.asList(uniqueKeyFields).contains(fieldName)).collect(Collectors.toList());
        String valuesBinding = Arrays.stream(fieldNames).map(fieldName -> ":" + fieldName + " AS " + this.quoteIdentifier((String)fieldName)).collect(Collectors.joining(", "));
        String usingClause = String.format("SELECT %s FROM DUMMY", valuesBinding);
        String onConditions = Arrays.stream(uniqueKeyFields).map(fieldName -> String.format("TARGET.%s=SOURCE.%s", this.quoteIdentifier((String)fieldName), this.quoteIdentifier((String)fieldName))).collect(Collectors.joining(" AND "));
        String updateSetClause = nonUniqueKeyFields.stream().map(fieldName -> String.format("TARGET.%s=SOURCE.%s", this.quoteIdentifier((String)fieldName), this.quoteIdentifier((String)fieldName))).collect(Collectors.joining(", "));
        String insertFields = Arrays.stream(fieldNames).map(this::quoteIdentifier).collect(Collectors.joining(", "));
        String insertValues = Arrays.stream(fieldNames).map(fieldName -> "SOURCE." + this.quoteIdentifier((String)fieldName)).collect(Collectors.joining(", "));
        String upsertSQL = String.format(" MERGE INTO %s AS TARGET USING (%s) AS SOURCE ON (%s)  WHEN MATCHED THEN UPDATE SET %s WHEN NOT MATCHED THEN INSERT (%s) VALUES (%s)", this.tableIdentifier(database, tableName), usingClause, onConditions, updateSetClause, insertFields, insertValues);
        return Optional.of(upsertSQL);
    }
}

