/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.jdbc.internal.dialect.phoenix;

import org.apache.seatunnel.api.table.catalog.Column;
import org.apache.seatunnel.api.table.catalog.PhysicalColumn;
import org.apache.seatunnel.api.table.converter.BasicTypeDefine;
import org.apache.seatunnel.api.table.converter.TypeConverter;
import org.apache.seatunnel.api.table.type.ArrayType;
import org.apache.seatunnel.api.table.type.BasicType;
import org.apache.seatunnel.api.table.type.DecimalType;
import org.apache.seatunnel.api.table.type.LocalTimeType;
import org.apache.seatunnel.api.table.type.PrimitiveByteArrayType;
import org.apache.seatunnel.api.table.type.SeaTunnelDataType;
import org.apache.seatunnel.common.exception.CommonError;
import org.apache.seatunnel.connectors.seatunnel.common.source.TypeDefineUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PhoenixTypeConverter
implements TypeConverter<BasicTypeDefine> {
    private static final Logger log = LoggerFactory.getLogger(PhoenixTypeConverter.class);
    public static final String PHOENIX_UNKNOWN = "UNKNOWN";
    public static final String PHOENIX_BOOLEAN = "BOOLEAN";
    public static final String PHOENIX_ARRAY = "ARRAY";
    public static final String PHOENIX_TINYINT = "TINYINT";
    public static final String PHOENIX_UNSIGNED_TINYINT = "UNSIGNED_TINYINT";
    public static final String PHOENIX_SMALLINT = "SMALLINT";
    public static final String PHOENIX_UNSIGNED_SMALLINT = "UNSIGNED_SMALLINT";
    public static final String PHOENIX_UNSIGNED_INT = "UNSIGNED_INT";
    public static final String PHOENIX_INTEGER = "INTEGER";
    public static final String PHOENIX_BIGINT = "BIGINT";
    public static final String PHOENIX_UNSIGNED_LONG = "UNSIGNED_LONG";
    public static final String PHOENIX_DECIMAL = "DECIMAL";
    public static final String PHOENIX_FLOAT = "FLOAT";
    public static final String PHOENIX_UNSIGNED_FLOAT = "UNSIGNED_FLOAT";
    public static final String PHOENIX_DOUBLE = "DOUBLE";
    public static final String PHOENIX_UNSIGNED_DOUBLE = "UNSIGNED_DOUBLE";
    public static final String PHOENIX_CHAR = "CHAR";
    public static final String PHOENIX_VARCHAR = "VARCHAR";
    public static final String PHOENIX_DATE = "DATE";
    public static final String PHOENIX_TIME = "TIME";
    public static final String PHOENIX_TIMESTAMP = "TIMESTAMP";
    public static final String PHOENIX_DATE_UNSIGNED = "UNSIGNED_DATE";
    public static final String PHOENIX_TIME_UNSIGNED = "UNSIGNED_TIME";
    public static final String PHOENIX_TIMESTAMP_UNSIGNED = "UNSIGNED_TIMESTAMP";
    public static final String PHOENIX_BINARY = "BINARY";
    public static final String PHOENIX_VARBINARY = "VARBINARY";
    public static final int MAX_PRECISION = 1000;
    public static final int DEFAULT_PRECISION = 38;
    public static final int MAX_SCALE = 999;
    public static final int DEFAULT_SCALE = 18;
    public static final int MAX_TIME_SCALE = 6;
    public static final int MAX_TIMESTAMP_SCALE = 6;
    public static final int MAX_VARCHAR_LENGTH = 0xA00000;
    public static final PhoenixTypeConverter INSTANCE = new PhoenixTypeConverter();

    public String identifier() {
        return "Phoenix";
    }

    public Column convert(BasicTypeDefine typeDefine) {
        String phoenixDataType;
        PhysicalColumn.PhysicalColumnBuilder builder = PhysicalColumn.builder().name(typeDefine.getName()).sourceType(typeDefine.getColumnType()).nullable(typeDefine.isNullable()).defaultValue(typeDefine.getDefaultValue()).comment(typeDefine.getComment());
        switch (phoenixDataType = typeDefine.getDataType().toUpperCase()) {
            case "BOOLEAN": {
                builder.dataType((SeaTunnelDataType)BasicType.BOOLEAN_TYPE);
                break;
            }
            case "ARRAY": {
                builder.dataType((SeaTunnelDataType)ArrayType.STRING_ARRAY_TYPE);
                break;
            }
            case "TINYINT": 
            case "UNSIGNED_TINYINT": {
                builder.dataType((SeaTunnelDataType)BasicType.BYTE_TYPE);
                break;
            }
            case "SMALLINT": 
            case "UNSIGNED_SMALLINT": {
                builder.dataType((SeaTunnelDataType)BasicType.SHORT_TYPE);
                break;
            }
            case "INTEGER": 
            case "UNSIGNED_INT": {
                builder.dataType((SeaTunnelDataType)BasicType.INT_TYPE);
                break;
            }
            case "BIGINT": 
            case "UNSIGNED_LONG": {
                builder.dataType((SeaTunnelDataType)BasicType.LONG_TYPE);
                break;
            }
            case "DECIMAL": 
            case "FLOAT": 
            case "UNSIGNED_FLOAT": {
                builder.dataType((SeaTunnelDataType)BasicType.FLOAT_TYPE);
                break;
            }
            case "DOUBLE": 
            case "UNSIGNED_DOUBLE": {
                builder.dataType((SeaTunnelDataType)BasicType.DOUBLE_TYPE);
                break;
            }
            case "CHAR": 
            case "VARCHAR": {
                builder.dataType((SeaTunnelDataType)BasicType.STRING_TYPE);
                if (typeDefine.getLength() == null || typeDefine.getLength() <= 0L) {
                    builder.columnLength(Long.valueOf(1L));
                    builder.sourceType(phoenixDataType);
                    break;
                }
                builder.columnLength(TypeDefineUtils.charTo4ByteLength(typeDefine.getLength()));
                builder.sourceType(String.format("%s(%s)", phoenixDataType, typeDefine.getLength()));
                break;
            }
            case "DATE": 
            case "UNSIGNED_DATE": {
                builder.dataType((SeaTunnelDataType)LocalTimeType.LOCAL_DATE_TYPE);
                break;
            }
            case "TIME": 
            case "UNSIGNED_TIME": {
                builder.dataType((SeaTunnelDataType)LocalTimeType.LOCAL_TIME_TYPE);
                break;
            }
            case "TIMESTAMP": 
            case "UNSIGNED_TIMESTAMP": {
                builder.dataType((SeaTunnelDataType)LocalTimeType.LOCAL_DATE_TIME_TYPE);
                break;
            }
            case "BINARY": 
            case "VARBINARY": {
                builder.dataType((SeaTunnelDataType)PrimitiveByteArrayType.INSTANCE);
                break;
            }
            default: {
                throw CommonError.convertToSeaTunnelTypeError((String)"Phoenix", (String)typeDefine.getDataType(), (String)typeDefine.getName());
            }
        }
        return builder.build();
    }

    public BasicTypeDefine reconvert(Column column) {
        BasicTypeDefine.BasicTypeDefineBuilder builder = BasicTypeDefine.builder().name(column.getName()).nullable(column.isNullable()).comment(column.getComment()).defaultValue(column.getDefaultValue());
        block0 : switch (column.getDataType().getSqlType()) {
            case BOOLEAN: {
                builder.columnType(PHOENIX_BOOLEAN);
                builder.dataType(PHOENIX_BOOLEAN);
                break;
            }
            case TINYINT: {
                builder.columnType(PHOENIX_TINYINT);
                builder.dataType(PHOENIX_TINYINT);
            }
            case SMALLINT: {
                builder.columnType(PHOENIX_SMALLINT);
                builder.dataType(PHOENIX_SMALLINT);
                break;
            }
            case INT: {
                builder.columnType(PHOENIX_INTEGER);
                builder.dataType(PHOENIX_INTEGER);
                break;
            }
            case BIGINT: {
                builder.columnType(PHOENIX_BIGINT);
                builder.dataType(PHOENIX_BIGINT);
                break;
            }
            case FLOAT: {
                builder.columnType(PHOENIX_FLOAT);
                builder.dataType(PHOENIX_FLOAT);
                break;
            }
            case DOUBLE: {
                builder.columnType(PHOENIX_DOUBLE);
                builder.dataType(PHOENIX_DOUBLE);
                break;
            }
            case DECIMAL: {
                DecimalType decimalType = (DecimalType)column.getDataType();
                long precision = decimalType.getPrecision();
                int scale = decimalType.getScale();
                if (precision <= 0L) {
                    precision = 38L;
                    scale = 18;
                    log.warn("The decimal column {} type decimal({},{}) is out of range, which is precision less than 0, it will be converted to decimal({},{})", new Object[]{column.getName(), decimalType.getPrecision(), decimalType.getScale(), precision, scale});
                } else if (precision > 1000L) {
                    scale = (int)Math.max(0L, (long)scale - (precision - 1000L));
                    precision = 1000L;
                    log.warn("The decimal column {} type decimal({},{}) is out of range, which exceeds the maximum precision of {}, it will be converted to decimal({},{})", new Object[]{column.getName(), decimalType.getPrecision(), decimalType.getScale(), 1000, precision, scale});
                }
                if (scale < 0) {
                    scale = 0;
                    log.warn("The decimal column {} type decimal({},{}) is out of range, which is scale less than 0, it will be converted to decimal({},{})", new Object[]{column.getName(), decimalType.getPrecision(), decimalType.getScale(), precision, scale});
                } else if (scale > 999) {
                    scale = 999;
                    log.warn("The decimal column {} type decimal({},{}) is out of range, which exceeds the maximum scale of {}, it will be converted to decimal({},{})", new Object[]{column.getName(), decimalType.getPrecision(), decimalType.getScale(), 999, precision, scale});
                }
                builder.columnType(String.format("%s(%s,%s)", PHOENIX_DECIMAL, precision, scale));
                builder.dataType(PHOENIX_DECIMAL);
                builder.precision(Long.valueOf(precision));
                builder.scale(Integer.valueOf(scale));
                break;
            }
            case BYTES: {
                builder.columnType(PHOENIX_BINARY);
                builder.dataType(PHOENIX_BINARY);
                break;
            }
            case STRING: {
                if (column.getColumnLength() == null || column.getColumnLength() <= 0L) {
                    builder.columnType(String.format("%s", PHOENIX_VARCHAR));
                } else if (column.getColumnLength() <= Integer.MAX_VALUE) {
                    builder.columnType(String.format("%s(%s)", PHOENIX_VARCHAR, column.getColumnLength()));
                } else if (column.getColumnLength() > Integer.MAX_VALUE) {
                    builder.columnType(String.format("%s(%s)", PHOENIX_VARCHAR, Integer.MAX_VALUE));
                }
                builder.dataType(PHOENIX_VARCHAR);
                break;
            }
            case DATE: {
                builder.columnType(PHOENIX_DATE);
                builder.dataType(PHOENIX_DATE);
                break;
            }
            case TIME: {
                Integer timeScale = column.getScale();
                if (timeScale != null && timeScale > 6) {
                    timeScale = 6;
                    log.warn("The time column {} type time({}) is out of range, which exceeds the maximum scale of {}, it will be converted to time({})", new Object[]{column.getName(), column.getScale(), 999, timeScale});
                }
                if (timeScale != null && timeScale > 0) {
                    builder.columnType(String.format("%s(%s)", PHOENIX_TIME, timeScale));
                } else {
                    builder.columnType(PHOENIX_TIME);
                }
                builder.dataType(PHOENIX_TIME);
                builder.scale(timeScale);
                break;
            }
            case TIMESTAMP: {
                Integer timestampScale = column.getScale();
                if (timestampScale != null && timestampScale > 6) {
                    timestampScale = 6;
                    log.warn("The timestamp column {} type timestamp({}) is out of range, which exceeds the maximum scale of {}, it will be converted to timestamp({})", new Object[]{column.getName(), column.getScale(), 6, timestampScale});
                }
                if (timestampScale != null && timestampScale > 0) {
                    builder.columnType(String.format("%s(%s)", PHOENIX_TIMESTAMP, timestampScale));
                } else {
                    builder.columnType(PHOENIX_TIMESTAMP);
                }
                builder.dataType(PHOENIX_TIMESTAMP);
                builder.scale(timestampScale);
                break;
            }
            case ARRAY: {
                ArrayType arrayType = (ArrayType)column.getDataType();
                SeaTunnelDataType elementType = arrayType.getElementType();
                switch (elementType.getSqlType()) {
                    case BOOLEAN: {
                        builder.columnType("BOOLEAN ARRAY");
                        builder.dataType("BOOLEAN ARRAY");
                        break block0;
                    }
                    case TINYINT: {
                        builder.columnType("TINYINT ARRAY");
                        builder.dataType("TINYINT ARRAY");
                        break block0;
                    }
                    case SMALLINT: {
                        builder.columnType("SMALLINT ARRAY");
                        builder.dataType("SMALLINT ARRAY");
                        break block0;
                    }
                    case INT: {
                        builder.columnType("INTEGER ARRAY");
                        builder.dataType("INTEGER ARRAY");
                        break block0;
                    }
                    case BIGINT: {
                        builder.columnType("BIGINT ARRAY");
                        builder.dataType("BIGINT ARRAY");
                        break block0;
                    }
                    case FLOAT: {
                        builder.columnType("FLOAT ARRAY");
                        builder.dataType("FLOAT ARRAY");
                        break block0;
                    }
                    case DOUBLE: {
                        builder.columnType("DOUBLE ARRAY");
                        builder.dataType("DOUBLE ARRAY");
                        break block0;
                    }
                    case STRING: {
                        builder.columnType("VARCHAR ARRAY");
                        builder.dataType("VARCHAR ARRAY");
                        break block0;
                    }
                }
                throw CommonError.convertToConnectorTypeError((String)"Phoenix", (String)elementType.getSqlType().name(), (String)column.getName());
            }
            default: {
                throw CommonError.convertToConnectorTypeError((String)"Phoenix", (String)column.getDataType().getSqlType().name(), (String)column.getName());
            }
        }
        return builder.build();
    }
}

