/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.jdbc.config;

import java.io.Serializable;
import java.util.List;
import org.apache.seatunnel.api.configuration.ReadonlyConfig;
import org.apache.seatunnel.connectors.seatunnel.jdbc.config.JdbcConnectionConfig;
import org.apache.seatunnel.connectors.seatunnel.jdbc.config.JdbcSinkOptions;

public class JdbcSinkConfig
implements Serializable {
    private static final long serialVersionUID = 2L;
    private JdbcConnectionConfig jdbcConnectionConfig;
    private boolean isExactlyOnce;
    private String simpleSql;
    private String database;
    private String table;
    private List<String> primaryKeys;
    private boolean enableUpsert;
    private boolean isPrimaryKeyUpdated;
    private boolean supportUpsertByInsertOnly;
    private boolean useCopyStatement;
    private boolean createIndex;

    public static JdbcSinkConfig of(ReadonlyConfig config) {
        JdbcSinkConfigBuilder builder = JdbcSinkConfig.builder();
        builder.jdbcConnectionConfig(JdbcConnectionConfig.of(config));
        builder.isExactlyOnce((Boolean)config.get(JdbcSinkOptions.IS_EXACTLY_ONCE));
        config.getOptional(JdbcSinkOptions.PRIMARY_KEYS).ifPresent(builder::primaryKeys);
        config.getOptional(JdbcSinkOptions.DATABASE).ifPresent(builder::database);
        config.getOptional(JdbcSinkOptions.TABLE).ifPresent(builder::table);
        builder.enableUpsert((Boolean)config.get(JdbcSinkOptions.ENABLE_UPSERT));
        builder.isPrimaryKeyUpdated((Boolean)config.get(JdbcSinkOptions.IS_PRIMARY_KEY_UPDATED));
        builder.supportUpsertByInsertOnly((Boolean)config.get(JdbcSinkOptions.SUPPORT_UPSERT_BY_INSERT_ONLY));
        builder.simpleSql((String)config.get(JdbcSinkOptions.QUERY));
        builder.useCopyStatement((Boolean)config.get(JdbcSinkOptions.USE_COPY_STATEMENT));
        builder.createIndex((Boolean)config.get(JdbcSinkOptions.CREATE_INDEX));
        return builder.build();
    }

    private static boolean $default$isPrimaryKeyUpdated() {
        return true;
    }

    private static boolean $default$createIndex() {
        return true;
    }

    JdbcSinkConfig(JdbcConnectionConfig jdbcConnectionConfig, boolean isExactlyOnce, String simpleSql, String database, String table, List<String> primaryKeys, boolean enableUpsert, boolean isPrimaryKeyUpdated, boolean supportUpsertByInsertOnly, boolean useCopyStatement, boolean createIndex) {
        this.jdbcConnectionConfig = jdbcConnectionConfig;
        this.isExactlyOnce = isExactlyOnce;
        this.simpleSql = simpleSql;
        this.database = database;
        this.table = table;
        this.primaryKeys = primaryKeys;
        this.enableUpsert = enableUpsert;
        this.isPrimaryKeyUpdated = isPrimaryKeyUpdated;
        this.supportUpsertByInsertOnly = supportUpsertByInsertOnly;
        this.useCopyStatement = useCopyStatement;
        this.createIndex = createIndex;
    }

    public static JdbcSinkConfigBuilder builder() {
        return new JdbcSinkConfigBuilder();
    }

    public JdbcConnectionConfig getJdbcConnectionConfig() {
        return this.jdbcConnectionConfig;
    }

    public boolean isExactlyOnce() {
        return this.isExactlyOnce;
    }

    public String getSimpleSql() {
        return this.simpleSql;
    }

    public String getDatabase() {
        return this.database;
    }

    public String getTable() {
        return this.table;
    }

    public List<String> getPrimaryKeys() {
        return this.primaryKeys;
    }

    public boolean isEnableUpsert() {
        return this.enableUpsert;
    }

    public boolean isPrimaryKeyUpdated() {
        return this.isPrimaryKeyUpdated;
    }

    public boolean isSupportUpsertByInsertOnly() {
        return this.supportUpsertByInsertOnly;
    }

    public boolean isUseCopyStatement() {
        return this.useCopyStatement;
    }

    public boolean isCreateIndex() {
        return this.createIndex;
    }

    public void setJdbcConnectionConfig(JdbcConnectionConfig jdbcConnectionConfig) {
        this.jdbcConnectionConfig = jdbcConnectionConfig;
    }

    public void setExactlyOnce(boolean isExactlyOnce) {
        this.isExactlyOnce = isExactlyOnce;
    }

    public void setSimpleSql(String simpleSql) {
        this.simpleSql = simpleSql;
    }

    public void setDatabase(String database) {
        this.database = database;
    }

    public void setTable(String table) {
        this.table = table;
    }

    public void setPrimaryKeys(List<String> primaryKeys) {
        this.primaryKeys = primaryKeys;
    }

    public void setEnableUpsert(boolean enableUpsert) {
        this.enableUpsert = enableUpsert;
    }

    public void setPrimaryKeyUpdated(boolean isPrimaryKeyUpdated) {
        this.isPrimaryKeyUpdated = isPrimaryKeyUpdated;
    }

    public void setSupportUpsertByInsertOnly(boolean supportUpsertByInsertOnly) {
        this.supportUpsertByInsertOnly = supportUpsertByInsertOnly;
    }

    public void setUseCopyStatement(boolean useCopyStatement) {
        this.useCopyStatement = useCopyStatement;
    }

    public void setCreateIndex(boolean createIndex) {
        this.createIndex = createIndex;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof JdbcSinkConfig)) {
            return false;
        }
        JdbcSinkConfig other = (JdbcSinkConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isExactlyOnce() != other.isExactlyOnce()) {
            return false;
        }
        if (this.isEnableUpsert() != other.isEnableUpsert()) {
            return false;
        }
        if (this.isPrimaryKeyUpdated() != other.isPrimaryKeyUpdated()) {
            return false;
        }
        if (this.isSupportUpsertByInsertOnly() != other.isSupportUpsertByInsertOnly()) {
            return false;
        }
        if (this.isUseCopyStatement() != other.isUseCopyStatement()) {
            return false;
        }
        if (this.isCreateIndex() != other.isCreateIndex()) {
            return false;
        }
        JdbcConnectionConfig this$jdbcConnectionConfig = this.getJdbcConnectionConfig();
        JdbcConnectionConfig other$jdbcConnectionConfig = other.getJdbcConnectionConfig();
        if (this$jdbcConnectionConfig == null ? other$jdbcConnectionConfig != null : !this$jdbcConnectionConfig.equals(other$jdbcConnectionConfig)) {
            return false;
        }
        String this$simpleSql = this.getSimpleSql();
        String other$simpleSql = other.getSimpleSql();
        if (this$simpleSql == null ? other$simpleSql != null : !this$simpleSql.equals(other$simpleSql)) {
            return false;
        }
        String this$database = this.getDatabase();
        String other$database = other.getDatabase();
        if (this$database == null ? other$database != null : !this$database.equals(other$database)) {
            return false;
        }
        String this$table = this.getTable();
        String other$table = other.getTable();
        if (this$table == null ? other$table != null : !this$table.equals(other$table)) {
            return false;
        }
        List<String> this$primaryKeys = this.getPrimaryKeys();
        List<String> other$primaryKeys = other.getPrimaryKeys();
        return !(this$primaryKeys == null ? other$primaryKeys != null : !((Object)this$primaryKeys).equals(other$primaryKeys));
    }

    protected boolean canEqual(Object other) {
        return other instanceof JdbcSinkConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isExactlyOnce() ? 79 : 97);
        result = result * 59 + (this.isEnableUpsert() ? 79 : 97);
        result = result * 59 + (this.isPrimaryKeyUpdated() ? 79 : 97);
        result = result * 59 + (this.isSupportUpsertByInsertOnly() ? 79 : 97);
        result = result * 59 + (this.isUseCopyStatement() ? 79 : 97);
        result = result * 59 + (this.isCreateIndex() ? 79 : 97);
        JdbcConnectionConfig $jdbcConnectionConfig = this.getJdbcConnectionConfig();
        result = result * 59 + ($jdbcConnectionConfig == null ? 43 : $jdbcConnectionConfig.hashCode());
        String $simpleSql = this.getSimpleSql();
        result = result * 59 + ($simpleSql == null ? 43 : $simpleSql.hashCode());
        String $database = this.getDatabase();
        result = result * 59 + ($database == null ? 43 : $database.hashCode());
        String $table = this.getTable();
        result = result * 59 + ($table == null ? 43 : $table.hashCode());
        List<String> $primaryKeys = this.getPrimaryKeys();
        result = result * 59 + ($primaryKeys == null ? 43 : ((Object)$primaryKeys).hashCode());
        return result;
    }

    public String toString() {
        return "JdbcSinkConfig(jdbcConnectionConfig=" + this.getJdbcConnectionConfig() + ", isExactlyOnce=" + this.isExactlyOnce() + ", simpleSql=" + this.getSimpleSql() + ", database=" + this.getDatabase() + ", table=" + this.getTable() + ", primaryKeys=" + this.getPrimaryKeys() + ", enableUpsert=" + this.isEnableUpsert() + ", isPrimaryKeyUpdated=" + this.isPrimaryKeyUpdated() + ", supportUpsertByInsertOnly=" + this.isSupportUpsertByInsertOnly() + ", useCopyStatement=" + this.isUseCopyStatement() + ", createIndex=" + this.isCreateIndex() + ")";
    }

    public static class JdbcSinkConfigBuilder {
        private JdbcConnectionConfig jdbcConnectionConfig;
        private boolean isExactlyOnce;
        private String simpleSql;
        private String database;
        private String table;
        private List<String> primaryKeys;
        private boolean enableUpsert;
        private boolean isPrimaryKeyUpdated$set;
        private boolean isPrimaryKeyUpdated$value;
        private boolean supportUpsertByInsertOnly;
        private boolean useCopyStatement;
        private boolean createIndex$set;
        private boolean createIndex$value;

        JdbcSinkConfigBuilder() {
        }

        public JdbcSinkConfigBuilder jdbcConnectionConfig(JdbcConnectionConfig jdbcConnectionConfig) {
            this.jdbcConnectionConfig = jdbcConnectionConfig;
            return this;
        }

        public JdbcSinkConfigBuilder isExactlyOnce(boolean isExactlyOnce) {
            this.isExactlyOnce = isExactlyOnce;
            return this;
        }

        public JdbcSinkConfigBuilder simpleSql(String simpleSql) {
            this.simpleSql = simpleSql;
            return this;
        }

        public JdbcSinkConfigBuilder database(String database) {
            this.database = database;
            return this;
        }

        public JdbcSinkConfigBuilder table(String table) {
            this.table = table;
            return this;
        }

        public JdbcSinkConfigBuilder primaryKeys(List<String> primaryKeys) {
            this.primaryKeys = primaryKeys;
            return this;
        }

        public JdbcSinkConfigBuilder enableUpsert(boolean enableUpsert) {
            this.enableUpsert = enableUpsert;
            return this;
        }

        public JdbcSinkConfigBuilder isPrimaryKeyUpdated(boolean isPrimaryKeyUpdated) {
            this.isPrimaryKeyUpdated$value = isPrimaryKeyUpdated;
            this.isPrimaryKeyUpdated$set = true;
            return this;
        }

        public JdbcSinkConfigBuilder supportUpsertByInsertOnly(boolean supportUpsertByInsertOnly) {
            this.supportUpsertByInsertOnly = supportUpsertByInsertOnly;
            return this;
        }

        public JdbcSinkConfigBuilder useCopyStatement(boolean useCopyStatement) {
            this.useCopyStatement = useCopyStatement;
            return this;
        }

        public JdbcSinkConfigBuilder createIndex(boolean createIndex) {
            this.createIndex$value = createIndex;
            this.createIndex$set = true;
            return this;
        }

        public JdbcSinkConfig build() {
            boolean isPrimaryKeyUpdated$value = this.isPrimaryKeyUpdated$value;
            if (!this.isPrimaryKeyUpdated$set) {
                isPrimaryKeyUpdated$value = JdbcSinkConfig.$default$isPrimaryKeyUpdated();
            }
            boolean createIndex$value = this.createIndex$value;
            if (!this.createIndex$set) {
                createIndex$value = JdbcSinkConfig.$default$createIndex();
            }
            return new JdbcSinkConfig(this.jdbcConnectionConfig, this.isExactlyOnce, this.simpleSql, this.database, this.table, this.primaryKeys, this.enableUpsert, isPrimaryKeyUpdated$value, this.supportUpsertByInsertOnly, this.useCopyStatement, createIndex$value);
        }

        public String toString() {
            return "JdbcSinkConfig.JdbcSinkConfigBuilder(jdbcConnectionConfig=" + this.jdbcConnectionConfig + ", isExactlyOnce=" + this.isExactlyOnce + ", simpleSql=" + this.simpleSql + ", database=" + this.database + ", table=" + this.table + ", primaryKeys=" + this.primaryKeys + ", enableUpsert=" + this.enableUpsert + ", isPrimaryKeyUpdated$value=" + this.isPrimaryKeyUpdated$value + ", supportUpsertByInsertOnly=" + this.supportUpsertByInsertOnly + ", useCopyStatement=" + this.useCopyStatement + ", createIndex$value=" + this.createIndex$value + ")";
        }
    }
}

