/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.jdbc.catalog.sqlserver;

import com.google.auto.service.AutoService;
import org.apache.seatunnel.api.configuration.ReadonlyConfig;
import org.apache.seatunnel.api.configuration.util.OptionRule;
import org.apache.seatunnel.api.table.catalog.Catalog;
import org.apache.seatunnel.api.table.factory.CatalogFactory;
import org.apache.seatunnel.api.table.factory.Factory;
import org.apache.seatunnel.common.utils.JdbcUrlUtil;
import org.apache.seatunnel.connectors.seatunnel.jdbc.catalog.sqlserver.SqlServerCatalog;
import org.apache.seatunnel.connectors.seatunnel.jdbc.catalog.sqlserver.SqlServerURLParser;
import org.apache.seatunnel.connectors.seatunnel.jdbc.config.JdbcCommonOptions;

@AutoService(value={Factory.class})
public class SqlServerCatalogFactory
implements CatalogFactory {
    public String factoryIdentifier() {
        return "SqlServer";
    }

    public Catalog createCatalog(String catalogName, ReadonlyConfig options) {
        String url = (String)options.get(JdbcCommonOptions.URL);
        JdbcUrlUtil.UrlInfo urlInfo = SqlServerURLParser.parse(url);
        return new SqlServerCatalog(catalogName, (String)options.get(JdbcCommonOptions.USERNAME), (String)options.get(JdbcCommonOptions.PASSWORD), urlInfo, (String)options.get(JdbcCommonOptions.SCHEMA), (String)options.get(JdbcCommonOptions.DRIVER));
    }

    public OptionRule optionRule() {
        return JdbcCommonOptions.BASE_CATALOG_RULE.build();
    }
}

