/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.jdbc.catalog.oracle;

import com.google.auto.service.AutoService;
import java.util.Optional;
import org.apache.seatunnel.api.configuration.ReadonlyConfig;
import org.apache.seatunnel.api.configuration.util.OptionRule;
import org.apache.seatunnel.api.configuration.util.OptionValidationException;
import org.apache.seatunnel.api.table.catalog.Catalog;
import org.apache.seatunnel.api.table.factory.CatalogFactory;
import org.apache.seatunnel.api.table.factory.Factory;
import org.apache.seatunnel.common.utils.JdbcUrlUtil;
import org.apache.seatunnel.connectors.seatunnel.jdbc.catalog.oracle.OracleCatalog;
import org.apache.seatunnel.connectors.seatunnel.jdbc.catalog.oracle.OracleURLParser;
import org.apache.seatunnel.connectors.seatunnel.jdbc.config.JdbcCommonOptions;

@AutoService(value={Factory.class})
public class OracleCatalogFactory
implements CatalogFactory {
    public String factoryIdentifier() {
        return "Oracle";
    }

    public Catalog createCatalog(String catalogName, ReadonlyConfig options) {
        String urlWithDatabase = (String)options.get(JdbcCommonOptions.URL);
        JdbcUrlUtil.UrlInfo urlInfo = OracleURLParser.parse(urlWithDatabase);
        Optional defaultDatabase = urlInfo.getDefaultDatabase();
        if (!defaultDatabase.isPresent()) {
            throw new OptionValidationException(JdbcCommonOptions.URL);
        }
        return new OracleCatalog(catalogName, (String)options.get(JdbcCommonOptions.USERNAME), (String)options.get(JdbcCommonOptions.PASSWORD), urlInfo, (String)options.get(JdbcCommonOptions.SCHEMA), (Boolean)options.get(JdbcCommonOptions.DECIMAL_TYPE_NARROWING), (String)options.get(JdbcCommonOptions.DRIVER), options.getOptional(JdbcCommonOptions.HANDLE_BLOB_AS_STRING).orElse(false));
    }

    public OptionRule optionRule() {
        return JdbcCommonOptions.BASE_CATALOG_RULE.build();
    }
}

