/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.sqlserver;

import io.debezium.annotation.NotThreadSafe;
import io.debezium.config.CommonConnectorConfig;
import io.debezium.connector.common.BaseSourceInfo;
import io.debezium.connector.sqlserver.Lsn;
import io.debezium.connector.sqlserver.SqlServerConnectorConfig;
import io.debezium.relational.TableId;
import java.time.Instant;

@NotThreadSafe
public class SourceInfo
extends BaseSourceInfo {
    public static final String CHANGE_LSN_KEY = "change_lsn";
    public static final String COMMIT_LSN_KEY = "commit_lsn";
    public static final String EVENT_SERIAL_NO_KEY = "event_serial_no";
    private Lsn changeLsn;
    private Lsn commitLsn;
    private Long eventSerialNo;
    private Instant sourceTime;
    private TableId tableId;

    protected SourceInfo(SqlServerConnectorConfig connectorConfig) {
        super((CommonConnectorConfig)connectorConfig);
    }

    public void setChangeLsn(Lsn lsn) {
        this.changeLsn = lsn;
    }

    public Lsn getChangeLsn() {
        return this.changeLsn;
    }

    public Lsn getCommitLsn() {
        return this.commitLsn;
    }

    public Long getEventSerialNo() {
        return this.eventSerialNo;
    }

    public void setCommitLsn(Lsn commitLsn) {
        this.commitLsn = commitLsn;
    }

    public void setEventSerialNo(Long eventSerialNo) {
        this.eventSerialNo = eventSerialNo;
    }

    public void setSourceTime(Instant instant) {
        this.sourceTime = instant;
    }

    public TableId getTableId() {
        return this.tableId;
    }

    public void setTableId(TableId tableId) {
        this.tableId = tableId;
    }

    public String toString() {
        return "SourceInfo [serverName=" + this.serverName() + ", changeLsn=" + this.changeLsn + ", commitLsn=" + this.commitLsn + ", eventSerialNo=" + this.eventSerialNo + ", snapshot=" + this.snapshotRecord + ", sourceTime=" + this.sourceTime + "]";
    }

    protected Instant timestamp() {
        return this.sourceTime;
    }

    protected String database() {
        if (this.tableId == null) {
            return null;
        }
        return this.tableId.catalog();
    }
}

