/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.shade.org.postgresql.quickautobalance;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import javax.net.SocketFactory;
import org.apache.seatunnel.shade.org.postgresql.PGProperty;
import org.apache.seatunnel.shade.org.postgresql.core.PGStream;
import org.apache.seatunnel.shade.org.postgresql.core.QueryExecutor;
import org.apache.seatunnel.shade.org.postgresql.core.SocketFactoryFactory;
import org.apache.seatunnel.shade.org.postgresql.core.v3.ConnectionFactoryImpl;
import org.apache.seatunnel.shade.org.postgresql.jdbc.PgConnection;
import org.apache.seatunnel.shade.org.postgresql.jdbc.SslMode;
import org.apache.seatunnel.shade.org.postgresql.jdbc.StatementCancelState;
import org.apache.seatunnel.shade.org.postgresql.log.Log;
import org.apache.seatunnel.shade.org.postgresql.log.Logger;
import org.apache.seatunnel.shade.org.postgresql.quickautobalance.ConnectionInfo;
import org.apache.seatunnel.shade.org.postgresql.util.GT;
import org.apache.seatunnel.shade.org.postgresql.util.HostSpec;
import org.apache.seatunnel.shade.org.postgresql.util.PSQLException;
import org.apache.seatunnel.shade.org.postgresql.util.PSQLState;

public class DataNode {
    private static Log LOGGER = Logger.getLogger(DataNode.class.getName());
    private static final String USERNAME_OR_PASSWORD_INVALID_ERROR_CODE = "28P01";
    private final HostSpec hostSpec;
    private final Map<PgConnection, ConnectionInfo> cachedConnectionList;
    private final AtomicInteger cachedCreatingConnectionSize;
    private volatile boolean dataNodeState;

    public DataNode(HostSpec hostSpec) {
        this.hostSpec = hostSpec;
        this.cachedConnectionList = new ConcurrentHashMap<PgConnection, ConnectionInfo>();
        this.cachedCreatingConnectionSize = new AtomicInteger(0);
        this.dataNodeState = true;
    }

    public void setConnectionState(PgConnection pgConnection, StatementCancelState state) {
        ConnectionInfo connectionInfo = this.cachedConnectionList.get(pgConnection);
        if (connectionInfo != null) {
            connectionInfo.setConnectionState(state);
        }
    }

    public void setConnection(PgConnection pgConnection, Properties properties, HostSpec hostSpec) throws PSQLException {
        if (pgConnection == null || properties == null || hostSpec == null) {
            return;
        }
        if (!hostSpec.equals(this.hostSpec)) {
            return;
        }
        ConnectionInfo connectionInfo = new ConnectionInfo(pgConnection, properties, hostSpec);
        this.cachedConnectionList.put(pgConnection, connectionInfo);
    }

    public ConnectionInfo getConnectionInfo(PgConnection pgConnection) {
        if (pgConnection == null) {
            return null;
        }
        return this.cachedConnectionList.get(pgConnection);
    }

    public int getCachedConnectionListSize() {
        return this.cachedConnectionList.size();
    }

    public CheckDnStateResult checkDnStateAndProperties(Properties properties) {
        boolean isDataNodeValid;
        Properties singleNodeProperties = new Properties();
        PGProperty.USER.set(singleNodeProperties, PGProperty.USER.get(properties));
        PGProperty.PASSWORD.set(singleNodeProperties, PGProperty.PASSWORD.get(properties));
        PGProperty.PG_DBNAME.set(singleNodeProperties, PGProperty.PG_DBNAME.get(properties));
        PGProperty.PG_HOST.set(singleNodeProperties, this.hostSpec.getHost());
        PGProperty.PG_PORT.set(singleNodeProperties, this.hostSpec.getPort());
        try {
            isDataNodeValid = this.checkDnState(singleNodeProperties);
        }
        catch (PSQLException e) {
            String cause = e.getCause() != null ? e.getCause().getMessage() : "";
            LOGGER.info(GT.tr("Can not try connect to dn: {0}, {1}.", this.hostSpec.toString(), cause.toString()));
            return CheckDnStateResult.DN_INVALID;
        }
        catch (InvocationTargetException e) {
            PSQLException psqlException;
            String sqlState;
            Throwable invocationTargetExceptionCause = e.getCause();
            if (invocationTargetExceptionCause instanceof PSQLException && USERNAME_OR_PASSWORD_INVALID_ERROR_CODE.equals(sqlState = (psqlException = (PSQLException)invocationTargetExceptionCause).getSQLState())) {
                String cause = e.getCause() != null ? e.getCause().getMessage() : "";
                LOGGER.info(GT.tr("Cached properties is invalid: {0}.", cause.toString()));
                return CheckDnStateResult.PROPERTIES_INVALID;
            }
            String cause = e.getCause() != null ? e.getCause().getMessage() : "";
            LOGGER.info(GT.tr("Can not try connect to dn: {0}, {1}.", this.hostSpec.toString(), cause.toString()));
            return CheckDnStateResult.DN_INVALID;
        }
        if (isDataNodeValid) {
            return CheckDnStateResult.DN_VALID;
        }
        return CheckDnStateResult.DN_INVALID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ConnectionInfo> filterIdleConnections(long quickAutoBalanceStartTime) {
        Map<PgConnection, ConnectionInfo> map = this.cachedConnectionList;
        synchronized (map) {
            ArrayList<ConnectionInfo> idleConnectionList = new ArrayList<ConnectionInfo>();
            for (Map.Entry<PgConnection, ConnectionInfo> entry : this.cachedConnectionList.entrySet()) {
                ConnectionInfo connectionInfo = entry.getValue();
                if (connectionInfo == null || !connectionInfo.checkConnectionCanBeClosed(quickAutoBalanceStartTime)) continue;
                idleConnectionList.add(connectionInfo);
            }
            return idleConnectionList;
        }
    }

    public void setDataNodeState(boolean isDnValid) {
        this.dataNodeState = isDnValid;
    }

    public boolean getDataNodeState() {
        return this.dataNodeState;
    }

    public boolean checkDnState(Properties properties) throws PSQLException, InvocationTargetException {
        Object pgStream;
        try {
            HostSpec dnHostSpec = new HostSpec(properties.getProperty("PGHOST"), Integer.parseInt(properties.getProperty("PGPORT")));
            SocketFactory socketFactory = SocketFactoryFactory.getSocketFactory(properties);
            SslMode sslMode = SslMode.of(properties);
            Class<?> classForName = Class.forName("org.apache.seatunnel.shade.org.postgresql.core.v3.ConnectionFactoryImpl");
            Object object = classForName.newInstance();
            if (!(object instanceof ConnectionFactoryImpl)) {
                LOGGER.error(GT.tr("classForName.newInstance() doesn't instanceof ConnectionFactoryImpl.", new Object[0]));
                return false;
            }
            ConnectionFactoryImpl connectionFactory = (ConnectionFactoryImpl)object;
            Method method = connectionFactory.getClass().getDeclaredMethod("tryConnect", String.class, String.class, Properties.class, SocketFactory.class, HostSpec.class, SslMode.class);
            method.setAccessible(true);
            pgStream = method.invoke((Object)connectionFactory, new Object[]{properties.getProperty("user"), properties.getProperty("PGDBNAME"), properties, socketFactory, dnHostSpec, sslMode});
            if (pgStream instanceof PGStream) {
                ((PGStream)pgStream).close();
            }
        }
        catch (IOException | ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException e) {
            throw new PSQLException("The queryExecutor of connection can't execute tryConnect", PSQLState.WRONG_OBJECT_TYPE);
        }
        if (pgStream instanceof PGStream) {
            return true;
        }
        LOGGER.error(GT.tr("Stream doesn't instanceof PGStream.", new Object[0]));
        return false;
    }

    public int checkConnectionsValidity() {
        int num = 0;
        for (Map.Entry<PgConnection, ConnectionInfo> entry : this.cachedConnectionList.entrySet()) {
            PgConnection pgConnection = entry.getKey();
            ConnectionInfo connectionInfo = entry.getValue();
            if (connectionInfo.checkConnectionIsValid()) continue;
            this.cachedConnectionList.remove(pgConnection);
            ++num;
        }
        return num;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int clearCachedConnections() {
        Map<PgConnection, ConnectionInfo> map = this.cachedConnectionList;
        synchronized (map) {
            int num = this.cachedConnectionList.size();
            for (Map.Entry<PgConnection, ConnectionInfo> entry : this.cachedConnectionList.entrySet()) {
                PgConnection pgConnection = entry.getKey();
                if (pgConnection != null) {
                    QueryExecutor queryExecutor = pgConnection.getQueryExecutor();
                    if (queryExecutor == null || queryExecutor.isClosed()) continue;
                    queryExecutor.close();
                    queryExecutor.setAvailability(false);
                    continue;
                }
                LOGGER.error(GT.tr("Fail to close connection, pgConnection = null.", new Object[0]));
            }
            this.cachedConnectionList.clear();
            return num;
        }
    }

    public boolean closeConnection(PgConnection pgConnection) {
        if (pgConnection == null) {
            return false;
        }
        ConnectionInfo connectionInfo = this.cachedConnectionList.remove(pgConnection);
        if (connectionInfo != null) {
            try {
                pgConnection.close();
                return true;
            }
            catch (SQLException e) {
                LOGGER.info(GT.tr("Connection closed failed.", new Object[0]), e);
                return false;
            }
        }
        return false;
    }

    public int getCachedCreatingConnectionSize() {
        return this.cachedCreatingConnectionSize.get();
    }

    public int incrementCachedCreatingConnectionSize() {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(GT.tr("\u3010quickAutoBalance\u3011incrementCachedCreatingConnectionSize, hostSpec: {0}, before increment: {1}", this.hostSpec.toString(), this.cachedCreatingConnectionSize.get()));
        }
        return this.cachedCreatingConnectionSize.incrementAndGet();
    }

    public int decrementCachedCreatingConnectionSize() {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(GT.tr("\u3010quickAutoBalance\u3011decrementCachedCreatingConnectionSize, hostSpec: {0}, before decrement: {1}", this.hostSpec.toString(), this.cachedCreatingConnectionSize.get()));
        }
        if (this.cachedCreatingConnectionSize.get() == 0) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug(GT.tr("CachedCreatingConnectionSize should not be less than 0, reset to 0.", new Object[0]));
            }
            return 0;
        }
        return this.cachedCreatingConnectionSize.decrementAndGet();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        DataNode dataNode = (DataNode)obj;
        return this.dataNodeState == dataNode.dataNodeState && Objects.equals(this.hostSpec, dataNode.hostSpec) && Objects.equals(this.cachedConnectionList, dataNode.cachedConnectionList);
    }

    public int hashCode() {
        return Objects.hash(this.hostSpec);
    }

    public static enum CheckDnStateResult {
        DN_VALID,
        DN_INVALID,
        PROPERTIES_INVALID;

    }
}

