/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.shade.org.postgresql.jdbc;

import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.seatunnel.shade.org.postgresql.Driver;
import org.apache.seatunnel.shade.org.postgresql.core.ParameterList;
import org.apache.seatunnel.shade.org.postgresql.core.Query;
import org.apache.seatunnel.shade.org.postgresql.core.types.PGBlob;
import org.apache.seatunnel.shade.org.postgresql.core.types.PGClob;
import org.apache.seatunnel.shade.org.postgresql.jdbc.BatchResultHandler;
import org.apache.seatunnel.shade.org.postgresql.jdbc.CallableBatchResultHandler;
import org.apache.seatunnel.shade.org.postgresql.jdbc.PGStruct;
import org.apache.seatunnel.shade.org.postgresql.jdbc.PgCallstatementTypeCompatibility;
import org.apache.seatunnel.shade.org.postgresql.jdbc.PgConnection;
import org.apache.seatunnel.shade.org.postgresql.jdbc.PgPreparedStatement;
import org.apache.seatunnel.shade.org.postgresql.util.GT;
import org.apache.seatunnel.shade.org.postgresql.util.PSQLException;
import org.apache.seatunnel.shade.org.postgresql.util.PSQLState;

class PgCallableStatement
extends PgPreparedStatement
implements CallableStatement {
    private boolean isFunction;
    private int[] functionReturnType;
    private int[] testReturn;
    private boolean returnTypeSet;
    protected Object[] callResult;
    private int lastIndex = 0;
    private String compatibilityMode;
    private boolean isACompatibilityFunction;
    private boolean enableOutparamOveride;
    private boolean isContainCompositeType = false;
    private ConcurrentHashMap<String, List<Object[]>> compositeTypeMap = new ConcurrentHashMap();
    private int[] returnOids;
    private static HashMap<Integer, Integer> sqlTypeToOid = new HashMap();

    PgCallableStatement(PgConnection connection, String sql, int rsType, int rsConcurrency, int rsHoldability) throws SQLException {
        super(connection, connection.borrowCallableQuery(sql), rsType, rsConcurrency, rsHoldability);
        this.isFunction = this.preparedQuery.isFunction;
        this.isACompatibilityFunction = this.preparedQuery.isACompatibilityFunction;
        this.compatibilityMode = connection.getQueryExecutor().getCompatibilityMode();
        this.enableOutparamOveride = connection.getQueryExecutor().getEnableOutparamOveride();
        if (this.isFunction) {
            int inParamCount = this.preparedParameters.getInParameterCount() + 1;
            this.testReturn = new int[inParamCount];
            this.functionReturnType = new int[inParamCount];
            this.returnOids = new int[inParamCount];
        }
    }

    @Override
    public int executeUpdate() throws SQLException {
        if (this.isFunction) {
            this.executeWithFlags(0);
            return 0;
        }
        return super.executeUpdate();
    }

    @Override
    public Object getObject(int i, Map<String, Class<?>> map) throws SQLException {
        return this.getObjectImpl(i, map);
    }

    @Override
    public Object getObject(String s, Map<String, Class<?>> map) throws SQLException {
        return this.getObjectImpl(s, map);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean executeWithFlags(int flags) throws SQLException {
        int i;
        ResultSet rs;
        boolean hasResultSet = super.executeWithFlags(flags);
        if (!this.isFunction || !this.returnTypeSet) {
            return hasResultSet;
        }
        if (!hasResultSet) {
            throw new PSQLException(GT.tr("A CallableStatement was executed with nothing returned.", new Object[0]), PSQLState.NO_DATA);
        }
        PgCallableStatement pgCallableStatement = this;
        synchronized (pgCallableStatement) {
            this.checkClosed();
            rs = this.result.getResultSet();
        }
        if (!rs.next()) {
            throw new PSQLException(GT.tr("A CallableStatement was executed with nothing returned.", new Object[0]), PSQLState.NO_DATA);
        }
        int cols = rs.getMetaData().getColumnCount();
        int outParameterCount = this.preparedParameters.getOutParameterCount();
        this.lastIndex = 0;
        this.callResult = new Object[this.preparedParameters.getParameterCount() + 1];
        if (this.isContainCompositeType && outParameterCount == 1) {
            i = 0;
            int j = 0;
            while (i < cols) {
                while (j < this.functionReturnType.length && this.functionReturnType[j] == 0) {
                    ++j;
                }
                Object[] compositeTypeStruct = this.connection.getTypeInfo().getStructAttributesName(this.returnOids[j]);
                if (compositeTypeStruct == null) {
                    throw new PSQLException(GT.tr("Unknown composite type.", new Object[0]), PSQLState.UNKNOWN_STATE);
                }
                int compositeTypeLength = compositeTypeStruct.length;
                StringBuffer sb = new StringBuffer();
                sb.append("(");
                int k = 0;
                while (k < compositeTypeLength) {
                    String str = rs.getString(i + 1);
                    if (str != null) {
                        if (this.isContainSpecialChar(str)) {
                            if (str.contains(Character.toString('\"'))) {
                                str = str.replaceAll("\"", "\"\"");
                            }
                            if (str.contains(Character.toString('\\'))) {
                                str = str.replaceAll("\\\\", "\\\\\\\\");
                            }
                            sb.append("\"" + str + "\",");
                        } else {
                            sb.append(str + ",");
                        }
                    } else {
                        sb.append(",");
                    }
                    ++k;
                    ++i;
                }
                sb.deleteCharAt(sb.length() - 1);
                sb.append(")");
                PGStruct pgStruct = new PGStruct(this.connection, 0, sb.toString());
                pgStruct.setAttrsSqlTypeList(this.connection.getTypeInfo().getStructAttributesOid(this.returnOids[j]));
                pgStruct.setStruct(compositeTypeStruct);
                this.callResult[j] = pgStruct;
                ++i;
                ++j;
            }
        } else {
            if (cols != outParameterCount) {
                throw new PSQLException(GT.tr("A CallableStatement was executed with an invalid number of parameters", new Object[0]), PSQLState.SYNTAX_ERROR);
            }
            i = 0;
            int j = 0;
            while (i < cols) {
                while (j < this.functionReturnType.length && this.functionReturnType[j] == 0) {
                    ++j;
                }
                int columnType = rs.getMetaData().getColumnType(i + 1);
                this.callResult[j] = columnType == 2 ? rs.getBigDecimal(i + 1) : rs.getObject(i + 1);
                if (columnType != this.functionReturnType[j]) {
                    PgCallstatementTypeCompatibility typeCompatibility = new PgCallstatementTypeCompatibility(columnType, this.functionReturnType[j]);
                    if (typeCompatibility.isCompatibilityType()) {
                        if (this.callResult[j] != null && typeCompatibility.needConvert()) {
                            this.callResult[j] = typeCompatibility.convert(this.callResult[j]);
                        }
                    } else {
                        throw new PSQLException(GT.tr("A CallableStatement function was executed and the out parameter {0} was of type {1} however type {2} was registered.", i + 1, "java.sql.Types=" + columnType, "java.sql.Types=" + this.functionReturnType[j]), PSQLState.DATA_TYPE_MISMATCH);
                    }
                }
                ++i;
                ++j;
            }
        }
        rs.close();
        PgCallableStatement pgCallableStatement2 = this;
        synchronized (pgCallableStatement2) {
            this.result = null;
        }
        return false;
    }

    private boolean isContainSpecialChar(String str) {
        return str.contains(Character.toString('\"')) || str.contains(Character.toString('\\')) || str.contains(Character.toString('(')) || str.contains(Character.toString(')')) || str.contains(Character.toString(',')) || str.contains(Character.toString(' '));
    }

    @Override
    public void registerOutParameter(int parameterIndex, int sqlType) throws SQLException {
        this.checkClosed();
        switch (sqlType) {
            case -6: {
                sqlType = -6;
                break;
            }
            case -1: {
                sqlType = 12;
                break;
            }
            case 3: {
                sqlType = 2;
                break;
            }
            case 6: {
                sqlType = 8;
                break;
            }
            case -4: 
            case -3: {
                sqlType = -2;
                break;
            }
            case 16: {
                sqlType = -7;
                break;
            }
            case -15: {
                sqlType = 1;
                break;
            }
        }
        if (!this.isFunction) {
            throw new PSQLException(GT.tr("This statement does not declare an OUT parameter.  Use '{' ?= call ... '}' to declare one.", new Object[0]), PSQLState.STATEMENT_NOT_ALLOWED_IN_FUNCTION_CALL);
        }
        this.checkIndex(parameterIndex, false);
        this.preparedParameters.registerOutParameter(parameterIndex, sqlType);
        if (this.isACompatibilityAndOverLoad()) {
            Integer oid = sqlTypeToOid.get(sqlType) == null ? Integer.valueOf(0) : sqlTypeToOid.get(sqlType);
            this.preparedParameters.bindRegisterOutParameter(parameterIndex, oid, this.isACompatibilityFunction);
        }
        this.functionReturnType[parameterIndex - 1] = sqlType;
        this.testReturn[parameterIndex - 1] = sqlType;
        if (this.functionReturnType[parameterIndex - 1] == 1 || this.functionReturnType[parameterIndex - 1] == -1) {
            this.testReturn[parameterIndex - 1] = 12;
        } else if (this.functionReturnType[parameterIndex - 1] == 6) {
            this.testReturn[parameterIndex - 1] = 7;
        }
        this.returnTypeSet = true;
    }

    @Override
    public boolean wasNull() throws SQLException {
        if (this.lastIndex == 0) {
            throw new PSQLException(GT.tr("wasNull cannot be call before fetching a result.", new Object[0]), PSQLState.OBJECT_NOT_IN_STATE);
        }
        return this.callResult[this.lastIndex - 1] == null;
    }

    @Override
    public String getString(int parameterIndex) throws SQLException {
        this.checkClosed();
        this.checkIndex(parameterIndex, 12, "String");
        try {
            return (String)this.callResult[parameterIndex - 1];
        }
        catch (Exception e) {
            return this.callResult[parameterIndex - 1].toString();
        }
    }

    public ResultSet getCursor(int parameterIndex) throws SQLException {
        this.checkClosed();
        this.checkIndex(parameterIndex, 1111, "cursor");
        return (ResultSet)this.callResult[parameterIndex - 1];
    }

    @Override
    public boolean getBoolean(int parameterIndex) throws SQLException {
        this.checkClosed();
        this.checkIndex(parameterIndex, -7, "Boolean");
        if (this.callResult[parameterIndex - 1] == null) {
            return false;
        }
        return (Boolean)this.callResult[parameterIndex - 1];
    }

    @Override
    public byte getByte(int parameterIndex) throws SQLException {
        this.checkClosed();
        this.checkIndex(parameterIndex, -6, "Byte");
        if (this.callResult[parameterIndex - 1] == null) {
            return 0;
        }
        return ((Integer)this.callResult[parameterIndex - 1]).byteValue();
    }

    @Override
    public short getShort(int parameterIndex) throws SQLException {
        this.checkClosed();
        this.checkIndex(parameterIndex, 5, "Short");
        if (this.callResult[parameterIndex - 1] == null) {
            return 0;
        }
        return ((Integer)this.callResult[parameterIndex - 1]).shortValue();
    }

    @Override
    public int getInt(int parameterIndex) throws SQLException {
        this.checkClosed();
        this.checkIndex(parameterIndex, 4, "Int");
        if (this.callResult[parameterIndex - 1] == null) {
            return 0;
        }
        return (Integer)this.callResult[parameterIndex - 1];
    }

    @Override
    public long getLong(int parameterIndex) throws SQLException {
        this.checkClosed();
        this.checkIndex(parameterIndex, -5, "Long");
        if (this.callResult[parameterIndex - 1] == null) {
            return 0L;
        }
        return (Long)this.callResult[parameterIndex - 1];
    }

    @Override
    public float getFloat(int parameterIndex) throws SQLException {
        this.checkClosed();
        this.checkIndex(parameterIndex, 7, "Float");
        if (this.callResult[parameterIndex - 1] == null) {
            return 0.0f;
        }
        return ((Float)this.callResult[parameterIndex - 1]).floatValue();
    }

    @Override
    public double getDouble(int parameterIndex) throws SQLException {
        this.checkClosed();
        this.checkIndex(parameterIndex, 8, "Double");
        if (this.callResult[parameterIndex - 1] == null) {
            return 0.0;
        }
        return (Double)this.callResult[parameterIndex - 1];
    }

    @Override
    public BigDecimal getBigDecimal(int parameterIndex, int scale) throws SQLException {
        this.checkClosed();
        this.checkIndex(parameterIndex, 2, "BigDecimal");
        return (BigDecimal)this.callResult[parameterIndex - 1];
    }

    @Override
    public byte[] getBytes(int parameterIndex) throws SQLException {
        this.checkClosed();
        this.checkIndex(parameterIndex, -3, -2, "Bytes");
        return (byte[])this.callResult[parameterIndex - 1];
    }

    @Override
    public Date getDate(int parameterIndex) throws SQLException {
        this.checkClosed();
        this.checkIndex(parameterIndex, 91, "Date");
        return (Date)this.callResult[parameterIndex - 1];
    }

    @Override
    public Time getTime(int parameterIndex) throws SQLException {
        this.checkClosed();
        this.checkIndex(parameterIndex, 92, "Time");
        return (Time)this.callResult[parameterIndex - 1];
    }

    @Override
    public Timestamp getTimestamp(int parameterIndex) throws SQLException {
        this.checkClosed();
        this.checkIndex(parameterIndex, 93, "Timestamp");
        return (Timestamp)this.callResult[parameterIndex - 1];
    }

    @Override
    public Object getObject(int parameterIndex) throws SQLException {
        this.checkClosed();
        this.checkIndex(parameterIndex);
        return this.callResult[parameterIndex - 1];
    }

    protected void checkIndex(int parameterIndex, int type1, int type2, String getName) throws SQLException {
        this.checkIndex(parameterIndex);
        if (type1 != this.testReturn[parameterIndex - 1] && type2 != this.testReturn[parameterIndex - 1]) {
            throw new PSQLException(GT.tr("Parameter of type {0} was registered, but call to get{1} (sqltype={2}) was made.", "java.sql.Types=" + this.testReturn[parameterIndex - 1], getName, "java.sql.Types=" + type1), PSQLState.MOST_SPECIFIC_TYPE_DOES_NOT_MATCH);
        }
    }

    protected void checkIndex(int parameterIndex, int type, String getName) throws SQLException {
        this.checkIndex(parameterIndex);
        if (type != this.testReturn[parameterIndex - 1]) {
            if (type == 12 && this.testReturn[parameterIndex - 1] == 2005) {
                return;
            }
            if (type == 1111 && this.testReturn[parameterIndex - 1] == -10) {
                return;
            }
            if (type == 12 && this.testReturn[parameterIndex - 1] == 4) {
                return;
            }
            if (type == 12 && this.testReturn[parameterIndex - 1] == 2) {
                return;
            }
            if (type == 4 && this.testReturn[parameterIndex - 1] == 2) {
                return;
            }
            if (type == 2 && this.testReturn[parameterIndex - 1] == 4) {
                return;
            }
            throw new PSQLException(GT.tr("Parameter of type {0} was registered, but call to get{1} (sqltype={2}) was made.", "java.sql.Types=" + this.testReturn[parameterIndex - 1], getName, "java.sql.Types=" + type), PSQLState.MOST_SPECIFIC_TYPE_DOES_NOT_MATCH);
        }
    }

    private void checkIndex(int parameterIndex) throws SQLException {
        this.checkIndex(parameterIndex, true);
    }

    private void checkIndex(int parameterIndex, boolean fetchingData) throws SQLException {
        if (!this.isFunction) {
            throw new PSQLException(GT.tr("A CallableStatement was declared, but no call to registerOutParameter(1, <some type>) was made.", new Object[0]), PSQLState.STATEMENT_NOT_ALLOWED_IN_FUNCTION_CALL);
        }
        if (fetchingData) {
            if (!this.returnTypeSet) {
                throw new PSQLException(GT.tr("No function outputs were registered.", new Object[0]), PSQLState.OBJECT_NOT_IN_STATE);
            }
            if (this.callResult == null) {
                throw new PSQLException(GT.tr("Results cannot be retrieved from a CallableStatement before it is executed.", new Object[0]), PSQLState.NO_DATA);
            }
            this.lastIndex = parameterIndex;
        }
    }

    @Override
    protected BatchResultHandler createBatchHandler(Query[] queries, ParameterList[] parameterLists) {
        return new CallableBatchResultHandler(this, queries, parameterLists);
    }

    @Override
    public Array getArray(int i) throws SQLException {
        this.checkClosed();
        this.checkIndex(i, 2003, "Array");
        return (Array)this.callResult[i - 1];
    }

    @Override
    public BigDecimal getBigDecimal(int parameterIndex) throws SQLException {
        this.checkClosed();
        this.checkIndex(parameterIndex, 2, "BigDecimal");
        try {
            return (BigDecimal)this.callResult[parameterIndex - 1];
        }
        catch (Exception e) {
            return new BigDecimal(this.callResult[parameterIndex - 1].toString());
        }
    }

    @Override
    public Blob getBlob(int i) throws SQLException {
        byte[] byt = (byte[])this.callResult[i - 1];
        PGBlob blob = new PGBlob();
        blob.setBytes(1L, byt);
        return blob;
    }

    @Override
    public Clob getClob(int i) throws SQLException {
        PGClob clob = null;
        if (this.callResult[i - 1] instanceof PGClob) {
            PGClob pgClob = (PGClob)this.callResult[i - 1];
            String str = pgClob.getSubString(1L, (int)pgClob.length());
            clob = new PGClob();
            clob.setString(1L, str);
        } else {
            clob = new PGClob();
            clob.setString(1L, this.getString(i));
        }
        return clob;
    }

    public Object getObjectImpl(int i, Map<String, Class<?>> map) throws SQLException {
        if (map == null || map.isEmpty()) {
            return this.getObject(i);
        }
        throw Driver.notImplemented(this.getClass(), "getObjectImpl(int,Map)");
    }

    @Override
    public Ref getRef(int i) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "getRef(int)");
    }

    @Override
    public Date getDate(int i, Calendar cal) throws SQLException {
        this.checkClosed();
        this.checkIndex(i, 91, "Date");
        if (this.callResult[i - 1] == null) {
            return null;
        }
        String value = this.callResult[i - 1].toString();
        return this.connection.getTimestampUtils().toDate(cal, value);
    }

    @Override
    public Time getTime(int i, Calendar cal) throws SQLException {
        this.checkClosed();
        this.checkIndex(i, 92, "Time");
        if (this.callResult[i - 1] == null) {
            return null;
        }
        String value = this.callResult[i - 1].toString();
        return this.connection.getTimestampUtils().toTime(cal, value);
    }

    @Override
    public Timestamp getTimestamp(int i, Calendar cal) throws SQLException {
        this.checkClosed();
        this.checkIndex(i, 93, "Timestamp");
        if (this.callResult[i - 1] == null) {
            return null;
        }
        String value = this.callResult[i - 1].toString();
        return this.connection.getTimestampUtils().toTimestamp(cal, value);
    }

    @Override
    public void registerOutParameter(int parameterIndex, int sqlType, String typeName) throws SQLException {
        if (sqlType == 2002) {
            this.checkClosed();
            if (!this.isFunction) {
                throw new PSQLException(GT.tr("This statement does not declare an OUT parameter.  Use '{' ?= call ... '}' to declare one.", new Object[0]), PSQLState.STATEMENT_NOT_ALLOWED_IN_FUNCTION_CALL);
            }
            int oid = this.connection.getTypeInfo().getPGType(typeName);
            if (oid == 0) {
                throw new PSQLException(GT.tr("Unable to find server array type for provided name {0}.", typeName), PSQLState.INVALID_NAME);
            }
            this.checkIndex(parameterIndex, false);
            this.preparedParameters.registerOutParameter(parameterIndex, 2002);
            if (this.isACompatibilityAndOverLoad()) {
                this.preparedParameters.bindRegisterOutParameter(parameterIndex, oid, this.isACompatibilityFunction);
            }
            this.returnOids[parameterIndex - 1] = oid;
            this.functionReturnType[parameterIndex - 1] = 2002;
            this.testReturn[parameterIndex - 1] = 2002;
            this.returnTypeSet = true;
            this.isContainCompositeType = true;
        } else if (sqlType == 2003) {
            int oid = this.connection.getTypeInfo().getPGArrayType(typeName);
            if (oid == 0) {
                throw new PSQLException(GT.tr("Unable to find server array type for provided name {0}.", typeName), PSQLState.INVALID_NAME);
            }
            this.preparedParameters.registerOutParameter(parameterIndex, 2003);
            if (this.isACompatibilityAndOverLoad()) {
                this.preparedParameters.bindRegisterOutParameter(parameterIndex, oid, this.isACompatibilityFunction);
            }
            this.returnOids[parameterIndex - 1] = oid;
            this.functionReturnType[parameterIndex - 1] = 2003;
            this.testReturn[parameterIndex - 1] = 2003;
            this.returnTypeSet = true;
        } else {
            throw Driver.notImplemented(this.getClass(), "registerOutParameter(int,int,String)");
        }
    }

    private boolean isACompatibilityAndOverLoad() {
        return this.enableOutparamOveride && ("A".equalsIgnoreCase(this.compatibilityMode) || "ORA".equalsIgnoreCase(this.compatibilityMode));
    }

    @Override
    public RowId getRowId(int parameterIndex) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "getRowId(int)");
    }

    @Override
    public RowId getRowId(String parameterName) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "getRowId(String)");
    }

    @Override
    public void setRowId(String parameterName, RowId x) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "setRowId(String, RowId)");
    }

    @Override
    public void setNString(String parameterName, String value) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "setNString(String, String)");
    }

    @Override
    public void setNCharacterStream(String parameterName, Reader value, long length) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "setNCharacterStream(String, Reader, long)");
    }

    @Override
    public void setNCharacterStream(String parameterName, Reader value) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "setNCharacterStream(String, Reader)");
    }

    @Override
    public void setCharacterStream(String parameterName, Reader value, long length) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "setCharacterStream(String, Reader, long)");
    }

    @Override
    public void setCharacterStream(String parameterName, Reader value) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "setCharacterStream(String, Reader)");
    }

    @Override
    public void setBinaryStream(String parameterName, InputStream value, long length) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "setBinaryStream(String, InputStream, long)");
    }

    @Override
    public void setBinaryStream(String parameterName, InputStream value) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "setBinaryStream(String, InputStream)");
    }

    @Override
    public void setAsciiStream(String parameterName, InputStream value, long length) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "setAsciiStream(String, InputStream, long)");
    }

    @Override
    public void setAsciiStream(String parameterName, InputStream value) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "setAsciiStream(String, InputStream)");
    }

    @Override
    public void setNClob(String parameterName, NClob value) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "setNClob(String, NClob)");
    }

    @Override
    public void setClob(String parameterName, Reader reader, long length) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "setClob(String, Reader, long)");
    }

    @Override
    public void setClob(String parameterName, Reader reader) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "setClob(String, Reader)");
    }

    @Override
    public void setBlob(String parameterName, InputStream inputStream, long length) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "setBlob(String, InputStream, long)");
    }

    @Override
    public void setBlob(String parameterName, InputStream inputStream) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "setBlob(String, InputStream)");
    }

    @Override
    public void setBlob(String parameterName, Blob x) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "setBlob(String, Blob)");
    }

    @Override
    public void setClob(String parameterName, Clob x) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "setClob(String, Clob)");
    }

    @Override
    public void setNClob(String parameterName, Reader reader, long length) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "setNClob(String, Reader, long)");
    }

    @Override
    public void setNClob(String parameterName, Reader reader) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "setNClob(String, Reader)");
    }

    @Override
    public NClob getNClob(int parameterIndex) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "getNClob(int)");
    }

    @Override
    public NClob getNClob(String parameterName) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "getNClob(String)");
    }

    @Override
    public void setSQLXML(String parameterName, SQLXML xmlObject) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "setSQLXML(String, SQLXML)");
    }

    @Override
    public SQLXML getSQLXML(int parameterIndex) throws SQLException {
        this.checkClosed();
        this.checkIndex(parameterIndex, 2009, "SQLXML");
        return (SQLXML)this.callResult[parameterIndex - 1];
    }

    @Override
    public SQLXML getSQLXML(String parameterIndex) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "getSQLXML(String)");
    }

    @Override
    public String getNString(int parameterIndex) throws SQLException {
        return this.getString(parameterIndex);
    }

    @Override
    public String getNString(String parameterName) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "getNString(String)");
    }

    @Override
    public Reader getNCharacterStream(int parameterIndex) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "getNCharacterStream(int)");
    }

    @Override
    public Reader getNCharacterStream(String parameterName) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "getNCharacterStream(String)");
    }

    @Override
    public Reader getCharacterStream(int parameterIndex) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "getCharacterStream(int)");
    }

    @Override
    public Reader getCharacterStream(String parameterName) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "getCharacterStream(String)");
    }

    @Override
    public <T> T getObject(int parameterIndex, Class<T> type) throws SQLException {
        if (type == ResultSet.class) {
            return type.cast(this.getObject(parameterIndex));
        }
        throw new PSQLException(GT.tr("Unsupported type conversion to {1}.", type), PSQLState.INVALID_PARAMETER_VALUE);
    }

    @Override
    public <T> T getObject(String parameterName, Class<T> type) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "getObject(String, Class<T>)");
    }

    @Override
    public void registerOutParameter(String parameterName, int sqlType) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "registerOutParameter(String,int)");
    }

    @Override
    public void registerOutParameter(String parameterName, int sqlType, int scale) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "registerOutParameter(String,int,int)");
    }

    @Override
    public void registerOutParameter(String parameterName, int sqlType, String typeName) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "registerOutParameter(String,int,String)");
    }

    @Override
    public URL getURL(int parameterIndex) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "getURL(String)");
    }

    @Override
    public void setURL(String parameterName, URL val) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "setURL(String,URL)");
    }

    @Override
    public void setNull(String parameterName, int sqlType) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "setNull(String,int)");
    }

    @Override
    public void setBoolean(String parameterName, boolean x) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "setBoolean(String,boolean)");
    }

    @Override
    public void setByte(String parameterName, byte x) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "setByte(String,byte)");
    }

    @Override
    public void setShort(String parameterName, short x) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "setShort(String,short)");
    }

    @Override
    public void setInt(String parameterName, int x) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "setInt(String,int)");
    }

    @Override
    public void setLong(String parameterName, long x) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "setLong(String,long)");
    }

    @Override
    public void setFloat(String parameterName, float x) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "setFloat(String,float)");
    }

    @Override
    public void setDouble(String parameterName, double x) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "setDouble(String,double)");
    }

    @Override
    public void setBigDecimal(String parameterName, BigDecimal x) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "setBigDecimal(String,BigDecimal)");
    }

    @Override
    public void setString(String parameterName, String x) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "setString(String,String)");
    }

    @Override
    public void setBytes(String parameterName, byte[] x) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "setBytes(String,byte)");
    }

    @Override
    public void setDate(String parameterName, Date x) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "setDate(String,Date)");
    }

    @Override
    public void setTime(String parameterName, Time x) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "setTime(String,Time)");
    }

    @Override
    public void setTimestamp(String parameterName, Timestamp x) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "setTimestamp(String,Timestamp)");
    }

    @Override
    public void setAsciiStream(String parameterName, InputStream x, int length) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "setAsciiStream(String,InputStream,int)");
    }

    @Override
    public void setBinaryStream(String parameterName, InputStream x, int length) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "setBinaryStream(String,InputStream,int)");
    }

    @Override
    public void setObject(String parameterName, Object x, int targetSqlType, int scale) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "setObject(String,Object,int,int)");
    }

    @Override
    public void setObject(String parameterName, Object x, int targetSqlType) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "setObject(String,Object,int)");
    }

    @Override
    public void setObject(String parameterName, Object x) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "setObject(String,Object)");
    }

    @Override
    public void setCharacterStream(String parameterName, Reader reader, int length) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "setCharacterStream(String,Reader,int)");
    }

    @Override
    public void setDate(String parameterName, Date x, Calendar cal) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "setDate(String,Date,Calendar)");
    }

    @Override
    public void setTime(String parameterName, Time x, Calendar cal) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "setTime(String,Time,Calendar)");
    }

    @Override
    public void setTimestamp(String parameterName, Timestamp x, Calendar cal) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "setTimestamp(String,Timestamp,Calendar)");
    }

    @Override
    public void setNull(String parameterName, int sqlType, String typeName) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "setNull(String,int,String)");
    }

    @Override
    public String getString(String parameterName) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "getString(String)");
    }

    @Override
    public boolean getBoolean(String parameterName) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "getBoolean(String)");
    }

    @Override
    public byte getByte(String parameterName) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "getByte(String)");
    }

    @Override
    public short getShort(String parameterName) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "getShort(String)");
    }

    @Override
    public int getInt(String parameterName) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "getInt(String)");
    }

    @Override
    public long getLong(String parameterName) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "getLong(String)");
    }

    @Override
    public float getFloat(String parameterName) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "getFloat(String)");
    }

    @Override
    public double getDouble(String parameterName) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "getDouble(String)");
    }

    @Override
    public byte[] getBytes(String parameterName) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "getBytes(String)");
    }

    @Override
    public Date getDate(String parameterName) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "getDate(String)");
    }

    @Override
    public Time getTime(String parameterName) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "getTime(String)");
    }

    @Override
    public Timestamp getTimestamp(String parameterName) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "getTimestamp(String)");
    }

    @Override
    public Object getObject(String parameterName) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "getObject(String)");
    }

    @Override
    public BigDecimal getBigDecimal(String parameterName) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "getBigDecimal(String)");
    }

    public Object getObjectImpl(String parameterName, Map<String, Class<?>> map) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "getObject(String,Map)");
    }

    @Override
    public Ref getRef(String parameterName) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "getRef(String)");
    }

    @Override
    public Blob getBlob(String parameterName) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "getBlob(String)");
    }

    @Override
    public Clob getClob(String parameterName) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "getClob(String)");
    }

    @Override
    public Array getArray(String parameterName) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "getArray(String)");
    }

    @Override
    public Date getDate(String parameterName, Calendar cal) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "getDate(String,Calendar)");
    }

    @Override
    public Time getTime(String parameterName, Calendar cal) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "getTime(String,Calendar)");
    }

    @Override
    public Timestamp getTimestamp(String parameterName, Calendar cal) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "getTimestamp(String,Calendar)");
    }

    @Override
    public URL getURL(String parameterName) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "getURL(String)");
    }

    @Override
    public void registerOutParameter(int parameterIndex, int sqlType, int scale) throws SQLException {
        this.registerOutParameter(parameterIndex, sqlType);
    }

    static {
        sqlTypeToOid.put(2009, 142);
        sqlTypeToOid.put(4, 23);
        sqlTypeToOid.put(-6, 5545);
        sqlTypeToOid.put(5, 21);
        sqlTypeToOid.put(-5, 20);
        sqlTypeToOid.put(7, 700);
        sqlTypeToOid.put(12, 1043);
        sqlTypeToOid.put(8, 701);
        sqlTypeToOid.put(6, 701);
        sqlTypeToOid.put(3, 1700);
        sqlTypeToOid.put(2, 1700);
        sqlTypeToOid.put(1, 1042);
        sqlTypeToOid.put(91, 1082);
        sqlTypeToOid.put(92, 1083);
        sqlTypeToOid.put(93, 1114);
        sqlTypeToOid.put(2013, 0);
        sqlTypeToOid.put(2014, 0);
        sqlTypeToOid.put(16, 16);
        sqlTypeToOid.put(-7, 16);
        sqlTypeToOid.put(-2, 17);
        sqlTypeToOid.put(-3, 17);
        sqlTypeToOid.put(-4, 17);
        sqlTypeToOid.put(2004, 88);
        sqlTypeToOid.put(2005, 90);
        sqlTypeToOid.put(2003, 1015);
        sqlTypeToOid.put(2001, 0);
        sqlTypeToOid.put(2002, 0);
        sqlTypeToOid.put(0, 0);
        sqlTypeToOid.put(1111, 0);
        sqlTypeToOid.put(-1, 1043);
        sqlTypeToOid.put(-9, 1043);
        sqlTypeToOid.put(-16, 1043);
        sqlTypeToOid.put(-15, 18);
        sqlTypeToOid.put(2012, 1790);
    }
}

