/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.shade.org.postgresql.hostchooser;

import org.apache.seatunnel.shade.org.postgresql.hostchooser.HostStatus;

public enum HostRequirement {
    any{

        @Override
        public boolean allowConnectingTo(HostStatus status) {
            return status != HostStatus.ConnectFail;
        }
    }
    ,
    master{

        @Override
        public boolean allowConnectingTo(HostStatus status) {
            return status == HostStatus.Master || status == HostStatus.ConnectOK;
        }
    }
    ,
    secondary{

        @Override
        public boolean allowConnectingTo(HostStatus status) {
            return status == HostStatus.Secondary || status == HostStatus.ConnectOK;
        }
    }
    ,
    preferSecondary{

        @Override
        public boolean allowConnectingTo(HostStatus status) {
            return status != HostStatus.ConnectFail;
        }
    };


    public abstract boolean allowConnectingTo(HostStatus var1);

    public static HostRequirement getTargetServerType(String targetServerType) {
        String allowSlave = targetServerType.replace("lave", "econdary");
        return HostRequirement.valueOf(allowSlave);
    }
}

