/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.shade.org.postgresql.core;

import java.sql.SQLException;
import java.sql.SQLWarning;
import java.util.List;
import org.apache.seatunnel.shade.org.postgresql.core.Field;
import org.apache.seatunnel.shade.org.postgresql.core.Query;
import org.apache.seatunnel.shade.org.postgresql.core.QueryExecutor;
import org.apache.seatunnel.shade.org.postgresql.core.ResultCursor;
import org.apache.seatunnel.shade.org.postgresql.core.ResultHandlerBase;
import org.apache.seatunnel.shade.org.postgresql.util.GT;
import org.apache.seatunnel.shade.org.postgresql.util.PSQLException;
import org.apache.seatunnel.shade.org.postgresql.util.PSQLState;

public class SetupQueryRunner {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[][] run(QueryExecutor executor, String queryString, boolean wantResults) throws SQLException {
        Query query = executor.createSimpleQuery(queryString);
        SimpleResultHandler handler = new SimpleResultHandler();
        int flags = 1041;
        if (!wantResults) {
            flags |= 6;
        }
        try {
            executor.execute(query, null, handler, 0, 0, flags);
        }
        finally {
            query.close();
        }
        if (!wantResults) {
            return null;
        }
        List<byte[][]> tuples = handler.getResults();
        if (tuples == null || tuples.size() != 1) {
            throw new PSQLException(GT.tr("An unexpected result was returned by a query.", new Object[0]), PSQLState.CONNECTION_UNABLE_TO_CONNECT);
        }
        return tuples.get(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<byte[][]> runForList(QueryExecutor executor, String queryString, boolean wantResults) throws SQLException {
        Query query = executor.createSimpleQuery(queryString);
        SimpleResultHandler handler = new SimpleResultHandler();
        int flags = 1041;
        if (!wantResults) {
            flags |= 6;
        }
        try {
            executor.execute(query, null, handler, 0, 0, flags);
        }
        finally {
            query.close();
        }
        if (!wantResults) {
            return null;
        }
        List<byte[][]> tuples = handler.getResults();
        if (tuples == null) {
            throw new PSQLException(GT.tr("An unexpected result was returned by a query.", new Object[0]), PSQLState.CONNECTION_UNABLE_TO_CONNECT);
        }
        return tuples;
    }

    private static class SimpleResultHandler
    extends ResultHandlerBase {
        private List<byte[][]> tuples;

        private SimpleResultHandler() {
        }

        List<byte[][]> getResults() {
            return this.tuples;
        }

        @Override
        public void handleResultRows(Query fromQuery, Field[] fields, List<byte[][]> tuples, ResultCursor cursor) {
            this.tuples = tuples;
        }

        @Override
        public void handleWarning(SQLWarning warning) {
        }
    }
}

