/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.shade.org.postgresql;

import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Pattern;
import org.apache.seatunnel.shade.org.postgresql.Driver;
import org.apache.seatunnel.shade.org.postgresql.PGProperty;
import org.apache.seatunnel.shade.org.postgresql.core.QueryExecutor;
import org.apache.seatunnel.shade.org.postgresql.core.SetupQueryRunner;
import org.apache.seatunnel.shade.org.postgresql.log.Log;
import org.apache.seatunnel.shade.org.postgresql.log.Logger;
import org.apache.seatunnel.shade.org.postgresql.util.HostSpec;

public class QueryCNListUtils {
    private static Map<String, CNList> clusterCNList = new HashMap<String, CNList>();
    private static Map<String, Boolean> firstConnectMap = new ConcurrentHashMap<String, Boolean>();
    private static Log LOGGER = Logger.getLogger(QueryCNListUtils.class.getName());

    private static void setLOGGER() {
        if (!Logger.isUsingJDKLogger()) {
            LOGGER = Logger.getLogger(QueryCNListUtils.class.getName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static HostSpec[] getCNList(String key, Properties properties, boolean block) {
        int intervalWaitHasRefreshedCNList = 10;
        int timesWaitHasRefreshedCNList = 200;
        for (int i = 0; i <= timesWaitHasRefreshedCNList; ++i) {
            Map<String, CNList> map = clusterCNList;
            synchronized (map) {
                CNList coordinationNodeList = clusterCNList.get(key);
                if (coordinationNodeList != null && coordinationNodeList.list != null) {
                    return coordinationNodeList.list;
                }
            }
            if (!block) break;
            try {
                Thread.sleep(intervalWaitHasRefreshedCNList);
                continue;
            }
            catch (InterruptedException e) {
                LOGGER.info("InterruptedException. This caused by: \"Thread.sleep\", waiting for refreshing CN List from connection.");
            }
        }
        if (block) {
            LOGGER.info("Blocking time exceeds 2 seconds need to pay attention.");
        }
        return Driver.GetHostSpecs(properties);
    }

    public static String keyFromURL(Properties props) {
        Object[] hostSpecs = Driver.getURLHostSpecs(props);
        Arrays.sort(hostSpecs);
        return Arrays.toString(hostSpecs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void refreshProperties(Properties props) {
        boolean block;
        QueryCNListUtils.setLOGGER();
        String key = QueryCNListUtils.keyFromURL(props);
        Map<String, Boolean> map = firstConnectMap;
        synchronized (map) {
            block = firstConnectMap.getOrDefault(key, false);
            firstConnectMap.put(key, true);
        }
        Object[] coordinatorNodeList = QueryCNListUtils.getCNList(key, props, block);
        if (coordinatorNodeList.length == 0) {
            return;
        }
        LOGGER.info("[AUTOBALANCE] The cluster obtains CNList from the user thread. | Cluster: " + key + " | CNList: " + Arrays.toString(coordinatorNodeList));
        StringBuilder hosts = new StringBuilder();
        StringBuilder ports = new StringBuilder();
        for (Object coordinatorNode : coordinatorNodeList) {
            hosts.append(((HostSpec)coordinatorNode).getHost() + ',');
            ports.append(String.valueOf(((HostSpec)coordinatorNode).getPort()) + ',');
        }
        props.setProperty("PGHOST", hosts.substring(0, hosts.length() - 1));
        props.setProperty("PGPORT", ports.substring(0, ports.length() - 1));
    }

    private static long getTimeToRefrshCNList(Properties props) {
        String refreshCNIpListTime = props.getProperty("refreshCNIpListTime", "10");
        Pattern pattern = Pattern.compile("[0-9]+");
        if (refreshCNIpListTime != null && pattern.matcher(refreshCNIpListTime).matches() && !refreshCNIpListTime.startsWith("0") && refreshCNIpListTime.length() < 5) {
            return (long)Integer.parseInt(refreshCNIpListTime) * 1000L;
        }
        return 10000L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void runRereshCNListQueryies(QueryExecutor queryExecutor, Properties info) throws SQLException, IOException {
        long checkLatestUpdate;
        CNList cnList;
        String cluster = QueryCNListUtils.keyFromURL(info);
        long latestAllowedUpdate = System.currentTimeMillis() - QueryCNListUtils.getTimeToRefrshCNList(info);
        Map<String, CNList> map = clusterCNList;
        synchronized (map) {
            cnList = clusterCNList.get(cluster);
            if (cnList == null) {
                cnList = new CNList(null);
                clusterCNList.put(cluster, cnList);
            }
            if (cnList.lastUpdated > latestAllowedUpdate) {
                return;
            }
            checkLatestUpdate = cnList.lastUpdated = System.currentTimeMillis();
        }
        ArrayList<HostSpec> cnListRefreshed = new ArrayList<HostSpec>();
        Boolean usingEip = PGProperty.USING_EIP.getBoolean(info);
        String query = usingEip != false ? "select node_host1,node_port1 from pgxc_node where node_type='C' and nodeis_active = true order by node_host1;" : "select node_host,node_port from pgxc_node where node_type='C' and nodeis_active = true order by node_host;";
        List<byte[][]> results = SetupQueryRunner.runForList(queryExecutor, query, true);
        for (byte[][] result : results) {
            String host = queryExecutor.getEncoding().decode(result[0]);
            String port = queryExecutor.getEncoding().decode(result[1]);
            cnListRefreshed.add(new HostSpec(host, Integer.parseInt(port)));
        }
        LOGGER.info("[AUTOBALANCE] Try to refreshing CN list, the cluster: " + cnListRefreshed + " connect To: " + queryExecutor.getHostSpec());
        Map<String, CNList> map2 = clusterCNList;
        synchronized (map2) {
            if (cnList.lastUpdated > checkLatestUpdate) {
                return;
            }
            cnList.list = cnListRefreshed.toArray(new HostSpec[0]);
            LOGGER.info("[AUTOBALANCE] For refreshing CN list, the cluster: " + Arrays.toString(cnList.list) + " connect To: " + queryExecutor.getHostSpec());
            cnList.lastUpdated = System.currentTimeMillis();
        }
    }

    static class CNList {
        HostSpec[] list;
        long lastUpdated;

        CNList(HostSpec[] cnList) {
            this.list = cnList;
        }
    }
}

