/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.jdbc.source;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.seatunnel.api.serialization.Serializer;
import org.apache.seatunnel.api.source.Boundedness;
import org.apache.seatunnel.api.source.SeaTunnelSource;
import org.apache.seatunnel.api.source.SourceReader;
import org.apache.seatunnel.api.source.SourceSplitEnumerator;
import org.apache.seatunnel.api.source.SupportColumnProjection;
import org.apache.seatunnel.api.source.SupportParallelism;
import org.apache.seatunnel.api.table.catalog.CatalogTable;
import org.apache.seatunnel.api.table.catalog.TablePath;
import org.apache.seatunnel.api.table.type.SeaTunnelRow;
import org.apache.seatunnel.connectors.seatunnel.jdbc.config.JdbcSourceConfig;
import org.apache.seatunnel.connectors.seatunnel.jdbc.source.JdbcSourceReader;
import org.apache.seatunnel.connectors.seatunnel.jdbc.source.JdbcSourceSplit;
import org.apache.seatunnel.connectors.seatunnel.jdbc.source.JdbcSourceSplitEnumerator;
import org.apache.seatunnel.connectors.seatunnel.jdbc.source.JdbcSourceTable;
import org.apache.seatunnel.connectors.seatunnel.jdbc.state.JdbcSourceState;
import org.apache.seatunnel.connectors.seatunnel.jdbc.utils.JdbcCatalogUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JdbcSource
implements SeaTunnelSource<SeaTunnelRow, JdbcSourceSplit, JdbcSourceState>,
SupportParallelism,
SupportColumnProjection {
    protected static final Logger LOG = LoggerFactory.getLogger(JdbcSource.class);
    private final JdbcSourceConfig jdbcSourceConfig;
    private final Map<TablePath, JdbcSourceTable> jdbcSourceTables;

    public JdbcSource(JdbcSourceConfig jdbcSourceConfig) {
        try {
            Class.forName(jdbcSourceConfig.getJdbcConnectionConfig().getDriverName());
        }
        catch (Exception e) {
            LOG.warn("Failed to load JDBC driver {}", (Object)jdbcSourceConfig.getJdbcConnectionConfig().getDriverName(), (Object)e);
        }
        this.jdbcSourceConfig = jdbcSourceConfig;
        this.jdbcSourceTables = JdbcCatalogUtils.getTables(jdbcSourceConfig.getJdbcConnectionConfig(), jdbcSourceConfig.getTableConfigList());
    }

    public String getPluginName() {
        return "Jdbc";
    }

    public Boundedness getBoundedness() {
        return Boundedness.BOUNDED;
    }

    public List<CatalogTable> getProducedCatalogTables() {
        return this.jdbcSourceTables.values().stream().map(JdbcSourceTable::getCatalogTable).collect(Collectors.toList());
    }

    public SourceReader<SeaTunnelRow, JdbcSourceSplit> createReader(SourceReader.Context readerContext) throws Exception {
        try {
            Class.forName(this.jdbcSourceConfig.getJdbcConnectionConfig().getDriverName());
        }
        catch (Exception e) {
            LOG.warn("Failed to load JDBC driver {}", (Object)this.jdbcSourceConfig.getJdbcConnectionConfig().getDriverName(), (Object)e);
        }
        HashMap<TablePath, CatalogTable> tables = new HashMap<TablePath, CatalogTable>();
        for (TablePath tablePath : this.jdbcSourceTables.keySet()) {
            tables.put(tablePath, this.jdbcSourceTables.get(tablePath).getCatalogTable());
        }
        return new JdbcSourceReader(readerContext, this.jdbcSourceConfig, tables);
    }

    public Serializer<JdbcSourceSplit> getSplitSerializer() {
        return super.getSplitSerializer();
    }

    public SourceSplitEnumerator<JdbcSourceSplit, JdbcSourceState> createEnumerator(SourceSplitEnumerator.Context<JdbcSourceSplit> enumeratorContext) throws Exception {
        try {
            Class.forName(this.jdbcSourceConfig.getJdbcConnectionConfig().getDriverName());
        }
        catch (Exception e) {
            LOG.warn("Failed to load JDBC driver {}", (Object)this.jdbcSourceConfig.getJdbcConnectionConfig().getDriverName(), (Object)e);
        }
        return new JdbcSourceSplitEnumerator(enumeratorContext, this.jdbcSourceConfig, this.jdbcSourceTables, null);
    }

    public SourceSplitEnumerator<JdbcSourceSplit, JdbcSourceState> restoreEnumerator(SourceSplitEnumerator.Context<JdbcSourceSplit> enumeratorContext, JdbcSourceState checkpointState) throws Exception {
        try {
            Class.forName(this.jdbcSourceConfig.getJdbcConnectionConfig().getDriverName());
        }
        catch (Exception e) {
            LOG.warn("Failed to load JDBC driver {}", (Object)this.jdbcSourceConfig.getJdbcConnectionConfig().getDriverName(), (Object)e);
        }
        return new JdbcSourceSplitEnumerator(enumeratorContext, this.jdbcSourceConfig, this.jdbcSourceTables, checkpointState);
    }
}

