/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.jdbc.internal.connection;

import java.sql.Connection;
import java.sql.SQLException;
import org.apache.seatunnel.connectors.seatunnel.jdbc.config.JdbcConnectionConfig;
import org.apache.seatunnel.connectors.seatunnel.jdbc.internal.connection.JdbcConnectionProvider;
import org.apache.seatunnel.connectors.seatunnel.jdbc.sink.ConnectionPoolManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleJdbcConnectionPoolProviderProxy
implements JdbcConnectionProvider {
    private static final Logger log = LoggerFactory.getLogger(SimpleJdbcConnectionPoolProviderProxy.class);
    private final transient ConnectionPoolManager poolManager;
    private final JdbcConnectionConfig jdbcConfig;
    private final int queueIndex;

    public SimpleJdbcConnectionPoolProviderProxy(ConnectionPoolManager poolManager, JdbcConnectionConfig jdbcConfig, int queueIndex) {
        this.jdbcConfig = jdbcConfig;
        this.poolManager = poolManager;
        this.queueIndex = queueIndex;
    }

    @Override
    public Connection getConnection() {
        return this.poolManager.getConnection(this.queueIndex);
    }

    @Override
    public boolean isConnectionValid() throws SQLException {
        return this.poolManager.containsConnection(this.queueIndex) && this.poolManager.getConnection(this.queueIndex).isValid(this.jdbcConfig.getConnectionCheckTimeoutSeconds());
    }

    @Override
    public Connection getOrEstablishConnection() {
        return this.poolManager.getConnection(this.queueIndex);
    }

    @Override
    public void closeConnection() {
        if (this.poolManager.containsConnection(this.queueIndex)) {
            try {
                this.poolManager.remove(this.queueIndex).close();
            }
            catch (SQLException e) {
                log.warn("JDBC connection close failed.", (Throwable)e);
            }
        }
    }

    @Override
    public Connection reestablishConnection() {
        this.closeConnection();
        return this.getOrEstablishConnection();
    }
}

