/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.jdbc.catalog.saphana;

import com.google.auto.service.AutoService;
import java.util.Optional;
import org.apache.seatunnel.api.configuration.ReadonlyConfig;
import org.apache.seatunnel.api.configuration.util.OptionRule;
import org.apache.seatunnel.api.configuration.util.OptionValidationException;
import org.apache.seatunnel.api.table.catalog.Catalog;
import org.apache.seatunnel.api.table.factory.CatalogFactory;
import org.apache.seatunnel.api.table.factory.Factory;
import org.apache.seatunnel.common.utils.JdbcUrlUtil;
import org.apache.seatunnel.connectors.seatunnel.jdbc.catalog.saphana.SapHanaCatalog;
import org.apache.seatunnel.connectors.seatunnel.jdbc.catalog.saphana.SapHanaURLParser;
import org.apache.seatunnel.connectors.seatunnel.jdbc.config.JdbcCommonOptions;

@AutoService(value={Factory.class})
public class SapHanaCatalogFactory
implements CatalogFactory {
    public String factoryIdentifier() {
        return "SapHana";
    }

    public Catalog createCatalog(String catalogName, ReadonlyConfig options) {
        String urlWithDatabase = (String)options.get(JdbcCommonOptions.URL);
        JdbcUrlUtil.UrlInfo urlInfo = SapHanaURLParser.parse(urlWithDatabase);
        Optional defaultDatabase = urlInfo.getDefaultDatabase();
        if (!defaultDatabase.isPresent()) {
            throw new OptionValidationException(JdbcCommonOptions.URL);
        }
        return new SapHanaCatalog(catalogName, (String)options.get(JdbcCommonOptions.USERNAME), (String)options.get(JdbcCommonOptions.PASSWORD), urlInfo, (String)options.get(JdbcCommonOptions.SCHEMA), (String)options.get(JdbcCommonOptions.DRIVER));
    }

    public OptionRule optionRule() {
        return JdbcCommonOptions.BASE_CATALOG_RULE.build();
    }
}

