/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.cdc.postgres.source;

import io.debezium.jdbc.JdbcConnection;
import io.debezium.relational.TableId;
import io.debezium.relational.history.ConnectTableChangeSerializer;
import io.debezium.relational.history.TableChanges;
import io.debezium.util.SchemaNameAdjuster;
import java.time.ZoneId;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.kafka.connect.data.Struct;
import org.apache.seatunnel.api.configuration.Option;
import org.apache.seatunnel.api.configuration.ReadonlyConfig;
import org.apache.seatunnel.api.source.SupportParallelism;
import org.apache.seatunnel.api.table.catalog.CatalogTable;
import org.apache.seatunnel.common.utils.JdbcUrlUtil;
import org.apache.seatunnel.common.utils.SeaTunnelException;
import org.apache.seatunnel.connectors.cdc.base.config.JdbcSourceConfig;
import org.apache.seatunnel.connectors.cdc.base.config.SourceConfig;
import org.apache.seatunnel.connectors.cdc.base.dialect.DataSourceDialect;
import org.apache.seatunnel.connectors.cdc.base.option.JdbcSourceOptions;
import org.apache.seatunnel.connectors.cdc.base.option.StartupMode;
import org.apache.seatunnel.connectors.cdc.base.option.StopMode;
import org.apache.seatunnel.connectors.cdc.base.source.IncrementalSource;
import org.apache.seatunnel.connectors.cdc.base.source.offset.OffsetFactory;
import org.apache.seatunnel.connectors.cdc.debezium.DebeziumDeserializationSchema;
import org.apache.seatunnel.connectors.cdc.debezium.DeserializeFormat;
import org.apache.seatunnel.connectors.cdc.debezium.row.DebeziumJsonDeserializeSchema;
import org.apache.seatunnel.connectors.cdc.debezium.row.SeaTunnelRowDebeziumDeserializeSchema;
import org.apache.seatunnel.connectors.seatunnel.cdc.postgres.config.PostgresSourceConfigFactory;
import org.apache.seatunnel.connectors.seatunnel.cdc.postgres.source.PostgresDialect;
import org.apache.seatunnel.connectors.seatunnel.cdc.postgres.source.PostgresSourceOptions;
import org.apache.seatunnel.connectors.seatunnel.cdc.postgres.source.offset.LsnOffsetFactory;
import org.apache.seatunnel.connectors.seatunnel.jdbc.config.JdbcCommonOptions;

public class PostgresIncrementalSource<T>
extends IncrementalSource<T, JdbcSourceConfig>
implements SupportParallelism {
    static final String IDENTIFIER = "Postgres-CDC";

    public PostgresIncrementalSource(ReadonlyConfig options, List<CatalogTable> catalogTables) {
        super(options, catalogTables);
    }

    public String getPluginName() {
        return IDENTIFIER;
    }

    public Option<StartupMode> getStartupModeOption() {
        return PostgresSourceOptions.STARTUP_MODE;
    }

    public Option<StopMode> getStopModeOption() {
        return PostgresSourceOptions.STOP_MODE;
    }

    public SourceConfig.Factory<JdbcSourceConfig> createSourceConfigFactory(ReadonlyConfig config) {
        PostgresSourceConfigFactory configFactory = new PostgresSourceConfigFactory();
        configFactory.fromReadonlyConfig(this.readonlyConfig);
        JdbcUrlUtil.UrlInfo urlInfo = JdbcUrlUtil.getUrlInfo((String)((String)config.get(JdbcCommonOptions.URL)));
        configFactory.originUrl(urlInfo.getOrigin());
        configFactory.hostname(urlInfo.getHost());
        configFactory.port(urlInfo.getPort());
        configFactory.startupOptions(this.startupConfig);
        configFactory.stopOptions(this.stopConfig);
        return configFactory;
    }

    public DebeziumDeserializationSchema<T> createDebeziumDeserializationSchema(ReadonlyConfig config) {
        Map<TableId, Struct> tableIdTableChangeMap = this.tableChanges();
        if (DeserializeFormat.COMPATIBLE_DEBEZIUM_JSON.equals(config.get(JdbcSourceOptions.FORMAT))) {
            return new DebeziumJsonDeserializeSchema((Map)config.get(JdbcSourceOptions.DEBEZIUM_PROPERTIES), tableIdTableChangeMap);
        }
        String zoneId = (String)config.get(JdbcSourceOptions.SERVER_TIME_ZONE);
        return SeaTunnelRowDebeziumDeserializeSchema.builder().setTables(this.catalogTables).setServerTimeZone(ZoneId.of(zoneId)).setTableIdTableChangeMap(tableIdTableChangeMap).build();
    }

    public DataSourceDialect<JdbcSourceConfig> createDataSourceDialect(ReadonlyConfig config) {
        return new PostgresDialect((PostgresSourceConfigFactory)this.configFactory, this.catalogTables);
    }

    public OffsetFactory createOffsetFactory(ReadonlyConfig config) {
        return new LsnOffsetFactory((PostgresSourceConfigFactory)this.configFactory, (PostgresDialect)this.dataSourceDialect);
    }

    public Optional<String> driverName() {
        return Optional.of("org.apache.seatunnel.shade.org.postgresql.Driver");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Map<TableId, Struct> tableChanges() {
        JdbcSourceConfig jdbcSourceConfig = (JdbcSourceConfig)this.configFactory.create(0);
        PostgresDialect dialect = new PostgresDialect((PostgresSourceConfigFactory)this.configFactory, this.catalogTables);
        List<TableId> discoverTables = dialect.discoverDataCollections(jdbcSourceConfig);
        SchemaNameAdjuster adjuster = SchemaNameAdjuster.create();
        ConnectTableChangeSerializer connectTableChangeSerializer = new ConnectTableChangeSerializer(adjuster);
        try (JdbcConnection jdbcConnection = dialect.openJdbcConnection(jdbcSourceConfig);){
            Map<TableId, Struct> map = discoverTables.stream().collect(Collectors.toMap(Function.identity(), tableId -> {
                TableChanges tableChanges = new TableChanges();
                tableChanges.create(dialect.queryTableSchema(jdbcConnection, (TableId)tableId).getTable());
                return (Struct)connectTableChangeSerializer.serialize(tableChanges).get(0);
            }));
            return map;
        }
        catch (Exception e) {
            throw new SeaTunnelException((Throwable)e);
        }
    }
}

