/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.cassandra.source;

import com.datastax.oss.driver.api.core.CqlSession;
import com.datastax.oss.driver.api.core.cql.Row;
import com.google.auto.service.AutoService;
import org.apache.seatunnel.api.common.PrepareFailException;
import org.apache.seatunnel.api.common.SeaTunnelAPIErrorCode;
import org.apache.seatunnel.api.source.Boundedness;
import org.apache.seatunnel.api.source.SeaTunnelSource;
import org.apache.seatunnel.api.source.SupportColumnProjection;
import org.apache.seatunnel.api.table.type.SeaTunnelDataType;
import org.apache.seatunnel.api.table.type.SeaTunnelRow;
import org.apache.seatunnel.api.table.type.SeaTunnelRowType;
import org.apache.seatunnel.common.config.CheckConfigUtil;
import org.apache.seatunnel.common.config.CheckResult;
import org.apache.seatunnel.common.constants.PluginType;
import org.apache.seatunnel.common.exception.CommonErrorCodeDeprecated;
import org.apache.seatunnel.common.exception.SeaTunnelErrorCode;
import org.apache.seatunnel.connectors.seatunnel.cassandra.client.CassandraClient;
import org.apache.seatunnel.connectors.seatunnel.cassandra.config.CassandraConfig;
import org.apache.seatunnel.connectors.seatunnel.cassandra.config.CassandraParameters;
import org.apache.seatunnel.connectors.seatunnel.cassandra.exception.CassandraConnectorErrorCode;
import org.apache.seatunnel.connectors.seatunnel.cassandra.exception.CassandraConnectorException;
import org.apache.seatunnel.connectors.seatunnel.cassandra.source.CassandraSourceReader;
import org.apache.seatunnel.connectors.seatunnel.cassandra.util.TypeConvertUtil;
import org.apache.seatunnel.connectors.seatunnel.common.source.AbstractSingleSplitReader;
import org.apache.seatunnel.connectors.seatunnel.common.source.AbstractSingleSplitSource;
import org.apache.seatunnel.connectors.seatunnel.common.source.SingleSplitReaderContext;
import org.apache.seatunnel.shade.com.typesafe.config.Config;

@AutoService(value={SeaTunnelSource.class})
public class CassandraSource
extends AbstractSingleSplitSource<SeaTunnelRow>
implements SupportColumnProjection {
    private SeaTunnelRowType rowTypeInfo;
    private final CassandraParameters cassandraParameters = new CassandraParameters();

    public String getPluginName() {
        return "Cassandra";
    }

    public void prepare(Config pluginConfig) throws PrepareFailException {
        CheckResult checkResult = CheckConfigUtil.checkAllExists((Config)pluginConfig, (String[])new String[]{CassandraConfig.HOST.key(), CassandraConfig.KEYSPACE.key(), CassandraConfig.CQL.key()});
        if (!checkResult.isSuccess()) {
            throw new CassandraConnectorException((SeaTunnelErrorCode)SeaTunnelAPIErrorCode.CONFIG_VALIDATION_FAILED, String.format("PluginName: %s, PluginType: %s, Message: %s", this.getPluginName(), PluginType.SOURCE, checkResult.getMsg()));
        }
        this.cassandraParameters.buildWithConfig(pluginConfig);
        try (CqlSession currentSession = (CqlSession)CassandraClient.getCqlSessionBuilder(pluginConfig.getString(CassandraConfig.HOST.key()), pluginConfig.getString(CassandraConfig.KEYSPACE.key()), this.cassandraParameters.getUsername(), this.cassandraParameters.getPassword(), this.cassandraParameters.getDatacenter()).build();){
            Row rs = (Row)currentSession.execute(CassandraClient.createSimpleStatement(pluginConfig.getString(CassandraConfig.CQL.key()), this.cassandraParameters.getConsistencyLevel())).one();
            if (rs == null) {
                throw new CassandraConnectorException((SeaTunnelErrorCode)CassandraConnectorErrorCode.NO_DATA_IN_SOURCE_TABLE, "No data select from this cql: " + pluginConfig.getConfig(CassandraConfig.CQL.key()));
            }
            int columnSize = rs.getColumnDefinitions().size();
            String[] fieldNames = new String[columnSize];
            SeaTunnelDataType[] seaTunnelDataTypes = new SeaTunnelDataType[columnSize];
            for (int i = 0; i < columnSize; ++i) {
                fieldNames[i] = rs.getColumnDefinitions().get(i).getName().asInternal();
                seaTunnelDataTypes[i] = TypeConvertUtil.convert(rs.getColumnDefinitions().get(i).getType());
            }
            this.rowTypeInfo = new SeaTunnelRowType(fieldNames, seaTunnelDataTypes);
        }
        catch (Exception e) {
            throw new CassandraConnectorException((SeaTunnelErrorCode)CommonErrorCodeDeprecated.TABLE_SCHEMA_GET_FAILED, "Get table schema from cassandra source data failed", e);
        }
    }

    public Boundedness getBoundedness() {
        return Boundedness.BOUNDED;
    }

    public SeaTunnelDataType<SeaTunnelRow> getProducedType() {
        return this.rowTypeInfo;
    }

    @Override
    public AbstractSingleSplitReader<SeaTunnelRow> createReader(SingleSplitReaderContext readerContext) throws Exception {
        return new CassandraSourceReader(this.cassandraParameters, readerContext);
    }
}

