/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.schema.registry.common.utils;

import com.google.common.base.Preconditions;
import org.apache.rocketmq.schema.registry.common.exception.SchemaException;
import org.apache.rocketmq.schema.registry.common.properties.GlobalConfig;
import org.apache.rocketmq.schema.registry.common.utils.IdGenerator;

public class SnowFlakeIdGenerator
implements IdGenerator {
    private final long regionId;
    private final long nodeId;
    private long sequenceId = 0L;
    private long lastTimestamp = -1L;
    private final long startTime = 1640966400000L;
    private final long regionIdBits = 3L;
    private final long nodeIdBits = 4L;
    private final long maxRegionId = 7L;
    private final long maxNodeId = 15L;
    private final long sequenceIdBits = 1L;
    private final long recordIdBits = 14L;
    private final long sequenceIdMoveBits = 14L;
    private final long nodeIdMoveBits = 15L;
    private final long regionIdMoveBits = 19L;
    private final long timestampMoveBits = 22L;
    private final long sequenceIdMask = 1L;

    public SnowFlakeIdGenerator(GlobalConfig config) {
        this.regionId = config.getServiceRegionId();
        this.nodeId = config.getServiceNodeId();
        Preconditions.checkArgument((this.nodeId <= 15L && this.nodeId >= 0L ? 1 : 0) != 0, (String)"The NodeId can not be greater than %d or less than 0", (long)15L);
        Preconditions.checkArgument((this.regionId <= 7L && this.regionId >= 0L ? 1 : 0) != 0, (String)"The RegionId can not be greater than %d or less than 0", (long)7L);
    }

    @Override
    public synchronized long nextId() {
        long timestamp = System.currentTimeMillis();
        if (timestamp < this.lastTimestamp) {
            throw new SchemaException("SchemaId generating error, clock moved backwards, please try later");
        }
        if (this.lastTimestamp == timestamp) {
            this.sequenceId = this.sequenceId + 1L & 1L;
            if (this.sequenceId == 0L) {
                timestamp = this.waitNextMillis(this.lastTimestamp);
            }
        } else {
            this.sequenceId = 0L;
        }
        this.lastTimestamp = timestamp;
        return timestamp - 1640966400000L << 22 | this.regionId << 19 | this.nodeId << 15 | this.sequenceId << 14;
    }

    private long waitNextMillis(long lastTimestamp) {
        long timestamp = System.currentTimeMillis();
        while (timestamp <= lastTimestamp) {
            timestamp = System.currentTimeMillis();
        }
        return timestamp;
    }
}

