/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.schema.registry.common.model;

import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.rocketmq.schema.registry.common.QualifiedName;
import org.apache.rocketmq.schema.registry.common.model.AuditInfo;
import org.apache.rocketmq.schema.registry.common.model.BaseInfo;
import org.apache.rocketmq.schema.registry.common.model.Dependency;
import org.apache.rocketmq.schema.registry.common.model.SchemaDetailInfo;
import org.apache.rocketmq.schema.registry.common.model.SchemaMetaInfo;
import org.apache.rocketmq.schema.registry.common.model.SchemaRecordInfo;
import org.apache.rocketmq.schema.registry.common.model.SchemaStorageInfo;
import org.apache.rocketmq.schema.registry.common.model.SchemaType;

public class SchemaInfo
extends BaseInfo {
    private static final long serialVersionUID = -5143258312429353896L;
    private SchemaMetaInfo meta = new SchemaMetaInfo();
    private SchemaDetailInfo details = new SchemaDetailInfo();
    private SchemaStorageInfo storage = new SchemaStorageInfo();
    private Map<String, String> extras = new HashMap<String, String>();

    public SchemaInfo(QualifiedName qualifiedName, AuditInfo audit, SchemaMetaInfo meta, SchemaDetailInfo details) {
        super(qualifiedName, audit);
        this.meta = meta;
        this.details = details;
    }

    public String getSchemaName() {
        return this.getQualifiedName().getSchema();
    }

    public String getNamespace() {
        return this.getMeta().getNamespace();
    }

    public SchemaType getSchemaType() {
        return this.getMeta().getType();
    }

    public SchemaRecordInfo getLastRecord() {
        return this.getDetails().lastRecord();
    }

    public String getLastRecordIdl() {
        return this.getLastRecord().getIdl();
    }

    public long getUniqueId() {
        return this.getMeta().getUniqueId();
    }

    public void setUniqueId(long uniqueId) {
        this.getMeta().setUniqueId(uniqueId);
        this.getLastRecord().setSchemaId(uniqueId);
    }

    public void setLastRecordDependency(Dependency dependency) {
        this.getLastRecord().setDependency(dependency);
    }

    public long getLastRecordVersion() {
        return this.getLastRecord().getVersion();
    }

    public int getRecordCount() {
        return this.getDetails().getSchemaRecords().size();
    }

    public Date getLastModifiedTime() {
        return this.getAudit() != null ? this.getAudit().getLastModifiedTime() : null;
    }

    public void setLastModifiedTime(Date date) {
        if (this.getAudit() != null) {
            this.getAudit().setLastModifiedTime(date);
        }
    }

    public List<String> getAllRecordIdlInOrder() {
        List<String> recordIdlList = this.getDetails().getSchemaRecords().stream().map(SchemaRecordInfo::getIdl).collect(Collectors.toList());
        Collections.reverse(recordIdlList);
        return recordIdlList;
    }

    public static SchemaInfoBuilder builder() {
        return new SchemaInfoBuilder();
    }

    public SchemaMetaInfo getMeta() {
        return this.meta;
    }

    public SchemaDetailInfo getDetails() {
        return this.details;
    }

    public SchemaStorageInfo getStorage() {
        return this.storage;
    }

    public Map<String, String> getExtras() {
        return this.extras;
    }

    public void setMeta(SchemaMetaInfo meta) {
        this.meta = meta;
    }

    public void setDetails(SchemaDetailInfo details) {
        this.details = details;
    }

    public void setStorage(SchemaStorageInfo storage) {
        this.storage = storage;
    }

    public void setExtras(Map<String, String> extras) {
        this.extras = extras;
    }

    @Override
    public String toString() {
        return "SchemaInfo(meta=" + this.getMeta() + ", details=" + this.getDetails() + ", storage=" + this.getStorage() + ", extras=" + this.getExtras() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SchemaInfo)) {
            return false;
        }
        SchemaInfo other = (SchemaInfo)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        SchemaMetaInfo this$meta = this.getMeta();
        SchemaMetaInfo other$meta = other.getMeta();
        if (this$meta == null ? other$meta != null : !((Object)this$meta).equals(other$meta)) {
            return false;
        }
        SchemaDetailInfo this$details = this.getDetails();
        SchemaDetailInfo other$details = other.getDetails();
        if (this$details == null ? other$details != null : !((Object)this$details).equals(other$details)) {
            return false;
        }
        SchemaStorageInfo this$storage = this.getStorage();
        SchemaStorageInfo other$storage = other.getStorage();
        if (this$storage == null ? other$storage != null : !((Object)this$storage).equals(other$storage)) {
            return false;
        }
        Map<String, String> this$extras = this.getExtras();
        Map<String, String> other$extras = other.getExtras();
        return !(this$extras == null ? other$extras != null : !((Object)this$extras).equals(other$extras));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof SchemaInfo;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        SchemaMetaInfo $meta = this.getMeta();
        result = result * 59 + ($meta == null ? 43 : ((Object)$meta).hashCode());
        SchemaDetailInfo $details = this.getDetails();
        result = result * 59 + ($details == null ? 43 : ((Object)$details).hashCode());
        SchemaStorageInfo $storage = this.getStorage();
        result = result * 59 + ($storage == null ? 43 : ((Object)$storage).hashCode());
        Map<String, String> $extras = this.getExtras();
        result = result * 59 + ($extras == null ? 43 : ((Object)$extras).hashCode());
        return result;
    }

    public SchemaInfo(SchemaMetaInfo meta, SchemaDetailInfo details, SchemaStorageInfo storage, Map<String, String> extras) {
        this.meta = meta;
        this.details = details;
        this.storage = storage;
        this.extras = extras;
    }

    public SchemaInfo() {
    }

    public static class SchemaInfoBuilder {
        private SchemaMetaInfo meta;
        private SchemaDetailInfo details;
        private SchemaStorageInfo storage;
        private Map<String, String> extras;

        SchemaInfoBuilder() {
        }

        public SchemaInfoBuilder meta(SchemaMetaInfo meta) {
            this.meta = meta;
            return this;
        }

        public SchemaInfoBuilder details(SchemaDetailInfo details) {
            this.details = details;
            return this;
        }

        public SchemaInfoBuilder storage(SchemaStorageInfo storage) {
            this.storage = storage;
            return this;
        }

        public SchemaInfoBuilder extras(Map<String, String> extras) {
            this.extras = extras;
            return this;
        }

        public SchemaInfo build() {
            return new SchemaInfo(this.meta, this.details, this.storage, this.extras);
        }

        public String toString() {
            return "SchemaInfo.SchemaInfoBuilder(meta=" + this.meta + ", details=" + this.details + ", storage=" + this.storage + ", extras=" + this.extras + ")";
        }
    }
}

